/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.syncope.client.AbstractBaseBean;
import org.syncope.client.to.VirtualSchemaTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.AbstractSchemaModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;

public class VirtualSchemaModalPage
extends AbstractSchemaModalPage {
    private static final long serialVersionUID = 5979623248182851337L;

    public VirtualSchemaModalPage(String kind) {
        super(kind);
    }

    @Override
    public void setSchemaModalPage(final PageReference callerPageRef, final ModalWindow window, AbstractBaseBean schema, final boolean createFlag) {
        if (schema == null) {
            schema = new VirtualSchemaTO();
        }
        Form schemaForm = new Form("form");
        schemaForm.setModel((IModel)new CompoundPropertyModel((Object)schema));
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", this.getString("name"), (IModel<String>)new PropertyModel((Object)schema, "name"), false);
        name.addRequiredLabel();
        name.setEnabled(createFlag);
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                VirtualSchemaTO schemaTO = (VirtualSchemaTO)form.getDefaultModelObject();
                try {
                    if (createFlag) {
                        VirtualSchemaModalPage.this.restClient.createVirtualSchema(VirtualSchemaModalPage.this.kind, schemaTO);
                    } else {
                        VirtualSchemaModalPage.this.restClient.updateVirtualSchema(VirtualSchemaModalPage.this.kind, schemaTO);
                    }
                    if (callerPageRef.getPage() instanceof BasePage) {
                        ((BasePage)callerPageRef.getPage()).setModalResult(true);
                    }
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                    target.add(new Component[]{VirtualSchemaModalPage.this.feedbackPanel});
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{VirtualSchemaModalPage.this.feedbackPanel});
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Schema", "create") : this.xmlRolesReader.getAllAllowedRoles("Schema", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        schemaForm.add(new Component[]{name});
        schemaForm.add(new Component[]{submit});
        this.add(new Component[]{schemaForm});
    }
}

