/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.to.AccountPolicyTO;
import org.syncope.client.to.PasswordPolicyTO;
import org.syncope.client.to.PolicyTO;
import org.syncope.client.to.SyncPolicyTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.PolicyModalPage;
import org.syncope.console.rest.PolicyRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;
import org.syncope.types.PolicyType;

public class PoliciesPanel
extends Panel {
    protected static final Logger LOG = LoggerFactory.getLogger(PoliciesPanel.class);
    private static final int MODAL_WIN_HEIGHT = 400;
    private static final int MODAL_WIN_WIDTH = 1000;
    private static final long serialVersionUID = -6804066913177804275L;
    @SpringBean
    private PolicyRestClient policyRestClient;
    @SpringBean
    protected XMLRolesReader xmlRolesReader;
    @SpringBean
    private PreferenceManager prefMan;
    private final int paginatorRows;
    protected boolean modalResult;
    private PolicyType policyType;

    public PoliciesPanel(String id, final PolicyType policyType) {
        super(id);
        this.paginatorRows = this.prefMan.getPaginatorRows((Request)this.getWebRequest(), "policy.paginator.rows");
        this.modalResult = false;
        this.policyType = policyType;
        final ModalWindow mwindow = new ModalWindow("editModalWin");
        mwindow.setCssClassName("w_silver");
        mwindow.setInitialHeight(400);
        mwindow.setInitialWidth(1000);
        mwindow.setCookieName("policy-modal");
        this.add(new Component[]{mwindow});
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.setWindowClosedCallback(mwindow, container);
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), "id", "id"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("description"), "description", "description"));
        columns.add(new AbstractColumn<PolicyTO>((IModel)new ResourceModel("type")){
            private static final long serialVersionUID = 8263694778917279290L;

            public void populateItem(Item<ICellPopulator<PolicyTO>> cellItem, String componentId, IModel<PolicyTO> model) {
                cellItem.add(new Component[]{new Label(componentId, PoliciesPanel.this.getString(((PolicyTO)model.getObject()).getType().name()))});
            }
        });
        columns.add(new AbstractColumn<PolicyTO>((IModel)new ResourceModel("edit")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<PolicyTO>> cellItem, String componentId, IModel<PolicyTO> model) {
                final PolicyTO accountPolicyTO = (PolicyTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        mwindow.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                PolicyModalPage<PolicyTO> page = new PolicyModalPage<PolicyTO>(mwindow, accountPolicyTO);
                                return page;
                            }
                        });
                        mwindow.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)PoliciesPanel.this.xmlRolesReader.getAllAllowedRoles("Policies", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<PolicyTO>((IModel)new ResourceModel("delete")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<PolicyTO>> cellItem, String componentId, IModel<PolicyTO> model) {
                final PolicyTO accountPolicyTO = (PolicyTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            PoliciesPanel.this.policyRestClient.delete(accountPolicyTO.getId());
                            this.info((Serializable)((Object)this.getString("operation_succeded")));
                        }
                        catch (SyncopeClientCompositeErrorException e) {
                            this.error((Serializable)((Object)this.getString("operation_error")));
                            LOG.error("While deleting resource {}({})", (Object)new Object[]{accountPolicyTO.getId(), accountPolicyTO.getDescription()}, (Object)e);
                        }
                        target.add(new Component[]{container});
                        target.add(new Component[]{this.getPage().get("feedback")});
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)PoliciesPanel.this.xmlRolesReader.getAllAllowedRoles("Policies", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, (ISortableDataProvider)new PolicyDataProvider(), this.paginatorRows);
        container.add(new Component[]{table});
        IndicatingAjaxLink createButton = new IndicatingAjaxLink("createLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                mwindow.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        PolicyModalPage<PolicyTO> page = new PolicyModalPage<PolicyTO>(mwindow, PoliciesPanel.this.getPolicyTOInstance(policyType));
                        return page;
                    }
                });
                mwindow.show(target);
            }
        };
        this.add(new Component[]{createButton});
        MetaDataRoleAuthorizationStrategy.authorize((Component)createButton, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Policies", "create"));
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                PoliciesPanel.this.prefMan.set((Request)PoliciesPanel.this.getWebRequest(), (Response)((WebResponse)PoliciesPanel.this.getResponse()), "policy.paginator.rows", String.valueOf(PoliciesPanel.this.paginatorRows));
                table.setItemsPerPage(PoliciesPanel.this.paginatorRows);
                target.add(new Component[]{container});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    private void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                target.add(new Component[]{container});
            }
        });
    }

    private PolicyTO getPolicyTOInstance(PolicyType policyType) {
        AccountPolicyTO policyTO;
        switch (policyType) {
            case GLOBAL_ACCOUNT: {
                policyTO = new AccountPolicyTO(true);
                break;
            }
            case ACCOUNT: {
                policyTO = new AccountPolicyTO();
                break;
            }
            case GLOBAL_PASSWORD: {
                policyTO = new PasswordPolicyTO(true);
                break;
            }
            case PASSWORD: {
                policyTO = new PasswordPolicyTO();
                break;
            }
            case GLOBAL_SYNC: {
                policyTO = new SyncPolicyTO(true);
                break;
            }
            default: {
                policyTO = new SyncPolicyTO();
            }
        }
        return policyTO;
    }

    private class PolicyDataProvider
    extends SortableDataProvider<PolicyTO> {
        private static final long serialVersionUID = -6976327453925166730L;
        private SortableDataProviderComparator comparator;

        public PolicyDataProvider() {
            this.setSort("description", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<PolicyTO>(this);
        }

        public int size() {
            return PoliciesPanel.this.policyRestClient.getPolicies(PoliciesPanel.this.policyType).size();
        }

        public Iterator<PolicyTO> iterator(int first, int count) {
            List policies = PoliciesPanel.this.policyRestClient.getPolicies(PoliciesPanel.this.policyType);
            Collections.sort(policies, this.comparator);
            return policies.subList(first, first + count).iterator();
        }

        public IModel<PolicyTO> model(PolicyTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

