/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.syncope.client.SchemaList;
import org.syncope.client.to.SchemaTO;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AbstractFieldPanel;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxPalettePanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.MultiValueSelectorPanel;
import org.syncope.types.AbstractPolicySpec;
import org.syncope.types.ConflictResolutionAction;

public class PolicyBeanPanel
extends Panel {
    protected static final Logger LOG = LoggerFactory.getLogger(PolicyBeanPanel.class);
    private static final long serialVersionUID = -3035998190456928143L;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    final IModel<List<String>> schemas = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected List<String> load() {
            List<SchemaTO> schemaTOs = PolicyBeanPanel.this.schemaRestClient.getSchemas("user");
            ArrayList<String> schemas = new ArrayList<String>();
            for (SchemaTO schemaTO : schemaTOs) {
                schemas.add(schemaTO.getName());
            }
            return schemas;
        }
    };
    @SpringBean
    protected XMLRolesReader xmlRolesReader;

    public PolicyBeanPanel(String id, final AbstractPolicySpec policy) {
        super(id);
        FieldWrapper fieldWrapper = null;
        ArrayList<FieldWrapper> items = new ArrayList<FieldWrapper>();
        for (Field field : policy.getClass().getDeclaredFields()) {
            if ("serialVersionUID".equals(field.getName())) continue;
            fieldWrapper = new FieldWrapper();
            fieldWrapper.setName(field.getName());
            fieldWrapper.setType(field.getType());
            SchemaList schemaList = field.getAnnotation(SchemaList.class);
            fieldWrapper.setSchemaList(schemaList);
            items.add(fieldWrapper);
        }
        ListView<FieldWrapper> policies = new ListView<FieldWrapper>("policies", items){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<FieldWrapper> item) {
                FieldWrapper field = (FieldWrapper)item.getModelObject();
                item.add(new Component[]{new Label("label", (IModel)new ResourceModel(field.getName()))});
                try {
                    if (field.getType().equals(ConflictResolutionAction.class)) {
                        Method classMethod = policy.getClass().getMethod("get" + StringUtils.capitalize((String)field.getName()), new Class[0]);
                        AjaxDropDownChoicePanel<ConflictResolutionAction> component = new AjaxDropDownChoicePanel<ConflictResolutionAction>("field", field.getName(), (IModel<ConflictResolutionAction>)new PropertyModel((Object)policy, field.getName()), false);
                        component.setChoices(Arrays.asList(ConflictResolutionAction.values()));
                        item.add(new Component[]{component});
                        item.add(new Component[]{PolicyBeanPanel.this.getActivationControl(component, (Enum)classMethod.invoke((Object)policy, new Object[0]) != null, (Serializable)ConflictResolutionAction.IGNORE, (Serializable)ConflictResolutionAction.IGNORE)});
                    } else if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                        item.add(new Component[]{new AjaxCheckBoxPanel("check", field.getName(), (IModel<Boolean>)new PropertyModel((Object)policy, field.getName()), false)});
                        item.add(new Component[]{new Label("field", (IModel)new Model(null))});
                    } else if (field.getType().equals(List.class) || field.getType().equals(Set.class)) {
                        Method classMethod = policy.getClass().getMethod("get" + StringUtils.capitalize((String)field.getName()), new Class[0]);
                        if (field.getSchemaList() != null) {
                            List values = (List)PolicyBeanPanel.this.schemas.getObject();
                            if (field.getSchemaList().extended()) {
                                values.add("id");
                                values.add("username");
                            }
                            AjaxPalettePanel component = new AjaxPalettePanel("field", new PropertyModel((Object)policy, field.getName()), new ListModel(values));
                            item.add(new Component[]{component});
                            item.add(new Component[]{PolicyBeanPanel.this.getActivationControl(component, !((List)classMethod.invoke((Object)policy, new Object[0])).isEmpty(), new ArrayList(), new ArrayList())});
                        } else {
                            AjaxTextFieldPanel panel = new AjaxTextFieldPanel("panel", field.getName(), (IModel<String>)new Model(null), true);
                            panel.setRequired(true);
                            MultiValueSelectorPanel component = new MultiValueSelectorPanel("field", new PropertyModel((Object)policy, field.getName()), String.class, panel);
                            item.add(new Component[]{component});
                            ArrayList<String> reinitializedValue = new ArrayList<String>();
                            reinitializedValue.add("");
                            item.add(new Component[]{PolicyBeanPanel.this.getActivationControl(component, !((List)classMethod.invoke((Object)policy, new Object[0])).isEmpty(), new ArrayList(), reinitializedValue)});
                        }
                    } else if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                        Method classMethod = policy.getClass().getMethod("get" + StringUtils.capitalize((String)field.getName()), new Class[0]);
                        AjaxTextFieldPanel component = new AjaxTextFieldPanel("field", field.getName(), (IModel<String>)new PropertyModel((Object)policy, field.getName()), false);
                        item.add(new Component[]{component});
                        item.add(new Component[]{PolicyBeanPanel.this.getActivationControl(component, (Integer)classMethod.invoke((Object)policy, new Object[0]) > 0, Integer.valueOf(0), Integer.valueOf(0))});
                    } else {
                        item.add(new Component[]{new AjaxCheckBoxPanel("check", field.getName(), (IModel<Boolean>)new Model(), false)});
                        item.add(new Component[]{new Label("field", (IModel)new Model(null))});
                    }
                }
                catch (Exception e) {
                    LOG.error("Error retrieving policy fields", (Throwable)e);
                }
            }
        };
        this.add(new Component[]{policies});
    }

    private <T extends Serializable> AjaxCheckBoxPanel getActivationControl(final AbstractFieldPanel panel, Boolean checked, final T defaultModelObject, final T reinitializedValue) {
        final AjaxCheckBoxPanel check = new AjaxCheckBoxPanel("check", "check", (IModel<Boolean>)new Model((Serializable)checked), false);
        panel.setEnabled(checked);
        check.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onChange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (((Boolean)check.getModelObject()).booleanValue()) {
                    panel.setEnabled(true);
                    panel.setModelObject(reinitializedValue);
                } else {
                    panel.setModelObject(defaultModelObject);
                    panel.setEnabled(false);
                }
                target.add(new Component[]{panel});
            }
        }});
        return check;
    }

    private class FieldWrapper
    implements Serializable {
        private static final long serialVersionUID = -6770429509752964215L;
        private Class type;
        private String name;
        private SchemaList schemaList;

        private FieldWrapper() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class getType() {
            return this.type;
        }

        public void setType(Class type) {
            this.type = type;
        }

        public SchemaList getSchemaList() {
            return this.schemaList;
        }

        public void setSchemaList(SchemaList schemaList) {
            this.schemaList = schemaList;
        }
    }
}

