/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.event.IEventSource;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.search.NodeCond;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.UserTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.UserDataProvider;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.DisplayAttributesModalPage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.rest.UserRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.syncope.console.wicket.extensions.markup.html.repeater.data.table.TokenColumn;
import org.syncope.console.wicket.extensions.markup.html.repeater.data.table.UserAttrColumn;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;

public class ResultSetPanel
extends Panel
implements IEventSource {
    private static final long serialVersionUID = -9170191461250434024L;
    private static final Logger LOG = LoggerFactory.getLogger(ResultSetPanel.class);
    private static final int EDIT_MODAL_WIN_HEIGHT = 550;
    private static final int EDIT_MODAL_WIN_WIDTH = 800;
    private static final int DISPLAYATTRS_MODAL_WIN_HEIGHT = 550;
    private static final int DISPLAYATTRS_MODAL_WIN_WIDTH = 550;
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private PreferenceManager preferences;
    @SpringBean
    protected XMLRolesReader xmlRolesReader;
    private int rows;
    protected final WebMarkupContainer container;
    private final FeedbackPanel feedbackPanel;
    private boolean filtered;
    private NodeCond filter;
    private AjaxFallbackDefaultDataTable<UserTO> resultTable;
    private UserDataProvider dataProvider;
    private final ModalWindow editmodal = new ModalWindow("editModal");
    private final BasePage page;

    public <T extends AbstractAttributableTO> ResultSetPanel(String id, boolean filtered, NodeCond searchCond, PageReference callerRef) {
        super(id);
        this.setOutputMarkupId(true);
        this.page = (BasePage)callerRef.getPage();
        this.filtered = filtered;
        this.filter = searchCond;
        this.feedbackPanel = this.page.getFeedbackPanel();
        this.editmodal.setCssClassName("w_silver");
        this.editmodal.setInitialHeight(550);
        this.editmodal.setInitialWidth(800);
        this.editmodal.setCookieName("edit-modal");
        this.add(new Component[]{this.editmodal});
        final ModalWindow displaymodal = new ModalWindow("displayModal");
        displaymodal.setCssClassName("w_silver");
        displaymodal.setInitialHeight(550);
        displaymodal.setInitialWidth(550);
        displaymodal.setCookieName("display-modal");
        this.add(new Component[]{displaymodal});
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.updateResultTable(false);
        IndicatingAjaxLink displayAttrsLink = new IndicatingAjaxLink("displayAttrsLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                displaymodal.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new DisplayAttributesModalPage(ResultSetPanel.this.page.getPageReference(), displaymodal);
                    }
                });
                displaymodal.show(target);
            }
        };
        displayAttrsLink.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1469628524240283489L;

            public void onComponentTag(Component component, ComponentTag tag) {
                if (ResultSetPanel.this.resultTable.getRowCount() > ResultSetPanel.this.rows) {
                    tag.remove("class");
                    tag.put("class", (CharSequence)"settingsPosMultiPage");
                } else {
                    tag.remove("class");
                    tag.put("class", (CharSequence)"settingsPos");
                }
            }
        }});
        MetaDataRoleAuthorizationStrategy.authorize((Component)displayAttrsLink, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Users", "changeView"));
        this.container.add(new Component[]{displayAttrsLink});
        Form paginatorForm = new Form("paginator");
        this.container.add(new Component[]{paginatorForm});
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "rows"), this.preferences.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                ResultSetPanel.this.preferences.set(ResultSetPanel.this.getRequest(), ResultSetPanel.this.getResponse(), "users.paginator.rows", String.valueOf(ResultSetPanel.this.rows));
                EventDataWrapper data = new EventDataWrapper();
                data.setTarget(target);
                ResultSetPanel.this.send((IEventSink)ResultSetPanel.this.getParent(), Broadcast.BREADTH, data);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.setWindowClosedReloadCallback(this.editmodal);
        this.setWindowClosedReloadCallback(displaymodal);
    }

    public void search(NodeCond searchCond, AjaxRequestTarget target) {
        this.filter = searchCond;
        this.dataProvider.setSearchCond(this.filter);
        target.add(new Component[]{this.container});
    }

    private void updateResultTable(boolean create) {
        this.rows = this.preferences.getPaginatorRows(this.getRequest(), "users.paginator.rows");
        this.dataProvider = new UserDataProvider(this.userRestClient, this.rows, this.filtered);
        this.dataProvider.setSearchCond(this.filter);
        int currentPage = this.resultTable != null ? (create ? this.resultTable.getPageCount() - 1 : this.resultTable.getCurrentPage()) : 0;
        this.resultTable = new AjaxFallbackDefaultDataTable("resultTable", this.getColumns(), (ISortableDataProvider)this.dataProvider, this.rows);
        this.resultTable.setCurrentPage(currentPage);
        this.resultTable.setOutputMarkupId(true);
        this.container.addOrReplace(new Component[]{this.resultTable});
    }

    private List<IColumn<UserTO>> getColumns() {
        ArrayList<IColumn<UserTO>> columns = new ArrayList<IColumn<UserTO>>();
        for (String name : this.preferences.getList(this.getRequest(), "users.details.view")) {
            Field field = null;
            try {
                field = UserTO.class.getDeclaredField(name);
            }
            catch (Exception ue) {
                LOG.debug("Error retrieving UserTO field {}", (Object)name, (Object)ue);
                try {
                    field = AbstractAttributableTO.class.getDeclaredField(name);
                }
                catch (Exception aae) {
                    LOG.error("Error retrieving AbstractAttributableTO field {}", (Object)name, (Object)aae);
                }
            }
            if ("token".equalsIgnoreCase(name)) {
                columns.add((IColumn<UserTO>)new TokenColumn("token"));
                continue;
            }
            if (field != null && field.getType().equals(Date.class)) {
                columns.add((IColumn<UserTO>)new DatePropertyColumn((IModel<String>)new ResourceModel(name, name), name, name));
                continue;
            }
            columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new ResourceModel(name, name), name, name));
        }
        for (String name : this.preferences.getList(this.getRequest(), "users.attributes.view")) {
            columns.add((IColumn<UserTO>)new UserAttrColumn(name, UserAttrColumn.SchemaType.schema));
        }
        for (String name : this.preferences.getList(this.getRequest(), "users.derived.attributes.view")) {
            columns.add((IColumn<UserTO>)new UserAttrColumn(name, UserAttrColumn.SchemaType.derivedSchema));
        }
        for (String name : this.preferences.getList(this.getRequest(), "users.virtual.attributes.view")) {
            columns.add((IColumn<UserTO>)new UserAttrColumn(name, UserAttrColumn.SchemaType.virtualSchema));
        }
        if (columns.isEmpty()) {
            columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new ResourceModel("id", "id"), "id", "id"));
            columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new ResourceModel("username", "username"), "username", "username"));
            columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new ResourceModel("status", "status"), "status", "status"));
        }
        columns.add((IColumn<UserTO>)new AbstractColumn<UserTO>((IModel)new ResourceModel("edit")){
            private static final long serialVersionUID = 2054811145491901166L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<UserTO>> cellItem, String componentId, final IModel<UserTO> model) {
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)ResultSetPanel.this.xmlRolesReader.getAllAllowedRoles("Users", "read"));
                panel.add(new Component[]{new IndicatingAjaxLink("editLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        ResultSetPanel.this.editmodal.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new UserModalPage(ResultSetPanel.this.page.getPageReference(), ResultSetPanel.this.editmodal, (UserTO)model.getObject(), UserModalPage.Mode.ADMIN);
                            }
                        });
                        ResultSetPanel.this.editmodal.show(target);
                    }
                }});
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add((IColumn<UserTO>)new AbstractColumn<UserTO>((IModel)new ResourceModel("delete")){
            private static final long serialVersionUID = 2054811145491901166L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<UserTO>> cellItem, String componentId, final IModel<UserTO> model) {
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)ResultSetPanel.this.xmlRolesReader.getAllAllowedRoles("Users", "delete"));
                panel.add(new Component[]{new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            ResultSetPanel.this.userRestClient.delete(((UserTO)model.getObject()).getId());
                            this.info((Serializable)((Object)this.getString("operation_succeded")));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{ResultSetPanel.this.feedbackPanel});
                        EventDataWrapper data = new EventDataWrapper();
                        data.setTarget(target);
                        this.send((IEventSink)this.getPage(), Broadcast.BREADTH, data);
                    }
                }});
                cellItem.add(new Component[]{panel});
            }
        });
        return columns;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof EventDataWrapper) {
            EventDataWrapper data = (EventDataWrapper)event.getPayload();
            AjaxRequestTarget target = data.getTarget();
            this.updateResultTable(data.isCreate());
            target.add(new Component[]{this.container});
        }
    }

    private void setWindowClosedReloadCallback(ModalWindow window) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                EventDataWrapper data = new EventDataWrapper();
                data.setTarget(target);
                ResultSetPanel.this.send((IEventSink)ResultSetPanel.this.getParent(), Broadcast.BREADTH, data);
                if (ResultSetPanel.this.page.isModalResult()) {
                    ResultSetPanel.this.page.setModalResult(false);
                    ResultSetPanel.this.getSession().info((Serializable)((Object)ResultSetPanel.this.getString("operation_succeded")));
                    target.add(new Component[]{ResultSetPanel.this.feedbackPanel});
                }
            }
        });
    }

    public static class EventDataWrapper {
        private AjaxRequestTarget target;
        private boolean create;

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public void setTarget(AjaxRequestTarget target) {
            this.target = target;
        }

        public boolean isCreate() {
            return this.create;
        }

        public void setCreate(boolean create) {
            this.create = create;
        }
    }
}

