/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.PolicyTO;
import org.syncope.console.rest.PolicyRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.types.PolicyType;

public class RoleSecurityPanel
extends Panel {
    protected static final Logger LOG = LoggerFactory.getLogger(RoleSecurityPanel.class);
    private static final long serialVersionUID = -7982691107029848579L;
    @SpringBean
    private PolicyRestClient policyRestClient;
    IModel<Map<Long, String>> passwordPolicies = null;
    IModel<Map<Long, String>> accountPolicies = null;

    public <T extends AbstractAttributableTO> RoleSecurityPanel(String id, T entityTO) {
        super(id);
        this.setOutputMarkupId(true);
        this.passwordPolicies = new LoadableDetachableModel<Map<Long, String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected Map<Long, String> load() {
                HashMap<Long, String> res = new HashMap<Long, String>();
                for (PolicyTO policyTO : RoleSecurityPanel.this.policyRestClient.getPolicies(PolicyType.PASSWORD)) {
                    res.put(policyTO.getId(), policyTO.getDescription());
                }
                return res;
            }
        };
        this.accountPolicies = new LoadableDetachableModel<Map<Long, String>>(){
            private static final long serialVersionUID = -2012833443695917883L;

            protected Map<Long, String> load() {
                HashMap<Long, String> res = new HashMap<Long, String>();
                for (PolicyTO policyTO : RoleSecurityPanel.this.policyRestClient.getPolicies(PolicyType.ACCOUNT)) {
                    res.put(policyTO.getId(), policyTO.getDescription());
                }
                return res;
            }
        };
        WebMarkupContainer securityContainer = new WebMarkupContainer("security");
        securityContainer.setOutputMarkupId(true);
        this.add(new Component[]{securityContainer});
        final AjaxDropDownChoicePanel passwordPolicy = new AjaxDropDownChoicePanel("passwordPolicy", "passwordPolicy", new PropertyModel(entityTO, "passwordPolicy"), false);
        passwordPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(PolicyType.PASSWORD));
        passwordPolicy.setChoices(new ArrayList(((Map)this.passwordPolicies.getObject()).keySet()));
        ((DropDownChoice)passwordPolicy.getField()).setNullValid(true);
        securityContainer.add(new Component[]{passwordPolicy});
        final AjaxCheckBoxPanel inhPasswordPolicy = new AjaxCheckBoxPanel("inheritPasswordPolicy", "inheritPasswordPolicy", (IModel<Boolean>)new PropertyModel(entityTO, "inheritPasswordPolicy"), false);
        passwordPolicy.setReadOnly((Boolean)inhPasswordPolicy.getModelObject());
        inhPasswordPolicy.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                passwordPolicy.setReadOnly((Boolean)inhPasswordPolicy.getModelObject());
                target.add(new Component[]{passwordPolicy});
            }
        }});
        securityContainer.add(new Component[]{inhPasswordPolicy});
        final AjaxDropDownChoicePanel accountPolicy = new AjaxDropDownChoicePanel("accountPolicy", "accountPolicy", new PropertyModel(entityTO, "accountPolicy"), false);
        accountPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(PolicyType.ACCOUNT));
        accountPolicy.setChoices(new ArrayList(((Map)this.accountPolicies.getObject()).keySet()));
        ((DropDownChoice)accountPolicy.getField()).setNullValid(true);
        securityContainer.add(new Component[]{accountPolicy});
        final AjaxCheckBoxPanel inhAccountPolicy = new AjaxCheckBoxPanel("inheritAccountPolicy", "inheritAccountPolicy", (IModel<Boolean>)new PropertyModel(entityTO, "inheritAccountPolicy"), false);
        accountPolicy.setReadOnly((Boolean)inhAccountPolicy.getModelObject());
        inhAccountPolicy.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                accountPolicy.setReadOnly((Boolean)inhAccountPolicy.getModelObject());
                target.add(new Component[]{accountPolicy});
            }
        }});
        securityContainer.add(new Component[]{inhAccountPolicy});
    }

    private class PolicyRenderer
    extends ChoiceRenderer<Long> {
        private static final long serialVersionUID = 8060500161321947000L;
        private PolicyType type;

        public PolicyRenderer(PolicyType type) {
            this.type = type;
        }

        public Object getDisplayValue(Long object) {
            switch (this.type) {
                case ACCOUNT: {
                    return ((Map)RoleSecurityPanel.this.accountPolicies.getObject()).get(object);
                }
                case PASSWORD: {
                    return ((Map)RoleSecurityPanel.this.passwordPolicies.getObject()).get(object);
                }
            }
            return "";
        }

        public String getIdValue(Long object, int index) {
            return String.valueOf(object != null ? object : 0L);
        }
    }
}

