/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.io.Serializable;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.tree.BaseTree;
import org.apache.wicket.markup.html.tree.LinkTree;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.MembershipTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.commons.RoleTreeBuilder;
import org.syncope.console.pages.MembershipModalPage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;

public class RolesPanel
extends Panel {
    private static final long serialVersionUID = -2559791301973107191L;
    @SpringBean
    private RoleTreeBuilder roleTreeBuilder;
    private ListView<MembershipTO> membershipsView;
    private UserTO userTO = null;

    public RolesPanel(String id, final UserTO userTO, final boolean templateMode) {
        super(id);
        this.userTO = userTO;
        final WebMarkupContainer membershipsContainer = new WebMarkupContainer("membershipsContainer");
        membershipsContainer.setOutputMarkupId(true);
        this.add(new Component[]{membershipsContainer});
        final ModalWindow membershipWin = new ModalWindow("membershipWin");
        membershipWin.setCssClassName("w_silver");
        membershipWin.setCookieName("create-membership-modal");
        this.add(new Component[]{membershipWin});
        LinkTree tree = new LinkTree("treeTable", this.roleTreeBuilder.build()){
            private static final long serialVersionUID = -5514696922119256101L;

            protected IModel getNodeTextModel(IModel model) {
                return new PropertyModel((Object)model, "userObject.displayName");
            }

            protected void onNodeLinkClicked(Object node, BaseTree tree, AjaxRequestTarget target) {
                final RoleTO roleTO = (RoleTO)((DefaultMutableTreeNode)node).getUserObject();
                membershipWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = 7661763358801821185L;
                    private MembershipTO membershipTO;

                    public Page createPage() {
                        for (MembershipTO memberTO : RolesPanel.this.membershipsView.getList()) {
                            if (memberTO.getRoleId() != roleTO.getId()) continue;
                            return new MembershipModalPage(this.getPage().getPageReference(), membershipWin, memberTO, templateMode);
                        }
                        this.membershipTO = new MembershipTO();
                        this.membershipTO.setRoleId(roleTO.getId());
                        this.membershipTO.setRoleName(roleTO.getName());
                        return new MembershipModalPage(this.getPage().getPageReference(), membershipWin, this.membershipTO, templateMode);
                    }
                });
                membershipWin.show(target);
            }
        };
        tree.setOutputMarkupId(true);
        tree.getTreeState().expandAll();
        this.add(new Component[]{tree});
        this.membershipsView = new ListView<MembershipTO>("memberships", (IModel)new PropertyModel((Object)userTO, "memberships")){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem item) {
                final MembershipTO membershipTO = (MembershipTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("roleId", (IModel)new Model((Serializable)Long.valueOf(membershipTO.getRoleId())))});
                item.add(new Component[]{new Label("roleName", (IModel)new Model((Serializable)((Object)membershipTO.getRoleName())))});
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        membershipWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new MembershipModalPage(this.getPage().getPageReference(), membershipWin, membershipTO, templateMode);
                            }
                        });
                        membershipWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        userTO.removeMembership(membershipTO);
                        target.add(new Component[]{membershipsContainer});
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        membershipsContainer.add(new Component[]{this.membershipsView});
        this.setWindowClosedCallback(membershipWin, membershipsContainer);
    }

    private void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                UserTO updatedUserTO = ((UserModalPage)RolesPanel.this.getPage()).getUserTO();
                RolesPanel.this.userTO.setMemberships(updatedUserTO.getMemberships());
                target.add(new Component[]{container});
            }
        });
    }
}

