/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.client.to.LoggerTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.AbstractBaseRestClient;

@Component
public class ConfigurationRestClient
extends AbstractBaseRestClient {
    public String dbContentAsXml() throws SyncopeClientCompositeErrorException {
        return (String)this.restTemplate.getForObject(this.baseURL + "configuration/dbexport.json", String.class, new Object[0]);
    }

    public List<ConfigurationTO> getAllConfigurations() throws SyncopeClientCompositeErrorException {
        List<Object> configurations = null;
        configurations = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "configuration/list.json", ConfigurationTO[].class, new Object[0]));
        return configurations;
    }

    public ConfigurationTO readConfiguration(String key) throws SyncopeClientCompositeErrorException {
        ConfigurationTO configurationTO = (ConfigurationTO)this.restTemplate.getForObject(this.baseURL + "configuration/read/{key}.json", ConfigurationTO.class, new Object[]{key});
        return configurationTO;
    }

    public boolean createConfiguration(ConfigurationTO configurationTO) {
        ConfigurationTO newConfigurationTO = (ConfigurationTO)this.restTemplate.postForObject(this.baseURL + "configuration/create", (Object)configurationTO, ConfigurationTO.class, new Object[0]);
        return configurationTO.equals((Object)newConfigurationTO);
    }

    public boolean updateConfiguration(ConfigurationTO configurationTO) {
        ConfigurationTO newConfigurationTO = null;
        try {
            newConfigurationTO = (ConfigurationTO)this.restTemplate.postForObject(this.baseURL + "configuration/update", (Object)configurationTO, ConfigurationTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While updating a configuration", (Throwable)e);
            return false;
        }
        return configurationTO.equals((Object)newConfigurationTO);
    }

    public void deleteConfiguration(String key) throws SyncopeClientCompositeErrorException {
        this.restTemplate.delete(this.baseURL + "configuration/delete/{key}.json", new Object[]{key});
    }

    public List<LoggerTO> getLoggers() throws SyncopeClientCompositeErrorException {
        List<Object> loggers = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "log/controller/list", LoggerTO[].class, new Object[0]));
        return loggers;
    }

    public boolean setLoggerLevel(String name, String level) {
        boolean result;
        try {
            this.restTemplate.postForObject(this.baseURL + "log/controller/{name}/{level}", null, LoggerTO.class, new Object[]{name, level});
            result = true;
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While setting a logger's level", (Throwable)e);
            result = false;
        }
        return result;
    }
}

