/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.syncope.client.to.AccountPolicyTO;
import org.syncope.client.to.PasswordPolicyTO;
import org.syncope.client.to.PolicyTO;
import org.syncope.client.to.SyncPolicyTO;
import org.syncope.console.rest.AbstractBaseRestClient;
import org.syncope.console.rest.InvalidPolicyType;
import org.syncope.types.PolicyType;

@Component
public class PolicyRestClient
extends AbstractBaseRestClient {
    public <T extends PolicyTO> T getGlobalPolicy(PolicyType type) {
        AccountPolicyTO policy = null;
        try {
            switch (type) {
                case GLOBAL_ACCOUNT: {
                    try {
                        policy = (PolicyTO)this.restTemplate.getForObject(this.baseURL + "policy/account/global/read", AccountPolicyTO.class, new Object[0]);
                    }
                    catch (Exception e) {
                        LOG.debug("No account policy found", (Throwable)e);
                        policy = new AccountPolicyTO();
                    }
                    break;
                }
                case GLOBAL_PASSWORD: {
                    try {
                        policy = (PolicyTO)this.restTemplate.getForObject(this.baseURL + "policy/password/global/read", PasswordPolicyTO.class, new Object[0]);
                    }
                    catch (Exception e) {
                        LOG.debug("No password policy found", (Throwable)e);
                        policy = new PasswordPolicyTO();
                    }
                    break;
                }
                case GLOBAL_SYNC: {
                    try {
                        policy = (PolicyTO)this.restTemplate.getForObject(this.baseURL + "policy/sync/global/read", SyncPolicyTO.class, new Object[0]);
                    }
                    catch (Exception e) {
                        LOG.debug("No password policy found", (Throwable)e);
                        policy = new SyncPolicyTO();
                    }
                    break;
                }
                default: {
                    throw new Exception("Invalid policy type");
                }
            }
        }
        catch (Exception ignore) {
            LOG.error("Invalid policy type", (Throwable)ignore);
        }
        return (T)policy;
    }

    public <T extends PolicyTO> List<T> getPolicies(PolicyType type) {
        ArrayList<Object> res = new ArrayList<Object>();
        PolicyTO[] policies = null;
        try {
            String policy;
            Class<AccountPolicyTO> globalReference;
            Class<AccountPolicyTO[]> reference;
            switch (type) {
                case ACCOUNT: {
                    reference = AccountPolicyTO[].class;
                    globalReference = AccountPolicyTO.class;
                    policy = "account";
                    break;
                }
                case PASSWORD: {
                    reference = PasswordPolicyTO[].class;
                    globalReference = PasswordPolicyTO.class;
                    policy = "password";
                    break;
                }
                case SYNC: {
                    reference = SyncPolicyTO[].class;
                    globalReference = SyncPolicyTO.class;
                    policy = "sync";
                    break;
                }
                default: {
                    throw new Exception("Invalid policy type");
                }
            }
            try {
                policies = (PolicyTO[])this.restTemplate.getForObject(this.baseURL + "policy/" + policy + "/list", reference, new Object[0]);
            }
            catch (Exception ignore) {
                LOG.debug("No policy found", (Throwable)ignore);
            }
            if (policies != null) {
                res.addAll(Arrays.asList(policies));
            }
            PolicyTO globalPolicy = null;
            try {
                globalPolicy = (PolicyTO)this.restTemplate.getForObject(this.baseURL + "policy/" + policy + "/global/read", globalReference, new Object[0]);
            }
            catch (Exception ignore) {
                LOG.warn("No global policy found", (Throwable)ignore);
            }
            if (globalPolicy != null) {
                res.add(0, globalPolicy);
            }
        }
        catch (Exception ignore) {
            LOG.error("No policy found", (Throwable)ignore);
        }
        return res;
    }

    public <T extends PolicyTO> T createPolicy(T policy) throws InvalidPolicyType {
        switch (policy.getType()) {
            case GLOBAL_ACCOUNT: 
            case ACCOUNT: {
                return (T)((PolicyTO)this.restTemplate.postForObject(this.baseURL + "policy/account/create", policy, AccountPolicyTO.class, new Object[0]));
            }
            case GLOBAL_PASSWORD: 
            case PASSWORD: {
                return (T)((PolicyTO)this.restTemplate.postForObject(this.baseURL + "policy/password/create", policy, PasswordPolicyTO.class, new Object[0]));
            }
            case GLOBAL_SYNC: 
            case SYNC: {
                return (T)((PolicyTO)this.restTemplate.postForObject(this.baseURL + "policy/sync/create", policy, SyncPolicyTO.class, new Object[0]));
            }
        }
        throw new InvalidPolicyType("Invalid type " + policy.getType());
    }

    public <T extends PolicyTO> T updatePolicy(T policy) throws InvalidPolicyType {
        switch (policy.getType()) {
            case GLOBAL_ACCOUNT: 
            case ACCOUNT: {
                return (T)((PolicyTO)this.restTemplate.postForObject(this.baseURL + "policy/account/update", policy, AccountPolicyTO.class, new Object[0]));
            }
            case GLOBAL_PASSWORD: 
            case PASSWORD: {
                return (T)((PolicyTO)this.restTemplate.postForObject(this.baseURL + "policy/password/update", policy, PasswordPolicyTO.class, new Object[0]));
            }
            case GLOBAL_SYNC: 
            case SYNC: {
                return (T)((PolicyTO)this.restTemplate.postForObject(this.baseURL + "policy/sync/update", policy, SyncPolicyTO.class, new Object[0]));
            }
        }
        throw new InvalidPolicyType("Invalid type " + policy.getType());
    }

    public void delete(Long id) {
        this.restTemplate.delete(this.baseURL + "policy/delete/" + id, new Object[0]);
    }
}

