/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.datetime.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.springframework.util.StringUtils;
import org.syncope.console.wicket.markup.html.form.AbstractFieldPanel;
import org.syncope.console.wicket.markup.html.form.FieldPanel;

public class DateTextFieldPanel
extends FieldPanel<Date> {
    private static final long serialVersionUID = 1919852712185883648L;
    private final String datePattern;

    public DateTextFieldPanel(String id, String name, IModel<Date> model, boolean active, String datePattern) {
        super(id, name, model, active);
        this.datePattern = datePattern;
        this.field = DateTextField.forDatePattern((String)"field", model, (String)datePattern);
        if (active) {
            this.field.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget art) {
                }
            }});
        }
        this.field.add(new Behavior[]{this.getDatePicker()});
        this.add(new Component[]{this.field.setLabel((IModel)new Model((Serializable)((Object)name))).setOutputMarkupId(true)});
    }

    private DatePicker getDatePicker() {
        DatePicker picker = new DatePicker(){
            private static final long serialVersionUID = 4166072895162221956L;

            protected boolean enableMonthYearSelection() {
                return true;
            }
        };
        picker.setShowOnFieldClick(true);
        return picker;
    }

    @Override
    public FieldPanel setNewModel(final ListItem item, final Class reference) {
        final SimpleDateFormat formatter = new SimpleDateFormat(this.datePattern);
        Model model = new Model(){
            private static final long serialVersionUID = 6799404673615637845L;

            public Serializable getObject() {
                Date date = null;
                if (StringUtils.hasText((String)((String)item.getModelObject()))) {
                    if (reference.equals(String.class)) {
                        try {
                            date = formatter.parse((String)item.getModelObject());
                        }
                        catch (ParseException e) {
                            AbstractFieldPanel.LOG.error("While parsing date", (Throwable)e);
                        }
                    } else {
                        date = reference.equals(Date.class) ? (Date)item.getModelObject() : new Date((Long)item.getModelObject());
                    }
                }
                return date;
            }

            public void setObject(Serializable object) {
                if (object != null) {
                    if (reference.equals(String.class)) {
                        item.setModelObject((Object)formatter.format((Date)object));
                    } else if (reference.equals(Date.class)) {
                        item.setModelObject((Object)((Date)object));
                    } else {
                        item.setModelObject((Object)((Date)object).getTime());
                    }
                } else {
                    item.setModelObject(null);
                }
            }
        };
        this.field.setModel((IModel)model);
        return this;
    }

    @Override
    public FieldPanel setNewModel(final List<Serializable> list) {
        this.setNewModel(new Model(){
            private static final long serialVersionUID = 527651414610325237L;
            private final DateFormat formatter;
            {
                this.formatter = new SimpleDateFormat(DateTextFieldPanel.this.datePattern);
            }

            public Serializable getObject() {
                Date date = null;
                if (list != null && !list.isEmpty() && StringUtils.hasText((String)((Serializable)list.get(0)).toString())) {
                    try {
                        date = this.formatter.parse(((Serializable)list.get(0)).toString());
                    }
                    catch (ParseException e) {
                        AbstractFieldPanel.LOG.error("invalid parse exception", (Throwable)e);
                    }
                }
                return date;
            }

            public void setObject(Serializable object) {
                if (object != null) {
                    list.clear();
                    list.add(this.formatter.format((Date)object));
                }
            }
        });
        return this;
    }

    @Override
    public FieldPanel clone() {
        DateTextFieldPanel panel = new DateTextFieldPanel(this.id, this.name, (IModel<Date>)new Model(null), this.active, this.datePattern);
        panel.setRequired(this.isRequired());
        panel.setReadOnly(this.isReadOnly());
        panel.setTitle(this.title);
        if (this.isRequiredLabelAdded) {
            panel.addRequiredLabel();
        }
        return panel;
    }
}

