/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.syncope.console.wicket.markup.html.form.AbstractFieldPanel;

public abstract class FieldPanel<T extends Serializable>
extends AbstractFieldPanel<T> {
    private static final long serialVersionUID = -198988924922541273L;
    protected FormComponent field = null;
    protected final boolean active;
    protected final String id;
    protected final String name;
    protected String title = null;
    protected boolean isRequiredLabelAdded = false;

    public FieldPanel(String id, String name, IModel<T> model, boolean active) {
        super(id, model);
        this.id = id;
        this.name = name;
        this.active = active;
        Fragment fragment = new Fragment("required", "notRequiredFragment", (MarkupContainer)this);
        this.add(new Component[]{fragment});
        this.setOutputMarkupId(true);
    }

    public FormComponent getField() {
        return this.field;
    }

    public FieldPanel setTitle(String title) {
        this.field.add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)(title != null ? title : "")))});
        return this;
    }

    public FieldPanel setStyleShet(String classes) {
        this.field.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(classes != null ? classes : "")))});
        return this;
    }

    public FieldPanel setRequired(boolean required) {
        this.field.setRequired(required);
        return this;
    }

    public FieldPanel setReadOnly(boolean readOnly) {
        this.field.setEnabled(!readOnly);
        return this;
    }

    public FieldPanel setNewModel(IModel<T> model) {
        this.field.setModel(model);
        return this;
    }

    @Override
    public FieldPanel setModelObject(T object) {
        this.field.setModelObject(object);
        return this;
    }

    public T getModelObject() {
        return (T)((Serializable)this.field.getModelObject());
    }

    public boolean isRequired() {
        return this.field.isRequired();
    }

    public boolean isReadOnly() {
        return !this.field.isEnabled();
    }

    public FieldPanel setNewModel(final ListItem<T> item, Class reference) {
        this.setNewModel((IModel<T>)new Model(){
            private static final long serialVersionUID = 6799404673615637845L;

            public Serializable getObject() {
                return (Serializable)item.getModelObject();
            }

            public void setObject(Serializable object) {
                if (object != null && !object.toString().isEmpty()) {
                    item.setModelObject((Object)object);
                }
            }
        });
        return this;
    }

    public FieldPanel setNewModel(final List<Serializable> list) {
        this.setNewModel((IModel<T>)new Model(){
            private static final long serialVersionUID = 1088212074765051906L;

            public Serializable getObject() {
                return list != null && !list.isEmpty() ? (Serializable)list.get(0) : null;
            }

            public void setObject(Serializable object) {
                list.clear();
                if (object != null) {
                    list.add(object);
                }
            }
        });
        return this;
    }

    public FieldPanel clone() {
        FieldPanel panel;
        try {
            panel = (FieldPanel)((Object)((Object)((Object)this)).getClass().getConstructor(String.class, String.class, IModel.class, Boolean.TYPE).newInstance(this.id, this.name, new Model(null), this.active));
        }
        catch (Exception e) {
            LOG.error("Error cloning field panel", (Throwable)e);
            return null;
        }
        panel.setRequired(this.isRequired());
        panel.setReadOnly(this.isReadOnly());
        panel.setTitle(this.title);
        if (this.isRequiredLabelAdded) {
            panel.addRequiredLabel();
        }
        return panel;
    }

    public FieldPanel addRequiredLabel() {
        if (!this.isRequired()) {
            this.setRequired(true);
        }
        Fragment fragment = new Fragment("required", "requiredFragment", (MarkupContainer)this);
        fragment.add(new Component[]{new Label("requiredLabel", "*")});
        this.replace((Component)fragment);
        this.isRequiredLabelAdded = true;
        return this;
    }

    public FieldPanel removeRequiredLabel() {
        if (this.isRequired()) {
            this.setRequired(false);
        }
        Fragment fragment = new Fragment("required", "notRequiredFragment", (MarkupContainer)this);
        this.replace((Component)fragment);
        this.isRequiredLabelAdded = false;
        return this;
    }
}

