/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.commons;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.syncope.client.search.NodeCond;
import org.syncope.client.to.UserTO;
import org.syncope.console.commons.SortableUserProviderComparator;
import org.syncope.console.rest.UserRestClient;

public class UserDataProvider
extends SortableDataProvider<UserTO> {
    private static final long serialVersionUID = 6267494272884913376L;
    private SortableUserProviderComparator comparator;
    private NodeCond filter = null;
    private final int paginatorRows;
    private boolean filtered = false;
    private UserRestClient restClient;

    public UserDataProvider(UserRestClient restClient, int paginatorRows, boolean filtered) {
        this.restClient = restClient;
        this.filtered = filtered;
        this.paginatorRows = paginatorRows;
        this.setSort("id", SortOrder.ASCENDING);
        this.comparator = new SortableUserProviderComparator(this);
    }

    public void setSearchCond(NodeCond searchCond) {
        this.filter = searchCond;
    }

    public Iterator<UserTO> iterator(int first, int count) {
        List<UserTO> users = this.filtered ? (this.filter == null ? Collections.EMPTY_LIST : this.restClient.search(this.filter, first / this.paginatorRows + 1, this.paginatorRows)) : this.restClient.list(first / this.paginatorRows + 1, this.paginatorRows);
        Collections.sort(users, this.comparator);
        return users.iterator();
    }

    public int size() {
        if (this.filtered) {
            return this.filter == null ? 0 : this.restClient.searchCount(this.filter);
        }
        return this.restClient.count();
    }

    public IModel<UserTO> model(UserTO object) {
        return new CompoundPropertyModel((Object)object);
    }
}

