/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.springframework.util.StringUtils;
import org.syncope.client.to.SchedTaskTO;
import org.syncope.client.to.SyncTaskTO;
import org.syncope.client.to.TaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.SyncopeSession;
import org.syncope.console.commons.SelectChoiceRenderer;
import org.syncope.console.commons.SelectOption;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.TaskModalPage;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;

public abstract class AbstractSchedTaskModalPage
extends TaskModalPage {
    private static final long serialVersionUID = 2892005971093059242L;
    public static final SelectOption[] CRON_TEMPLATES = new SelectOption[]{new SelectOption("Unschedule", "UNSCHEDULE"), new SelectOption("Every 5 minutes", "0 0/5 * * * ?"), new SelectOption("Fire at 12pm (noon) every day", "0 0 12 * * ?"), new SelectOption("Fire at 12am (midnight) every first day of the month", "0 0 0 1 * ?"), new SelectOption("Fire at 12am (midnight) every Last day of the month", "0 0 0 L * ?"), new SelectOption("Fire at 12am (midnight) every Monday", "0 0 0 ? * 2")};
    protected WebMarkupContainer crontab = new WebMarkupContainer("crontab");

    public AbstractSchedTaskModalPage(final ModalWindow window, SchedTaskTO taskTO, final PageReference callerPageRef) {
        super((TaskTO)taskTO);
        this.crontab.setOutputMarkupId(true);
        this.form.add(new Component[]{this.crontab});
        AjaxTextFieldPanel lastExec = new AjaxTextFieldPanel("lastExec", this.getString("lastExec"), new DateFormatROModel(new PropertyModel((Object)taskTO, "lastExec")), false);
        lastExec.setEnabled(false);
        this.profile.add(new Component[]{lastExec});
        AjaxTextFieldPanel nextExec = new AjaxTextFieldPanel("nextExec", this.getString("nextExec"), new DateFormatROModel(new PropertyModel((Object)taskTO, "nextExec")), false);
        nextExec.setEnabled(false);
        this.profile.add(new Component[]{nextExec});
        final DropDownChoice cronTemplateChooser = new DropDownChoice("cronTemplateChooser", (IModel)new PropertyModel((Object)taskTO, "cronExpression"), Arrays.asList(CRON_TEMPLATES), new SelectChoiceRenderer()){
            private static final long serialVersionUID = -5843424545478691442L;

            protected CharSequence getDefaultChoice(String selected) {
                return "<option value=\"\">" + this.getString("chooseForTemplate") + "</option>";
            }
        };
        final TextField seconds = new TextField("seconds", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 0))));
        this.crontab.add(new Component[]{seconds});
        final TextField minutes = new TextField("minutes", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 1))));
        this.crontab.add(new Component[]{minutes});
        final TextField hours = new TextField("hours", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 2))));
        this.crontab.add(new Component[]{hours});
        final TextField daysOfMonth = new TextField("daysOfMonth", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 3))));
        this.crontab.add(new Component[]{daysOfMonth});
        final TextField months = new TextField("months", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 4))));
        this.crontab.add(new Component[]{months});
        final TextField daysOfWeek = new TextField("daysOfWeek", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 5))));
        this.crontab.add(new Component[]{daysOfWeek});
        cronTemplateChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                seconds.setModelObject((Object)AbstractSchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 0));
                minutes.setModelObject((Object)AbstractSchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 1));
                hours.setModelObject((Object)AbstractSchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 2));
                daysOfMonth.setModelObject((Object)AbstractSchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 3));
                months.setModelObject((Object)AbstractSchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 4));
                daysOfWeek.setModelObject((Object)AbstractSchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 5));
                target.add(new Component[]{AbstractSchedTaskModalPage.this.crontab});
            }
        }});
        this.crontab.add(new Component[]{cronTemplateChooser});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("apply")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                Object taskTO = (SchedTaskTO)form.getModelObject();
                if (!StringUtils.hasText((String)taskTO.getCronExpression()) || "UNSCHEDULE".equals(taskTO.getCronExpression())) {
                    taskTO.setCronExpression(null);
                } else {
                    taskTO.setCronExpression(AbstractSchedTaskModalPage.this.getCron((FormComponent)seconds, (FormComponent)minutes, (FormComponent)hours, (FormComponent)daysOfMonth, (FormComponent)months, (FormComponent)daysOfWeek));
                }
                try {
                    taskTO = taskTO.getId() > 0L ? (taskTO instanceof SyncTaskTO ? AbstractSchedTaskModalPage.this.taskRestClient.updateSyncTask((SyncTaskTO)taskTO) : AbstractSchedTaskModalPage.this.taskRestClient.updateSchedTask((SchedTaskTO)taskTO)) : (taskTO instanceof SyncTaskTO ? AbstractSchedTaskModalPage.this.taskRestClient.createSyncTask((SyncTaskTO)taskTO) : AbstractSchedTaskModalPage.this.taskRestClient.createSchedTask((SchedTaskTO)taskTO));
                    ((BasePage)callerPageRef.getPage()).setModalResult(true);
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    BaseModalPage.LOG.error("While creating or updating task", (Throwable)e);
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                    target.add(new Component[]{AbstractSchedTaskModalPage.this.feedbackPanel});
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{AbstractSchedTaskModalPage.this.feedbackPanel});
            }
        };
        if (taskTO.getId() > 0L) {
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)this.xmlRolesReader.getAllAllowedRoles("Tasks", "update"));
        } else {
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)this.xmlRolesReader.getAllAllowedRoles("Tasks", "create"));
        }
        this.form.add(new Component[]{submit});
    }

    private class DateFormatROModel
    implements IModel<String> {
        private static final long serialVersionUID = 6677274580927636121L;
        private final PropertyModel model;

        public DateFormatROModel(PropertyModel model) {
            this.model = model;
        }

        public String getObject() {
            return this.model.getObject() == null ? "" : SyncopeSession.get().getDateFormat().format((Date)this.model.getObject());
        }

        public void setObject(String object) {
        }

        public void detach() {
        }
    }
}

