/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PropertyListView;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.slf4j.LoggerFactory;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.client.to.LoggerTO;
import org.syncope.client.to.NotificationTO;
import org.syncope.client.to.WorkflowDefinitionTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ConfigurationModalPage;
import org.syncope.console.pages.NotificationModalPage;
import org.syncope.console.pages.panels.PoliciesPanel;
import org.syncope.console.rest.ConfigurationRestClient;
import org.syncope.console.rest.NotificationRestClient;
import org.syncope.console.rest.WorkflowRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;
import org.syncope.types.PolicyType;

public class Configuration
extends BasePage {
    private static final long serialVersionUID = -2838270869037702214L;
    @SpringBean
    private ConfigurationRestClient confRestClient;
    @SpringBean
    private NotificationRestClient notificationRestClient;
    @SpringBean
    private WorkflowRestClient wfRestClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final ModalWindow createConfigWin;
    private final ModalWindow editConfigWin;
    private static final int CONFIG_WIN_HEIGHT = 200;
    private static final int CONFIG_WIN_WIDTH = 350;
    private final ModalWindow createNotificationWin;
    private final ModalWindow editNotificationWin;
    private static final int NOTIFICATION_WIN_HEIGHT = 500;
    private static final int NOTIFICATION_WIN_WIDTH = 900;
    private WebMarkupContainer confContainer;
    private WebMarkupContainer notificationContainer;
    private int confPaginatorRows;
    private int notificationPaginatorRows;

    public Configuration(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createConfigWin = new ModalWindow("createConfigurationWin");
        componentArray[0] = this.createConfigWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editConfigWin = new ModalWindow("editConfigurationWin");
        componentArray2[0] = this.editConfigWin;
        this.add(componentArray2);
        this.setupSyncopeConf();
        this.add(new Component[]{new PoliciesPanel("passwordPoliciesPanel", PolicyType.PASSWORD)});
        this.add(new Component[]{new PoliciesPanel("accountPoliciesPanel", PolicyType.ACCOUNT)});
        this.add(new Component[]{new PoliciesPanel("syncPoliciesPanel", PolicyType.SYNC)});
        Component[] componentArray3 = new Component[1];
        this.createNotificationWin = new ModalWindow("createNotificationWin");
        componentArray3[0] = this.createNotificationWin;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.editNotificationWin = new ModalWindow("editNotificationWin");
        componentArray4[0] = this.editNotificationWin;
        this.add(componentArray4);
        this.setupNotification();
        final WorkflowDefinitionTO workflowDef = this.wfRestClient.getDefinition();
        WebMarkupContainer workflowDefContainer = new WebMarkupContainer("workflowDefContainer");
        Form wfForm = new Form("workflowDefForm", (IModel)new CompoundPropertyModel((Object)workflowDef));
        TextArea workflowDefArea = new TextArea("workflowDefArea", (IModel)new PropertyModel((Object)workflowDef, "xmlDefinition"));
        wfForm.add(new Component[]{workflowDefArea});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                try {
                    Configuration.this.wfRestClient.updateDefinition(workflowDef);
                    this.info((Serializable)((Object)this.getString("operation_succeded")));
                }
                catch (SyncopeClientCompositeErrorException scee) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + scee.getMessage())));
                }
                target.add(new Component[]{Configuration.this.feedbackPanel});
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{Configuration.this.feedbackPanel});
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Configuration", "workflowDefUpdate"));
        wfForm.add(new Component[]{submit});
        workflowDefContainer.add(new Component[]{wfForm});
        MetaDataRoleAuthorizationStrategy.authorize((Component)workflowDefContainer, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Configuration", "workflowDefRead"));
        this.add(new Component[]{workflowDefContainer});
        LoggerPropertyList coreLoggerList = new LoggerPropertyList(null, "corelogger", this.confRestClient.getLoggers());
        WebMarkupContainer coreLoggerContainer = new WebMarkupContainer("coreLoggerContainer");
        coreLoggerContainer.add(new Component[]{coreLoggerList});
        coreLoggerContainer.setOutputMarkupId(true);
        this.add(new Component[]{coreLoggerContainer});
        ConsoleLoggerController consoleLoggerController = new ConsoleLoggerController();
        LoggerPropertyList consoleLoggerList = new LoggerPropertyList(consoleLoggerController, "consolelogger", consoleLoggerController.getLoggers());
        WebMarkupContainer consoleLoggerContainer = new WebMarkupContainer("consoleLoggerContainer");
        consoleLoggerContainer.add(new Component[]{consoleLoggerList});
        consoleLoggerContainer.setOutputMarkupId(true);
        this.add(new Component[]{consoleLoggerContainer});
    }

    private final void setupSyncopeConf() {
        this.confPaginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "configuration.paginator.rows");
        ArrayList<Object> confColumns = new ArrayList<Object>();
        confColumns.add(new PropertyColumn((IModel)new ResourceModel("key"), "key", "key"));
        confColumns.add(new PropertyColumn((IModel)new ResourceModel("value"), "value", "value"));
        confColumns.add(new AbstractColumn<ConfigurationTO>((IModel)new ResourceModel("edit")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<ConfigurationTO>> cellItem, String componentId, IModel<ConfigurationTO> model) {
                final ConfigurationTO configurationTO = (ConfigurationTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        Configuration.this.editConfigWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ConfigurationModalPage(Configuration.this.getPageReference(), Configuration.this.editConfigWin, configurationTO, false);
                            }
                        });
                        Configuration.this.editConfigWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Configuration.this.xmlRolesReader.getAllAllowedRoles("Configuration", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        confColumns.add(new AbstractColumn<ConfigurationTO>((IModel)new ResourceModel("delete")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<ConfigurationTO>> cellItem, String componentId, IModel<ConfigurationTO> model) {
                final ConfigurationTO configurationTO = (ConfigurationTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Configuration.this.confRestClient.deleteConfiguration(configurationTO.getKey());
                        }
                        catch (SyncopeClientCompositeErrorException e) {
                            BasePage.LOG.error("While deleting a conf key", (Throwable)e);
                            this.error((Serializable)((Object)e.getMessage()));
                            return;
                        }
                        this.info((Serializable)((Object)this.getString("operation_succeded")));
                        target.add(new Component[]{Configuration.this.feedbackPanel});
                        target.add(new Component[]{Configuration.this.confContainer});
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Configuration.this.xmlRolesReader.getAllAllowedRoles("Configuration", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable confTable = new AjaxFallbackDefaultDataTable("syncopeconf", confColumns, (ISortableDataProvider)new SyncopeConfProvider(), this.confPaginatorRows);
        this.confContainer = new WebMarkupContainer("confContainer");
        this.confContainer.add(new Component[]{confTable});
        this.confContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.confContainer});
        this.createConfigWin.setCssClassName("w_silver");
        this.createConfigWin.setInitialHeight(200);
        this.createConfigWin.setInitialWidth(350);
        this.createConfigWin.setCookieName("create-configuration-modal");
        this.editConfigWin.setCssClassName("w_silver");
        this.editConfigWin.setInitialHeight(200);
        this.editConfigWin.setInitialWidth(350);
        this.editConfigWin.setCookieName("edit-configuration-modal");
        this.setWindowClosedCallback(this.createConfigWin, this.confContainer);
        this.setWindowClosedCallback(this.editConfigWin, this.confContainer);
        AjaxLink createConfigurationLink = new AjaxLink("createConfigurationLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                Configuration.this.createConfigWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new ConfigurationModalPage(Configuration.this.getPageReference(), Configuration.this.createConfigWin, new ConfigurationTO(), true);
                    }
                });
                Configuration.this.createConfigWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createConfigurationLink, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Configuration", "create"));
        this.add(new Component[]{createConfigurationLink});
        Link<Void> dbExportLink = new Link<Void>("dbExportLink"){
            private static final long serialVersionUID = -4331619903296515985L;

            public void onClick() {
                StringResourceStream stream = new StringResourceStream((CharSequence)Configuration.this.confRestClient.dbContentAsXml(), "text/xml");
                this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler((IResourceStream)stream).setFileName("content.xml").setContentDisposition(ContentDisposition.ATTACHMENT));
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)dbExportLink, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Configuration", "read"));
        this.add(new Component[]{dbExportLink});
        Form confPaginatorForm = new Form("confPaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "confPaginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Configuration.this.prefMan.set(Configuration.this.getRequest(), Configuration.this.getResponse(), "configuration.paginator.rows", String.valueOf(Configuration.this.confPaginatorRows));
                confTable.setItemsPerPage(Configuration.this.confPaginatorRows);
                target.add(new Component[]{Configuration.this.confContainer});
            }
        }});
        confPaginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{confPaginatorForm});
    }

    private final void setupNotification() {
        this.notificationPaginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "notification.paginator.rows");
        ArrayList<Object> notificationCols = new ArrayList<Object>();
        notificationCols.add(new PropertyColumn((IModel)new ResourceModel("id"), "id", "id"));
        notificationCols.add(new PropertyColumn((IModel)new ResourceModel("events"), "events", "events"));
        notificationCols.add(new PropertyColumn((IModel)new ResourceModel("subject"), "subject", "subject"));
        notificationCols.add(new PropertyColumn((IModel)new ResourceModel("template"), "template", "template"));
        notificationCols.add(new PropertyColumn((IModel)new ResourceModel("traceLevel"), "traceLevel", "traceLevel"));
        notificationCols.add(new AbstractColumn<NotificationTO>((IModel)new ResourceModel("edit")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<NotificationTO>> cellItem, String componentId, IModel<NotificationTO> model) {
                final NotificationTO notificationTO = (NotificationTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        Configuration.this.editNotificationWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new NotificationModalPage(Configuration.this.getPageReference(), Configuration.this.editNotificationWin, notificationTO, false);
                            }
                        });
                        Configuration.this.editNotificationWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Configuration.this.xmlRolesReader.getAllAllowedRoles("Notification", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        notificationCols.add(new AbstractColumn<NotificationTO>((IModel)new ResourceModel("delete")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<NotificationTO>> cellItem, String componentId, IModel<NotificationTO> model) {
                final NotificationTO notificationTO = (NotificationTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Configuration.this.notificationRestClient.deleteNotification(notificationTO.getId());
                        }
                        catch (SyncopeClientCompositeErrorException e) {
                            BasePage.LOG.error("While deleting a notification", (Throwable)e);
                            this.error((Serializable)((Object)e.getMessage()));
                            return;
                        }
                        this.info((Serializable)((Object)this.getString("operation_succeded")));
                        target.add(new Component[]{Configuration.this.feedbackPanel});
                        target.add(new Component[]{Configuration.this.notificationContainer});
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Configuration.this.xmlRolesReader.getAllAllowedRoles("Notification", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable notificationTable = new AjaxFallbackDefaultDataTable("notificationTable", notificationCols, (ISortableDataProvider)new NotificationProvider(), this.notificationPaginatorRows);
        this.notificationContainer = new WebMarkupContainer("notificationContainer");
        this.notificationContainer.add(new Component[]{notificationTable});
        this.notificationContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.notificationContainer});
        this.createNotificationWin.setCssClassName("w_silver");
        this.createNotificationWin.setInitialHeight(500);
        this.createNotificationWin.setInitialWidth(900);
        this.createNotificationWin.setCookieName("create-notification-modal");
        this.editNotificationWin.setCssClassName("w_silver");
        this.editNotificationWin.setInitialHeight(500);
        this.editNotificationWin.setInitialWidth(900);
        this.editNotificationWin.setCookieName("edit-notification-modal");
        this.setWindowClosedCallback(this.createNotificationWin, this.notificationContainer);
        this.setWindowClosedCallback(this.editNotificationWin, this.notificationContainer);
        AjaxLink createNotificationLink = new AjaxLink("createNotificationLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                Configuration.this.createNotificationWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new NotificationModalPage(Configuration.this.getPageReference(), Configuration.this.createNotificationWin, new NotificationTO(), true);
                    }
                });
                Configuration.this.createNotificationWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createNotificationLink, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Notification", "create"));
        this.add(new Component[]{createNotificationLink});
        Form notificationPaginatorForm = new Form("notificationPaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "notificationPaginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Configuration.this.prefMan.set(Configuration.this.getRequest(), Configuration.this.getResponse(), "notification.paginator.rows", String.valueOf(Configuration.this.notificationPaginatorRows));
                notificationTable.setItemsPerPage(Configuration.this.notificationPaginatorRows);
                target.add(new Component[]{Configuration.this.notificationContainer});
            }
        }});
        notificationPaginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{notificationPaginatorForm});
    }

    private class ConsoleLoggerController
    implements Serializable {
        private static final long serialVersionUID = -1550459341476431714L;

        private ConsoleLoggerController() {
        }

        public List<LoggerTO> getLoggers() {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            ArrayList<LoggerTO> result = new ArrayList<LoggerTO>(lc.getLoggerList().size());
            for (Logger logger : lc.getLoggerList()) {
                if (logger.getLevel() == null) continue;
                LoggerTO loggerTO = new LoggerTO();
                loggerTO.setName(logger.getName());
                loggerTO.setLevel(logger.getLevel().toString());
                result.add(loggerTO);
            }
            return result;
        }

        public boolean setLoggerLevel(String name, String level) {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            Logger logger = lc.getLogger(name);
            if (logger != null) {
                logger.setLevel(Level.valueOf((String)level));
            }
            return logger != null;
        }
    }

    private class LoggerPropertyList
    extends PropertyListView<LoggerTO> {
        private static final long serialVersionUID = 5911412425994616111L;
        private final ConsoleLoggerController consoleLoggerController;

        public LoggerPropertyList(ConsoleLoggerController consoleLoggerController, String id, List<? extends LoggerTO> list) {
            super(id, list);
            this.consoleLoggerController = consoleLoggerController;
        }

        protected void populateItem(final ListItem<LoggerTO> item) {
            item.add(new Component[]{new Label("name")});
            DropDownChoice level = new DropDownChoice("level");
            level.setModel((IModel)new IModel<LoggerLevel>(){
                private static final long serialVersionUID = -2350428186089596562L;

                public LoggerLevel getObject() {
                    return LoggerLevel.valueOf(((LoggerTO)item.getModelObject()).getLevel());
                }

                public void setObject(LoggerLevel object) {
                    ((LoggerTO)item.getModelObject()).setLevel(object.toString());
                }

                public void detach() {
                }
            });
            level.setChoices(Arrays.asList(LoggerLevel.values()));
            level.setOutputMarkupId(true);
            level.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    boolean result;
                    boolean bl = result = LoggerPropertyList.this.getId().equals("corelogger") ? Configuration.this.confRestClient.setLoggerLevel(((LoggerTO)item.getModelObject()).getName(), ((LoggerTO)item.getModelObject()).getLevel()) : LoggerPropertyList.this.consoleLoggerController.setLoggerLevel(((LoggerTO)item.getModelObject()).getName(), ((LoggerTO)item.getModelObject()).getLevel());
                    if (result) {
                        LoggerPropertyList.this.info((Serializable)((Object)LoggerPropertyList.this.getString("operation_succeded")));
                    } else {
                        LoggerPropertyList.this.info((Serializable)((Object)LoggerPropertyList.this.getString("operation_error")));
                    }
                    target.add(new Component[]{Configuration.this.feedbackPanel});
                }
            }});
            item.add(new Component[]{level});
        }
    }

    static enum LoggerLevel {
        OFF,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE,
        ALL;

    }

    private class NotificationProvider
    extends SortableDataProvider<NotificationTO> {
        private static final long serialVersionUID = -276043813563988590L;
        private SortableDataProviderComparator<NotificationTO> comparator;

        public NotificationProvider() {
            this.setSort("id", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<NotificationTO>(this);
        }

        public Iterator<NotificationTO> iterator(int first, int count) {
            List<NotificationTO> list = Configuration.this.notificationRestClient.getAllNotifications();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return Configuration.this.notificationRestClient.getAllNotifications().size();
        }

        public IModel<NotificationTO> model(final NotificationTO notification) {
            return new AbstractReadOnlyModel<NotificationTO>(){
                private static final long serialVersionUID = 774694801558497248L;

                public NotificationTO getObject() {
                    return notification;
                }
            };
        }
    }

    private class SyncopeConfProvider
    extends SortableDataProvider<ConfigurationTO> {
        private static final long serialVersionUID = -276043813563988590L;
        private SortableDataProviderComparator<ConfigurationTO> comparator;

        public SyncopeConfProvider() {
            this.setSort("key", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ConfigurationTO>(this);
        }

        public Iterator<ConfigurationTO> iterator(int first, int count) {
            List<ConfigurationTO> list = Configuration.this.confRestClient.getAllConfigurations();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return Configuration.this.confRestClient.getAllConfigurations().size();
        }

        public IModel<ConfigurationTO> model(final ConfigurationTO configuration) {
            return new AbstractReadOnlyModel<ConfigurationTO>(){
                private static final long serialVersionUID = 774694801558497248L;

                public ConfigurationTO getObject() {
                    return configuration;
                }
            };
        }
    }
}

