/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Configuration;
import org.syncope.console.rest.ConfigurationRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;

public class ConfigurationModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -5266230025217580098L;
    @SpringBean
    private ConfigurationRestClient configurationsRestClient;
    private AjaxButton submit;

    public ConfigurationModalPage(final PageReference callPageRef, final ModalWindow window, final ConfigurationTO configurationTO, final boolean createFlag) {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)configurationTO));
        AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", "key", (IModel<String>)new PropertyModel((Object)configurationTO, "key"), false);
        form.add(new Component[]{key});
        key.setEnabled(createFlag);
        key.addRequiredLabel();
        AjaxTextFieldPanel value = new AjaxTextFieldPanel("value", "value", (IModel<String>)new PropertyModel((Object)configurationTO, "value"), false);
        form.add(new Component[]{value});
        value.addRequiredLabel();
        this.submit = new IndicatingAjaxButton("apply", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                boolean res = false;
                if (createFlag) {
                    res = ConfigurationModalPage.this.configurationsRestClient.createConfiguration(configurationTO);
                    if (!res) {
                        this.error((Serializable)((Object)this.getString("error_insert")));
                    }
                } else {
                    res = ConfigurationModalPage.this.configurationsRestClient.updateConfiguration(configurationTO);
                    if (!res) {
                        this.error((Serializable)((Object)this.getString("error_updating")));
                    }
                }
                if (res) {
                    Configuration callerPage = (Configuration)callPageRef.getPage();
                    callerPage.setModalResult(true);
                    window.close(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{ConfigurationModalPage.this.feedbackPanel});
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Configuration", "create") : this.xmlRolesReader.getAllAllowedRoles("Configuration", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)ENABLE, (String)allowedRoles);
        form.add(new Component[]{this.submit});
        this.add(new Component[]{form});
    }
}

