/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.util.ClassUtils;
import org.syncope.client.to.ConnBundleTO;
import org.syncope.client.to.ConnInstanceTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Resources;
import org.syncope.console.rest.ConnectorRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxNumberFieldPanel;
import org.syncope.console.wicket.markup.html.form.AjaxPasswordFieldPanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.FieldPanel;
import org.syncope.console.wicket.markup.html.form.MultiValueSelectorPanel;
import org.syncope.types.ConnConfPropSchema;
import org.syncope.types.ConnConfProperty;
import org.syncope.types.ConnectorCapability;

public class ConnectorModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -2025535531121434050L;
    private static final String GUARDED_STRING = "org.identityconnectors.common.security.GuardedString";
    private static final String GUARDED_BYTE_ARRAY = "org.identityconnectors.common.security.GuardedByteArray";
    private static final List<Class> NUMBER = Arrays.asList(Integer.class, Double.class, Long.class, Float.class, Number.class, Integer.TYPE, Long.TYPE, Double.TYPE, Float.TYPE);
    @SpringBean
    private ConnectorRestClient restClient;
    private CheckBoxMultipleChoice capabilitiesPalette;
    private ConnBundleTO selectedBundleTO = new ConnBundleTO();
    private WebMarkupContainer propertiesContainer;
    private List<ConnectorCapability> selectedCapabilities;

    public ConnectorModalPage(final PageReference callerPageRef, final ModalWindow window, final ConnInstanceTO connectorTO, final boolean createFlag) {
        this.selectedCapabilities = new ArrayList<ConnectorCapability>(createFlag ? EnumSet.noneOf(ConnectorCapability.class) : connectorTO.getCapabilities());
        LoadableDetachableModel<List<ConnConfProperty>> selectedBundleProperties = new LoadableDetachableModel<List<ConnConfProperty>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<ConnConfProperty> load() {
                ArrayList<ConnConfProperty> result;
                if (createFlag) {
                    connectorTO.setConnectorName(ConnectorModalPage.this.selectedBundleTO.getConnectorName());
                    connectorTO.setVersion(ConnectorModalPage.this.selectedBundleTO.getVersion());
                    result = new ArrayList<ConnConfProperty>();
                    for (ConnConfPropSchema key : ConnectorModalPage.this.selectedBundleTO.getProperties()) {
                        ConnConfProperty propertyTO = new ConnConfProperty();
                        propertyTO.setSchema(key);
                        result.add(propertyTO);
                    }
                } else {
                    ConnectorModalPage.this.selectedBundleTO.setBundleName(connectorTO.getBundleName());
                    ConnectorModalPage.this.selectedBundleTO.setVersion(connectorTO.getVersion());
                    result = new ArrayList(connectorTO.getConfiguration());
                }
                if (result != null && !result.isEmpty()) {
                    Collections.sort(result);
                }
                return result;
            }
        };
        final AjaxTextFieldPanel connectorName = new AjaxTextFieldPanel("connectorName", "connector name", (IModel<String>)new PropertyModel((Object)connectorTO, "connectorName"), false);
        connectorName.setOutputMarkupId(true);
        connectorName.setEnabled(false);
        AjaxTextFieldPanel displayName = new AjaxTextFieldPanel("displayName", "display name", (IModel<String>)new PropertyModel((Object)connectorTO, "displayName"), false);
        displayName.setOutputMarkupId(true);
        displayName.addRequiredLabel();
        final AjaxTextFieldPanel version = new AjaxTextFieldPanel("version", "version", (IModel<String>)new PropertyModel((Object)connectorTO, "version"), false);
        displayName.setOutputMarkupId(true);
        version.setEnabled(false);
        LoadableDetachableModel<List<ConnBundleTO>> bundles = new LoadableDetachableModel<List<ConnBundleTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<ConnBundleTO> load() {
                return ConnectorModalPage.this.restClient.getAllBundles();
            }
        };
        final AjaxDropDownChoicePanel bundle = new AjaxDropDownChoicePanel("bundle", "bundle", new Model(null), false);
        bundle.setStyleShet("long_dynamicsize");
        bundle.setChoices((List)bundles.getObject());
        bundle.setChoiceRenderer((IChoiceRenderer)new ChoiceRenderer<ConnBundleTO>(){
            private static final long serialVersionUID = -1945543182376191187L;

            public Object getDisplayValue(ConnBundleTO object) {
                return object.getBundleName() + " " + object.getVersion();
            }

            public String getIdValue(ConnBundleTO object, int index) {
                return object.getBundleName() + "#" + object.getVersion();
            }
        });
        ((DropDownChoice)bundle.getField()).setNullValid(true);
        bundle.setRequired(true);
        bundle.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                connectorTO.setConfiguration(new HashSet());
                DropDownChoice bundleChoice = (DropDownChoice)bundle.getField();
                bundleChoice.setNullValid(false);
                target.add(new Component[]{bundle.getField()});
                target.add(new Component[]{ConnectorModalPage.this.propertiesContainer});
                target.add(new Component[]{connectorName});
                target.add(new Component[]{version});
            }
        }});
        bundle.getField().setModel((IModel)new IModel<ConnBundleTO>(){
            private static final long serialVersionUID = -3736598995576061229L;

            public ConnBundleTO getObject() {
                return ConnectorModalPage.this.selectedBundleTO;
            }

            public void setObject(ConnBundleTO object) {
                ConnectorModalPage.this.selectedBundleTO = object;
            }

            public void detach() {
            }
        });
        bundle.addRequiredLabel();
        bundle.setEnabled(createFlag);
        ListView<ConnConfProperty> propView = new ListView<ConnConfProperty>("connectorProperties", (IModel)selectedBundleProperties){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<ConnConfProperty> item) {
                FieldPanel field;
                ConnConfProperty property = (ConnConfProperty)item.getModelObject();
                Label label = new Label("connPropAttrSchema", property.getSchema().getDisplayName() == null || property.getSchema().getDisplayName().isEmpty() ? property.getSchema().getName() : property.getSchema().getDisplayName());
                item.add(new Component[]{label});
                boolean required = false;
                boolean isArray = false;
                if (ConnectorModalPage.GUARDED_STRING.equalsIgnoreCase(property.getSchema().getType()) || ConnectorModalPage.GUARDED_BYTE_ARRAY.equalsIgnoreCase(property.getSchema().getType())) {
                    field = new AjaxPasswordFieldPanel("panel", label.getDefaultModelObjectAsString(), (IModel<String>)new Model(), true);
                    ((PasswordTextField)field.getField()).setResetPassword(false);
                    required = property.getSchema().isRequired();
                } else {
                    Class<String> propertySchemaClass;
                    try {
                        propertySchemaClass = ClassUtils.forName((String)property.getSchema().getType(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                    }
                    catch (Exception e) {
                        BaseModalPage.LOG.error("Error parsing attribute type", (Throwable)e);
                        propertySchemaClass = String.class;
                    }
                    if (NUMBER.contains(propertySchemaClass)) {
                        field = new AjaxNumberFieldPanel("panel", label.getDefaultModelObjectAsString(), (IModel<Number>)new Model(), ClassUtils.resolvePrimitiveIfNecessary(propertySchemaClass), true);
                        required = property.getSchema().isRequired();
                    } else if (Boolean.class.equals(propertySchemaClass) || Boolean.TYPE.equals(propertySchemaClass)) {
                        field = new AjaxCheckBoxPanel("panel", label.getDefaultModelObjectAsString(), (IModel<Boolean>)new Model(), true);
                    } else {
                        field = new AjaxTextFieldPanel("panel", label.getDefaultModelObjectAsString(), (IModel<String>)new Model(), true);
                        required = property.getSchema().isRequired();
                    }
                    if (String[].class.equals(propertySchemaClass)) {
                        isArray = true;
                    }
                }
                field.setTitle(property.getSchema().getHelpMessage());
                if (isArray) {
                    field.removeRequiredLabel();
                    if (property.getValues().isEmpty()) {
                        property.getValues().add(null);
                    }
                    item.add(new Component[]{new MultiValueSelectorPanel("panel", new PropertyModel((Object)property, "values"), String.class, field)});
                } else {
                    if (required) {
                        field.addRequiredLabel();
                    }
                    field.setNewModel(property.getValues());
                    item.add(new Component[]{field});
                }
                AjaxCheckBoxPanel overridable = new AjaxCheckBoxPanel("connPropAttrOverridable", "connPropAttrOverridable", (IModel<Boolean>)new PropertyModel((Object)property, "overridable"), true);
                item.add(new Component[]{overridable});
                connectorTO.getConfiguration().add(property);
            }
        };
        this.propertiesContainer = new WebMarkupContainer("container");
        this.propertiesContainer.setOutputMarkupId(true);
        this.propertiesContainer.add(new Component[]{propView});
        Form connectorForm = new Form("form");
        connectorForm.setModel((IModel)new CompoundPropertyModel((Object)connectorTO));
        connectorForm.add(new Component[]{this.propertiesContainer});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                ConnInstanceTO connector = (ConnInstanceTO)form.getDefaultModelObject();
                ConnBundleTO bundleTO = (ConnBundleTO)bundle.getModelObject();
                connector.setBundleName(bundleTO.getBundleName());
                if (!ConnectorModalPage.this.selectedCapabilities.isEmpty()) {
                    connector.setCapabilities(EnumSet.copyOf(ConnectorModalPage.this.selectedCapabilities));
                } else {
                    connector.setCapabilities(EnumSet.noneOf(ConnectorCapability.class));
                }
                try {
                    if (createFlag) {
                        ConnectorModalPage.this.restClient.create(connector);
                    } else {
                        ConnectorModalPage.this.restClient.update(connector);
                    }
                    ((Resources)callerPageRef.getPage()).setModalResult(true);
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                    target.add(new Component[]{ConnectorModalPage.this.feedbackPanel});
                    ((Resources)callerPageRef.getPage()).setModalResult(false);
                    BaseModalPage.LOG.error("While creating or updating connector " + connector);
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{ConnectorModalPage.this.feedbackPanel});
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Connectors", "create") : this.xmlRolesReader.getAllAllowedRoles("Connectors", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        connectorForm.add(new Component[]{connectorName});
        connectorForm.add(new Component[]{displayName});
        connectorForm.add(new Component[]{bundle});
        connectorForm.add(new Component[]{version});
        LoadableDetachableModel<List<ConnectorCapability>> capabilities = new LoadableDetachableModel<List<ConnectorCapability>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<ConnectorCapability> load() {
                return Arrays.asList(ConnectorCapability.values());
            }
        };
        this.capabilitiesPalette = new CheckBoxMultipleChoice("capabilitiesPalette", (IModel)new PropertyModel((Object)this, "selectedCapabilities"), (IModel)capabilities);
        connectorForm.add(new Component[]{this.capabilitiesPalette});
        connectorForm.add(new Component[]{submit});
        this.add(new Component[]{connectorForm});
    }
}

