/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.UserTO;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Users;
import org.syncope.console.rest.SchemaRestClient;

public class DisplayAttributesModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -4274117450918385110L;
    private final int MAX_SELECTIONS = 9;
    private List<String> ATTRIBUTES_NOTINCLUDED = Arrays.asList("attributes", "derivedAttributes", "virtualAttributes", "serialVersionUID", "memberships", "resources", "password");
    @SpringBean
    private PreferenceManager prefMan;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    private final IModel<List<String>> dnames = new LoadableDetachableModel<List<String>>(){

        protected List<String> load() {
            ArrayList<String> details = new ArrayList<String>();
            for (Class clazz = UserTO.class; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (DisplayAttributesModalPage.this.ATTRIBUTES_NOTINCLUDED.contains(field.getName())) continue;
                    details.add(field.getName());
                }
            }
            Collections.reverse(details);
            return details;
        }
    };
    private final IModel<List<String>> names = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            List<String> schemas = DisplayAttributesModalPage.this.schemaRestClient.getSchemaNames("user");
            if (schemas == null) {
                schemas = new ArrayList<String>();
            }
            return schemas;
        }
    };
    private final IModel<List<String>> dsnames = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            List<String> schemas = DisplayAttributesModalPage.this.schemaRestClient.getDerivedSchemaNames("user");
            if (schemas == null) {
                schemas = new ArrayList<String>();
            }
            return schemas;
        }
    };
    private final IModel<List<String>> vsnames = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            List<String> schemas = DisplayAttributesModalPage.this.schemaRestClient.getVirtualSchemaNames("user");
            if (schemas == null) {
                schemas = new ArrayList<String>();
            }
            return schemas;
        }
    };
    private final List<String> userDetails;
    private final List<String> selectedSchemas;
    private final List<String> selectedVirSchemas;
    private final List<String> selectedDerSchemas;

    public DisplayAttributesModalPage(final PageReference callerPageRef, final ModalWindow window) {
        Fragment fragment;
        Form form = new Form("form");
        form.setModel((IModel)new CompoundPropertyModel((Object)this));
        this.userDetails = this.prefMan.getList(this.getRequest(), "users.details.view");
        this.selectedSchemas = this.prefMan.getList(this.getRequest(), "users.attributes.view");
        this.selectedVirSchemas = this.prefMan.getList(this.getRequest(), "users.virtual.attributes.view");
        this.selectedDerSchemas = this.prefMan.getList(this.getRequest(), "users.derived.attributes.view");
        CheckGroup dgroup = new CheckGroup("dCheckGroup", (IModel)new PropertyModel((Object)this, "userDetails"));
        form.add(new Component[]{dgroup});
        ListView<String> details = new ListView<String>("details", this.dnames){

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("dcheck", item.getModel())});
                item.add(new Component[]{new Label("dname", (IModel)new ResourceModel((String)item.getModelObject(), (String)item.getModelObject()))});
            }
        };
        dgroup.add(new Component[]{details});
        if (this.names.getObject() != null && !((List)this.names.getObject()).isEmpty()) {
            fragment = new Fragment("schemas", "sfragment", (MarkupContainer)form);
            form.add(new Component[]{fragment});
            CheckGroup sgroup = new CheckGroup("sCheckGroup", (IModel)new PropertyModel((Object)this, "selectedSchemas"));
            fragment.add(new Component[]{sgroup});
            ListView<String> schemas = new ListView<String>("schemas", this.names){

                protected void populateItem(ListItem<String> item) {
                    item.add(new Component[]{new Check("scheck", item.getModel())});
                    item.add(new Component[]{new Label("sname", (IModel)new ResourceModel((String)item.getModelObject(), (String)item.getModelObject()))});
                }
            };
            sgroup.add(new Component[]{schemas});
        } else {
            fragment = new Fragment("schemas", "emptyFragment", (MarkupContainer)form);
            form.add(new Component[]{fragment});
            this.selectedSchemas.clear();
        }
        if (this.vsnames.getObject() != null && !((List)this.vsnames.getObject()).isEmpty()) {
            fragment = new Fragment("vschemas", "vsfragment", (MarkupContainer)form);
            form.add(new Component[]{fragment});
            CheckGroup vsgroup = new CheckGroup("vsCheckGroup", (IModel)new PropertyModel((Object)this, "selectedVirSchemas"));
            fragment.add(new Component[]{vsgroup});
            ListView<String> virSchemas = new ListView<String>("virSchemas", this.vsnames){

                protected void populateItem(ListItem<String> item) {
                    item.add(new Component[]{new Check("vscheck", item.getModel())});
                    item.add(new Component[]{new Label("vsname", (IModel)new ResourceModel((String)item.getModelObject(), (String)item.getModelObject()))});
                }
            };
            vsgroup.add(new Component[]{virSchemas});
        } else {
            fragment = new Fragment("vschemas", "emptyFragment", (MarkupContainer)form);
            form.add(new Component[]{fragment});
            this.selectedVirSchemas.clear();
        }
        if (this.dsnames.getObject() != null && !((List)this.dsnames.getObject()).isEmpty()) {
            fragment = new Fragment("dschemas", "dsfragment", (MarkupContainer)form);
            form.add(new Component[]{fragment});
            CheckGroup dsgroup = new CheckGroup("dsCheckGroup", (IModel)new PropertyModel((Object)this, "selectedDerSchemas"));
            fragment.add(new Component[]{dsgroup});
            ListView<String> derSchemas = new ListView<String>("derSchemas", this.dsnames){

                protected void populateItem(ListItem<String> item) {
                    item.add(new Component[]{new Check("dscheck", item.getModel())});
                    item.add(new Component[]{new Label("dsname", (IModel)new ResourceModel((String)item.getModelObject(), (String)item.getModelObject()))});
                }
            };
            dsgroup.add(new Component[]{derSchemas});
        } else {
            fragment = new Fragment("dschemas", "emptyFragment", (MarkupContainer)form);
            form.add(new Component[]{fragment});
            this.selectedDerSchemas.clear();
        }
        IndicatingAjaxButton submit = new IndicatingAjaxButton("submit", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                if (DisplayAttributesModalPage.this.userDetails.size() + DisplayAttributesModalPage.this.selectedSchemas.size() + DisplayAttributesModalPage.this.selectedVirSchemas.size() + DisplayAttributesModalPage.this.selectedDerSchemas.size() > 9) {
                    this.error((Serializable)((Object)this.getString("tooMuchSelections")));
                    this.onError(target, form);
                } else {
                    HashMap<String, List<String>> prefs = new HashMap<String, List<String>>();
                    prefs.put("users.details.view", DisplayAttributesModalPage.this.userDetails);
                    prefs.put("users.attributes.view", DisplayAttributesModalPage.this.selectedSchemas);
                    prefs.put("users.virtual.attributes.view", DisplayAttributesModalPage.this.selectedVirSchemas);
                    prefs.put("users.derived.attributes.view", DisplayAttributesModalPage.this.selectedDerSchemas);
                    DisplayAttributesModalPage.this.prefMan.setList(this.getRequest(), this.getResponse(), prefs);
                    ((Users)callerPageRef.getPage()).setModalResult(true);
                    window.close(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{DisplayAttributesModalPage.this.feedbackPanel});
            }
        };
        form.add(new Component[]{submit});
        this.add(new Component[]{form});
    }
}

