/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;
import org.syncope.client.to.NotificationTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Configuration;
import org.syncope.console.pages.panels.UserSearchPanel;
import org.syncope.console.rest.NotificationRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxPalettePanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.types.TraceLevel;

class NotificationModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -1975312550059578553L;
    @SpringBean
    private NotificationRestClient restClient;

    public NotificationModalPage(final PageReference callPageRef, final ModalWindow window, final NotificationTO notificationTO, final boolean createFlag) {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)notificationTO));
        form.setModel((IModel)new CompoundPropertyModel((Object)notificationTO));
        AjaxTextFieldPanel sender = new AjaxTextFieldPanel("sender", this.getString("sender"), (IModel<String>)new PropertyModel((Object)notificationTO, "sender"), false);
        sender.addRequiredLabel();
        sender.addValidator((IValidator)EmailAddressValidator.getInstance());
        form.add(new Component[]{sender});
        AjaxTextFieldPanel subject = new AjaxTextFieldPanel("subject", this.getString("subject"), (IModel<String>)new PropertyModel((Object)notificationTO, "subject"), false);
        subject.addRequiredLabel();
        form.add(new Component[]{subject});
        AjaxDropDownChoicePanel<String> template = new AjaxDropDownChoicePanel<String>("template", this.getString("template"), (IModel<String>)new PropertyModel((Object)notificationTO, "template"), false);
        template.setChoices(this.restClient.getMailTemplates());
        template.addRequiredLabel();
        form.add(new Component[]{template});
        AjaxDropDownChoicePanel<TraceLevel> traceLevel = new AjaxDropDownChoicePanel<TraceLevel>("traceLevel", this.getString("traceLevel"), (IModel<TraceLevel>)new PropertyModel((Object)notificationTO, "traceLevel"), false);
        traceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        traceLevel.addRequiredLabel();
        form.add(new Component[]{traceLevel});
        final UserSearchPanel about = new UserSearchPanel("about", notificationTO.getAbout());
        form.add(new Component[]{about});
        AjaxPalettePanel events = new AjaxPalettePanel("events", new PropertyModel((Object)notificationTO, "events"), new ListModel(this.restClient.getEvents()));
        form.add(new Component[]{events});
        final UserSearchPanel recipients = new UserSearchPanel("recipients", notificationTO.getRecipients());
        form.add(new Component[]{recipients});
        AjaxCheckBoxPanel selfAsRecipient = new AjaxCheckBoxPanel("selfAsRecipient", this.getString("selfAsRecipient"), (IModel<Boolean>)new PropertyModel((Object)notificationTO, "selfAsRecipient"), false);
        form.add(new Component[]{selfAsRecipient});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                notificationTO.setAbout(about.buildSearchCond());
                notificationTO.setRecipients(recipients.buildSearchCond());
                try {
                    if (createFlag) {
                        NotificationModalPage.this.restClient.createNotification(notificationTO);
                    } else {
                        NotificationModalPage.this.restClient.updateNotification(notificationTO);
                    }
                    this.info((Serializable)((Object)this.getString("operation_succeded")));
                    Configuration callerPage = (Configuration)callPageRef.getPage();
                    callerPage.setModalResult(true);
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException scee) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + scee.getMessage())));
                    target.add(new Component[]{NotificationModalPage.this.feedbackPanel});
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{NotificationModalPage.this.feedbackPanel});
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Notification", "create") : this.xmlRolesReader.getAllAllowedRoles("Notification", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        form.add(new Component[]{submit});
        this.add(new Component[]{form});
    }
}

