/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.AccountPolicyTO;
import org.syncope.client.to.PasswordPolicyTO;
import org.syncope.client.to.PolicyTO;
import org.syncope.client.to.SyncPolicyTO;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.panels.PolicyBeanPanel;
import org.syncope.console.rest.PolicyRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.types.AbstractPolicySpec;
import org.syncope.types.AccountPolicySpec;
import org.syncope.types.PasswordPolicySpec;
import org.syncope.types.PolicyType;
import org.syncope.types.SyncPolicySpec;

public class PolicyModalPage<T extends PolicyTO>
extends BaseModalPage {
    private static final long serialVersionUID = -7325772767481076679L;
    @SpringBean
    private PolicyRestClient policyRestClient;

    public PolicyModalPage(ModalWindow window, T policyTO) {
        Form form = new Form("form");
        form.setOutputMarkupId(true);
        this.add(new Component[]{form});
        AjaxTextFieldPanel policyid = new AjaxTextFieldPanel("id", "id", (IModel<String>)new PropertyModel(policyTO, "id"), false);
        policyid.setEnabled(false);
        policyid.setStyleShet("ui-widget-content ui-corner-all short_fixedsize");
        form.add(new Component[]{policyid});
        AjaxTextFieldPanel description = new AjaxTextFieldPanel("description", "description", (IModel<String>)new PropertyModel(policyTO, "description"), false);
        description.addRequiredLabel();
        description.setStyleShet("ui-widget-content ui-corner-all medium_dynamicsize");
        form.add(new Component[]{description});
        AjaxDropDownChoicePanel<PolicyType> type = new AjaxDropDownChoicePanel<PolicyType>("type", "type", (IModel<PolicyType>)new PropertyModel(policyTO, "type"), false);
        switch (policyTO.getType()) {
            case GLOBAL_ACCOUNT: 
            case ACCOUNT: {
                type.setChoices(Arrays.asList(PolicyType.GLOBAL_ACCOUNT, PolicyType.ACCOUNT));
                break;
            }
            case GLOBAL_PASSWORD: 
            case PASSWORD: {
                type.setChoices(Arrays.asList(PolicyType.GLOBAL_PASSWORD, PolicyType.PASSWORD));
                break;
            }
            case GLOBAL_SYNC: 
            case SYNC: {
                type.setChoices(Arrays.asList(PolicyType.GLOBAL_SYNC, PolicyType.SYNC));
            }
        }
        type.setChoiceRenderer((IChoiceRenderer)new PolicyTypeRenderer());
        type.addRequiredLabel();
        form.add(new Component[]{type});
        AbstractPolicySpec policy = this.getPolicySpecification((PolicyTO)policyTO);
        form.add(new Component[]{new PolicyBeanPanel("panel", policy)});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("apply"), (PolicyTO)policyTO, policy, window){
            private static final long serialVersionUID = -958724007591692537L;
            final /* synthetic */ PolicyTO val$policyTO;
            final /* synthetic */ AbstractPolicySpec val$policy;
            final /* synthetic */ ModalWindow val$window;
            {
                this.val$policyTO = policyTO;
                this.val$policy = abstractPolicySpec;
                this.val$window = modalWindow;
                super(x0, x1);
            }

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                PolicyModalPage.this.setPolicySpecification(this.val$policyTO, this.val$policy);
                try {
                    if (this.val$policyTO.getId() > 0L) {
                        PolicyModalPage.this.policyRestClient.updatePolicy(this.val$policyTO);
                    } else {
                        PolicyModalPage.this.policyRestClient.createPolicy(this.val$policyTO);
                    }
                    this.val$window.close(target);
                }
                catch (Exception e) {
                    BaseModalPage.LOG.error("While creating policy", (Throwable)e);
                    this.error((Serializable)((Object)this.getString("operation_error")));
                    target.add(new Component[]{this.getPage().get("feedback")});
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{this.getPage().get("feedback")});
            }
        };
        form.add(new Component[]{submit});
    }

    private AbstractPolicySpec getPolicySpecification(PolicyTO policyTO) {
        AccountPolicySpec spec;
        switch (policyTO.getType()) {
            case GLOBAL_ACCOUNT: 
            case ACCOUNT: {
                spec = ((AccountPolicyTO)policyTO).getSpecification() != null ? ((AccountPolicyTO)policyTO).getSpecification() : new AccountPolicySpec();
                break;
            }
            case GLOBAL_PASSWORD: 
            case PASSWORD: {
                spec = ((PasswordPolicyTO)policyTO).getSpecification() != null ? ((PasswordPolicyTO)policyTO).getSpecification() : new PasswordPolicySpec();
                break;
            }
            default: {
                spec = ((SyncPolicyTO)policyTO).getSpecification() != null ? ((SyncPolicyTO)policyTO).getSpecification() : new SyncPolicySpec();
            }
        }
        return spec;
    }

    private void setPolicySpecification(PolicyTO policyTO, AbstractPolicySpec specification) {
        switch (policyTO.getType()) {
            case GLOBAL_ACCOUNT: 
            case ACCOUNT: {
                ((AccountPolicyTO)policyTO).setSpecification((AccountPolicySpec)specification);
                break;
            }
            case GLOBAL_PASSWORD: 
            case PASSWORD: {
                ((PasswordPolicyTO)policyTO).setSpecification((PasswordPolicySpec)specification);
                break;
            }
            case GLOBAL_SYNC: 
            case SYNC: {
                ((SyncPolicyTO)policyTO).setSpecification((SyncPolicySpec)specification);
            }
        }
    }

    private class PolicyTypeRenderer
    extends ChoiceRenderer<PolicyType> {
        private static final long serialVersionUID = -8993265421104002134L;

        private PolicyTypeRenderer() {
        }

        public Object getDisplayValue(PolicyType object) {
            return PolicyModalPage.this.getString(object.name());
        }
    }
}

