/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.util.StringUtils;
import org.syncope.client.to.NotificationTaskTO;
import org.syncope.client.to.PropagationTaskTO;
import org.syncope.client.to.SchedTaskTO;
import org.syncope.client.to.SyncTaskTO;
import org.syncope.client.to.TaskExecTO;
import org.syncope.client.to.TaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.rest.TaskRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public abstract class TaskModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -4110576026663173545L;
    @SpringBean
    protected TaskRestClient taskRestClient;
    protected WebMarkupContainer profile;
    protected WebMarkupContainer executions;
    protected Form form;

    public TaskModalPage(final TaskTO taskTO) {
        TaskTO actual = taskTO.getId() == 0L ? taskTO : (taskTO instanceof PropagationTaskTO ? this.taskRestClient.readPropagationTask(taskTO.getId()) : (taskTO instanceof NotificationTaskTO ? this.taskRestClient.readNotificationTask(taskTO.getId()) : (taskTO instanceof SyncTaskTO ? this.taskRestClient.readSchedTask(SyncTaskTO.class, taskTO.getId()) : this.taskRestClient.readSchedTask(SchedTaskTO.class, taskTO.getId()))));
        taskTO.setExecutions(actual.getExecutions());
        final Label dialogContent = new Label("dialogContent", (IModel)new Model((Serializable)((Object)"")));
        this.add(new Component[]{dialogContent.setOutputMarkupId(true)});
        this.form = new Form("form");
        this.add(new Component[]{this.form});
        this.form.setModel((IModel)new CompoundPropertyModel((Object)taskTO));
        this.profile = new WebMarkupContainer("profile");
        this.profile.setOutputMarkupId(true);
        this.form.add(new Component[]{this.profile});
        this.executions = new WebMarkupContainer("executions");
        this.executions.setOutputMarkupId(true);
        this.form.add(new Component[]{this.executions});
        Label idLabel = new Label("idLabel", (IModel)new ResourceModel("id"));
        this.profile.add(new Component[]{idLabel});
        AjaxTextFieldPanel id = new AjaxTextFieldPanel("id", this.getString("id"), (IModel<String>)new PropertyModel((Object)taskTO, "id"), false);
        id.setEnabled(false);
        this.profile.add(new Component[]{id});
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), "id", "id"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("startDate"), "startDate", "startDate"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("endDate"), "endDate", "endDate"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("status"), "status", "status"));
        columns.add(new AbstractColumn<TaskExecTO>((IModel)new ResourceModel("message")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<TaskExecTO>> cellItem, String componentId, final IModel<TaskExecTO> model) {
                IndicatingAjaxLink messageLink = new IndicatingAjaxLink("link"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        dialogContent.setDefaultModelObject((Object)((TaskExecTO)model.getObject()).getMessage());
                        target.add(new Component[]{dialogContent});
                        target.appendJavaScript((CharSequence)"jQuery('#dialog').dialog('open')");
                    }
                };
                messageLink.add(new Component[]{new Label("linkTitle", TaskModalPage.this.getString("showMessage"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{messageLink});
                cellItem.add(new Component[]{panel});
                if (!StringUtils.hasText((String)((TaskExecTO)model.getObject()).getMessage())) {
                    messageLink.setEnabled(false);
                }
            }
        });
        columns.add(new AbstractColumn<TaskExecTO>((IModel)new ResourceModel("delete")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<TaskExecTO>> cellItem, String componentId, IModel<TaskExecTO> model) {
                final TaskExecTO taskExecutionTO = (TaskExecTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            TaskModalPage.this.taskRestClient.deleteExecution(taskExecutionTO.getId());
                            taskTO.removeExecution(taskExecutionTO);
                            this.info((Serializable)((Object)this.getString("operation_succeded")));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{TaskModalPage.this.feedbackPanel});
                        target.add(new Component[]{TaskModalPage.this.executions});
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)TaskModalPage.this.xmlRolesReader.getAllAllowedRoles("Tasks", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("executionsTable", columns, (ISortableDataProvider)new TaskExecutionsProvider(taskTO), 10);
        this.executions.add(new Component[]{table});
    }

    protected String getCronField(FormComponent formComponent, int field) {
        String cronField = null;
        if (formComponent != null) {
            cronField = this.getCronField(formComponent.getInput(), field);
        }
        return cronField;
    }

    protected String getCronField(String cron, int field) {
        String cronField = null;
        if (cron != null && !cron.isEmpty() && !"UNSCHEDULE".equals(cron)) {
            cronField = cron.split(" ")[field].trim();
        }
        return cronField;
    }

    protected String getCron(FormComponent seconds, FormComponent minutes, FormComponent hours, FormComponent daysOfMonth, FormComponent months, FormComponent daysOfWeek) {
        StringBuilder cron = new StringBuilder();
        if (seconds != null && seconds.getInput() != null && minutes != null && minutes.getInput() != null && hours != null && hours.getInput() != null && daysOfMonth != null && daysOfMonth.getInput() != null && months != null && months.getInput() != null && daysOfWeek != null && daysOfWeek.getInput() != null) {
            cron.append(seconds.getInput().trim()).append(" ").append(minutes.getInput().trim()).append(" ").append(hours.getInput().trim()).append(" ").append(daysOfMonth.getInput().trim()).append(" ").append(months.getInput().trim()).append(" ").append(daysOfWeek.getInput().trim());
        }
        return cron.toString();
    }

    protected class TaskExecutionsProvider
    extends SortableDataProvider<TaskExecTO> {
        private static final long serialVersionUID = 8943636537120648961L;
        private SortableDataProviderComparator<TaskExecTO> comparator;
        private TaskTO taskTO;

        public TaskExecutionsProvider(TaskTO taskTO) {
            this.taskTO = taskTO;
            this.setSort("startDate", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<TaskExecTO>(this);
        }

        public Iterator<TaskExecTO> iterator(int first, int count) {
            List<TaskExecTO> list = this.getTaskDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getTaskDB().size();
        }

        public IModel<TaskExecTO> model(final TaskExecTO taskExecution) {
            return new AbstractReadOnlyModel<TaskExecTO>(){
                private static final long serialVersionUID = 7485475149862342421L;

                public TaskExecTO getObject() {
                    return taskExecution;
                }
            };
        }

        public List<TaskExecTO> getTaskDB() {
            return this.taskTO.getExecutions();
        }
    }
}

