/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.UserRequestTO;
import org.syncope.client.to.WorkflowFormTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.SyncopeSession;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.ApprovalModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.rest.ApprovalRestClient;
import org.syncope.console.rest.UserRequestRestClient;
import org.syncope.console.rest.UserRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.LinkPanel;
import org.syncope.types.UserRequestType;

public class Todo
extends BasePage {
    private static final long serialVersionUID = -7122136682275797903L;
    @SpringBean
    private ApprovalRestClient approvalRestClient;
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private UserRequestRestClient userRequestRestClient;
    private final ModalWindow editApprovalWin;
    private final ModalWindow editUserRequestWin;
    private static final int APPROVAL_WIN_HEIGHT = 400;
    private static final int APPROVAL_WIN_WIDTH = 600;
    private static final int USER_REQUEST_WIN_HEIGHT = 550;
    private static final int USER_REQUESTL_WIN_WIDTH = 800;
    @SpringBean
    private PreferenceManager prefMan;
    private WebMarkupContainer approvalContainer;
    private WebMarkupContainer userRequestContainer;
    private int approvalPaginatorRows;
    private int userRequestPaginatorRows;

    public Todo(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.editApprovalWin = new ModalWindow("editApprovalWin");
        componentArray[0] = this.editApprovalWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editUserRequestWin = new ModalWindow("editUserRequestWin");
        componentArray2[0] = this.editUserRequestWin;
        this.add(componentArray2);
        this.setupApproval();
        this.setupUserRequest();
    }

    private void setupApproval() {
        this.approvalContainer = new WebMarkupContainer("approvalContainer");
        this.approvalPaginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "approval.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("taskId"), "taskId", "taskId"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("key"), "key", "key"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("description"), "description", "description"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("createTime"), "createTime", "createTime"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("dueDate"), "dueDate", "dueDate"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("owner"), "owner", "owner"));
        columns.add(new AbstractColumn<WorkflowFormTO>((IModel)new ResourceModel("claim")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<WorkflowFormTO>> cellItem, String componentId, IModel<WorkflowFormTO> model) {
                final WorkflowFormTO formTO = (WorkflowFormTO)model.getObject();
                IndicatingAjaxLink claimLink = new IndicatingAjaxLink("link"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Todo.this.approvalRestClient.claimForm(formTO.getTaskId());
                            this.info((Serializable)((Object)this.getString("operation_succeded")));
                        }
                        catch (SyncopeClientCompositeErrorException scee) {
                            this.error((Serializable)((Object)(this.getString("error") + ":" + scee.getMessage())));
                        }
                        target.add(new Component[]{Todo.this.feedbackPanel});
                        target.add(new Component[]{Todo.this.approvalContainer});
                    }
                };
                claimLink.add(new Component[]{new Label("linkTitle", Todo.this.getString("claim"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{claimLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Todo.this.xmlRolesReader.getAllAllowedRoles("Approval", "claim"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<WorkflowFormTO>((IModel)new ResourceModel("manage")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<WorkflowFormTO>> cellItem, String componentId, IModel<WorkflowFormTO> model) {
                Object panel;
                final WorkflowFormTO formTO = (WorkflowFormTO)model.getObject();
                if (SyncopeSession.get().getUserId().equals(formTO.getOwner())) {
                    IndicatingAjaxLink manageLink = new IndicatingAjaxLink("link"){
                        private static final long serialVersionUID = -7978723352517770644L;

                        public void onClick(AjaxRequestTarget target) {
                            Todo.this.editApprovalWin.setPageCreator(new ModalWindow.PageCreator(){

                                public Page createPage() {
                                    return new ApprovalModalPage(Todo.this.getPageReference(), Todo.this.editApprovalWin, formTO);
                                }
                            });
                            Todo.this.editApprovalWin.show(target);
                        }
                    };
                    manageLink.add(new Component[]{new Label("linkTitle", Todo.this.getString("manage"))});
                    panel = new LinkPanel(componentId);
                    panel.add(new Component[]{manageLink});
                    MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Todo.this.xmlRolesReader.getAllAllowedRoles("Approval", "read"));
                } else {
                    panel = new EmptyPanel(componentId);
                }
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable approvalTable = new AjaxFallbackDefaultDataTable("approvalTable", columns, (ISortableDataProvider)new ApprovalProvider(), this.approvalPaginatorRows);
        this.approvalContainer.add(new Component[]{approvalTable});
        this.approvalContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.approvalContainer});
        Form approvalPaginatorForm = new Form("approvalPaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "approvalPaginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Todo.this.prefMan.set(Todo.this.getRequest(), Todo.this.getResponse(), "approval.paginator.rows", String.valueOf(Todo.this.approvalPaginatorRows));
                approvalTable.setItemsPerPage(Todo.this.approvalPaginatorRows);
                target.add(new Component[]{Todo.this.approvalContainer});
            }
        }});
        approvalPaginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{approvalPaginatorForm});
        this.editApprovalWin.setCssClassName("w_silver");
        this.editApprovalWin.setInitialHeight(400);
        this.editApprovalWin.setInitialWidth(600);
        this.editApprovalWin.setCookieName("edit-approval-modal");
        this.setWindowClosedCallback(this.editApprovalWin, this.approvalContainer);
    }

    private void setupUserRequest() {
        this.userRequestContainer = new WebMarkupContainer("userRequestContainer");
        this.userRequestPaginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "userRequest.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), "id", "id"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("type"), "type", "type"));
        columns.add((Object)new UserRequestColumn("user"));
        columns.add(new AbstractColumn<UserRequestTO>((IModel)new ResourceModel("manage")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<UserRequestTO>> cellItem, String componentId, final IModel<UserRequestTO> model) {
                IndicatingAjaxLink manageLink = new IndicatingAjaxLink("link"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        Todo.this.editUserRequestWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                return new UserModalPage(Todo.this.getPageReference(), Todo.this.editUserRequestWin, (UserRequestTO)model.getObject());
                            }
                        });
                        Todo.this.editUserRequestWin.show(target);
                    }
                };
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("link"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Todo.this.userRestClient.delete(((UserRequestTO)model.getObject()).getUserId());
                            Todo.this.userRequestRestClient.delete(((UserRequestTO)model.getObject()).getId());
                        }
                        catch (SyncopeClientCompositeErrorException e) {
                            BasePage.LOG.error("While deleting an user", (Throwable)e);
                            this.error((Serializable)((Object)e.getMessage()));
                            return;
                        }
                        this.info((Serializable)((Object)this.getString("operation_succeded")));
                        target.add(new Component[]{Todo.this.feedbackPanel});
                        target.add(new Component[]{Todo.this.userRequestContainer});
                    }
                };
                MetaDataRoleAuthorizationStrategy.authorize((Component)deleteLink, (Action)Component.ENABLE, (String)Todo.this.xmlRolesReader.getAllAllowedRoles("Users", "delete"));
                IndicatingDeleteOnConfirmAjaxLink link = ((UserRequestTO)model.getObject()).getType() == UserRequestType.DELETE ? deleteLink : manageLink;
                link.add(new Component[]{new Label("linkTitle", Todo.this.getString("manage"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{link});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Todo.this.xmlRolesReader.getAllAllowedRoles("UserRequest", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<UserRequestTO>((IModel)new ResourceModel("delete")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<UserRequestTO>> cellItem, String componentId, IModel<UserRequestTO> model) {
                final UserRequestTO request = (UserRequestTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Todo.this.userRequestRestClient.delete(request.getId());
                        }
                        catch (SyncopeClientCompositeErrorException e) {
                            BasePage.LOG.error("While deleting an user request", (Throwable)e);
                            this.error((Serializable)((Object)e.getMessage()));
                            return;
                        }
                        this.info((Serializable)((Object)this.getString("operation_succeded")));
                        target.add(new Component[]{Todo.this.feedbackPanel});
                        target.add(new Component[]{Todo.this.userRequestContainer});
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Todo.this.xmlRolesReader.getAllAllowedRoles("UserRequest", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable userRequestTable = new AjaxFallbackDefaultDataTable("userRequestTable", columns, (ISortableDataProvider)new UserRequestProvider(), this.userRequestPaginatorRows);
        this.userRequestContainer.add(new Component[]{userRequestTable});
        this.userRequestContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.userRequestContainer});
        Form userRequestPaginatorForm = new Form("userRequestPaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "userRequestPaginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Todo.this.prefMan.set(Todo.this.getRequest(), Todo.this.getResponse(), "userRequest.paginator.rows", String.valueOf(Todo.this.userRequestPaginatorRows));
                userRequestTable.setItemsPerPage(Todo.this.userRequestPaginatorRows);
                target.add(new Component[]{Todo.this.userRequestContainer});
            }
        }});
        userRequestPaginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{userRequestPaginatorForm});
        this.editUserRequestWin.setCssClassName("w_silver");
        this.editUserRequestWin.setInitialHeight(550);
        this.editUserRequestWin.setInitialWidth(800);
        this.editUserRequestWin.setCookieName("edit-userRequest-modal");
        this.setWindowClosedCallback(this.editUserRequestWin, this.userRequestContainer);
    }

    private class UserRequestColumn
    extends AbstractColumn<UserRequestTO> {
        private static final long serialVersionUID = 8077865338230121496L;

        public UserRequestColumn(String name) {
            super((IModel)new ResourceModel(name, name), name);
        }

        public void populateItem(Item<ICellPopulator<UserRequestTO>> cellItem, String componentId, IModel<UserRequestTO> rowModel) {
            String label = "";
            switch (((UserRequestTO)rowModel.getObject()).getType()) {
                case CREATE: {
                    label = ((UserRequestTO)rowModel.getObject()).getUserTO().getUsername();
                    if (label != null) break;
                    label = Todo.this.getString("new_user");
                    break;
                }
                case UPDATE: {
                    label = String.valueOf(((UserRequestTO)rowModel.getObject()).getUserMod().getId());
                    break;
                }
                case DELETE: {
                    label = String.valueOf(((UserRequestTO)rowModel.getObject()).getUserId());
                    break;
                }
            }
            cellItem.add(new Component[]{new Label(componentId, label)});
        }
    }

    private class UserRequestProvider
    extends SortableDataProvider<UserRequestTO> {
        private static final long serialVersionUID = -2311716167583335852L;
        private SortableDataProviderComparator<UserRequestTO> comparator;

        public UserRequestProvider() {
            this.setSort("id", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<UserRequestTO>(this);
        }

        public Iterator<UserRequestTO> iterator(int first, int count) {
            List<UserRequestTO> list = Todo.this.userRequestRestClient.list();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return Todo.this.userRequestRestClient.list().size();
        }

        public IModel<UserRequestTO> model(final UserRequestTO userRequestTO) {
            return new AbstractReadOnlyModel<UserRequestTO>(){
                private static final long serialVersionUID = -2566070996511906708L;

                public UserRequestTO getObject() {
                    return userRequestTO;
                }
            };
        }
    }

    private class ApprovalProvider
    extends SortableDataProvider<WorkflowFormTO> {
        private static final long serialVersionUID = -2311716167583335852L;
        private SortableDataProviderComparator<WorkflowFormTO> comparator;

        public ApprovalProvider() {
            this.setSort("key", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<WorkflowFormTO>(this);
        }

        public Iterator<WorkflowFormTO> iterator(int first, int count) {
            List<WorkflowFormTO> list = Todo.this.approvalRestClient.getForms();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return Todo.this.approvalRestClient.getForms().size();
        }

        public IModel<WorkflowFormTO> model(final WorkflowFormTO configuration) {
            return new AbstractReadOnlyModel<WorkflowFormTO>(){
                private static final long serialVersionUID = -2566070996511906708L;

                public WorkflowFormTO getObject() {
                    return configuration;
                }
            };
        }
    }
}

