/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.syncope.client.search.NodeCond;
import org.syncope.client.to.UserTO;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.pages.panels.ResultSetPanel;
import org.syncope.console.pages.panels.UserSearchPanel;

public class Users
extends BasePage {
    private static final long serialVersionUID = 134681165644474568L;
    private static final int EDIT_MODAL_WIN_HEIGHT = 550;
    private static final int EDIT_MODAL_WIN_WIDTH = 800;

    public Users(PageParameters parameters) {
        super(parameters);
        final ModalWindow editModalWin = new ModalWindow("editModal");
        editModalWin.setCssClassName("w_silver");
        editModalWin.setInitialHeight(550);
        editModalWin.setInitialWidth(800);
        editModalWin.setCookieName("edit-modal");
        this.add(new Component[]{editModalWin});
        final ResultSetPanel searchResult = new ResultSetPanel("searchResult", true, null, this.getPageReference());
        this.add(new Component[]{searchResult});
        ResultSetPanel listResult = new ResultSetPanel("listResult", false, null, this.getPageReference());
        this.add(new Component[]{listResult});
        IndicatingAjaxLink createLink = new IndicatingAjaxLink("createLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                editModalWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new UserModalPage(Users.this.getPageReference(), editModalWin, new UserTO(), UserModalPage.Mode.ADMIN);
                    }
                });
                editModalWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createLink, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Users", "create"));
        this.add(new Component[]{createLink});
        this.setWindowClosedReloadCallback(editModalWin);
        Form searchForm = new Form("searchForm");
        this.add(new Component[]{searchForm});
        final UserSearchPanel searchPanel = new UserSearchPanel("searchPanel");
        searchForm.add(new Component[]{searchPanel});
        searchForm.add(new Component[]{new IndicatingAjaxButton("search", (IModel)new ResourceModel("search")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                NodeCond searchCond = searchPanel.buildSearchCond();
                BasePage.LOG.debug("Node condition " + searchCond);
                Users.this.doSearch(target, searchCond, searchResult);
                Session.get().getFeedbackMessages().clear();
                target.add(new Component[]{searchPanel.getSearchFeedback()});
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{searchPanel.getSearchFeedback()});
            }
        }});
    }

    private void doSearch(AjaxRequestTarget target, NodeCond searchCond, ResultSetPanel resultsetPanel) {
        if (searchCond == null || !searchCond.checkValidity()) {
            this.error((Serializable)((Object)this.getString("search_error")));
            return;
        }
        resultsetPanel.search(searchCond, target);
    }

    private void setWindowClosedReloadCallback(ModalWindow window) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                ResultSetPanel.EventDataWrapper data = new ResultSetPanel.EventDataWrapper();
                data.setTarget(target);
                data.setCreate(true);
                Users.this.send((IEventSink)Users.this.getPage(), Broadcast.BREADTH, data);
                if (Users.this.isModalResult()) {
                    Users.this.setModalResult(false);
                    Users.this.getSession().info((Serializable)((Object)Users.this.getString("operation_succeded")));
                    target.add(new Component[]{Users.this.feedbackPanel});
                }
            }
        });
    }
}

