/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.pages.Schema;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateTimeFieldPanel;
import org.syncope.console.wicket.markup.html.form.FieldPanel;
import org.syncope.console.wicket.markup.html.form.MultiValueSelectorPanel;
import org.syncope.types.SchemaType;

public class AttributesPanel
extends Panel {
    private static final long serialVersionUID = 552437609667518888L;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    private final boolean templateMode;

    public <T extends AbstractAttributableTO> AttributesPanel(String id, final T entityTO, Form form, final boolean templateMode) {
        super(id);
        this.templateMode = templateMode;
        LoadableDetachableModel<Map<String, SchemaTO>> schemas = new LoadableDetachableModel<Map<String, SchemaTO>>(){
            private static final long serialVersionUID = -2012833443695917883L;

            protected Map<String, SchemaTO> load() {
                List<SchemaTO> schemaTOs = entityTO instanceof RoleTO ? AttributesPanel.this.schemaRestClient.getSchemas("role") : (entityTO instanceof UserTO ? AttributesPanel.this.schemaRestClient.getSchemas("user") : AttributesPanel.this.schemaRestClient.getSchemas("membership"));
                HashMap<String, SchemaTO> schemas = new HashMap<String, SchemaTO>();
                for (SchemaTO schemaTO : schemaTOs) {
                    schemas.put(schemaTO.getName(), schemaTO);
                }
                return schemas;
            }
        };
        this.initEntityData(entityTO, ((Map)schemas.getObject()).values());
        ListView<AttributeTO> attributeView = new ListView<AttributeTO>("schemas", (IModel)new PropertyModel(entityTO, "attributes"), (IModel)schemas, form){
            private static final long serialVersionUID = 9101744072914090143L;
            final /* synthetic */ IModel val$schemas;
            final /* synthetic */ Form val$form;
            {
                this.val$schemas = iModel;
                this.val$form = form;
                super(x0, x1);
            }

            protected void populateItem(ListItem item) {
                AttributeTO attributeTO = (AttributeTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("name", templateMode ? attributeTO.getSchema() + " (JEXL)" : attributeTO.getSchema())});
                FieldPanel panel = AttributesPanel.this.getFieldPanel((SchemaTO)((Map)this.val$schemas.getObject()).get(attributeTO.getSchema()), this.val$form, attributeTO);
                if (templateMode || !((SchemaTO)((Map)this.val$schemas.getObject()).get(attributeTO.getSchema())).isMultivalue()) {
                    item.add(new Component[]{panel});
                } else {
                    item.add(new Component[]{new MultiValueSelectorPanel("panel", new PropertyModel((Object)attributeTO, "values"), String.class, panel)});
                }
            }
        };
        this.add(new Component[]{attributeView});
    }

    private List<AttributeTO> initEntityData(AbstractAttributableTO entityTO, Collection<SchemaTO> schemas) {
        ArrayList<AttributeTO> entityData = new ArrayList<AttributeTO>();
        Map attrMap = entityTO.getAttributeMap();
        for (SchemaTO schema : schemas) {
            AttributeTO attributeTO = new AttributeTO();
            attributeTO.setSchema(schema.getName());
            if (attrMap.get(schema.getName()) == null || ((AttributeTO)attrMap.get(schema.getName())).getValues().isEmpty()) {
                ArrayList<String> values = new ArrayList<String>();
                values.add("");
                attributeTO.setValues(values);
                attributeTO.setReadonly(schema.isReadonly());
            } else {
                attributeTO.setValues(((AttributeTO)attrMap.get(schema.getName())).getValues());
            }
            entityData.add(attributeTO);
        }
        entityTO.setAttributes(entityData);
        return entityData;
    }

    private FieldPanel getFieldPanel(SchemaTO schemaTO, Form form, AttributeTO attributeTO) {
        FieldPanel panel;
        boolean required = this.templateMode ? false : schemaTO.getMandatoryCondition().equalsIgnoreCase("true");
        boolean readOnly = this.templateMode ? false : schemaTO.isReadonly();
        SchemaType type = this.templateMode ? SchemaType.String : schemaTO.getType();
        switch (type) {
            case Boolean: {
                panel = new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel<Boolean>)new Model(), true);
                panel.setRequired(required);
                break;
            }
            case Date: {
                if (!schemaTO.getConversionPattern().contains("H")) {
                    panel = new DateTextFieldPanel("panel", schemaTO.getName(), (IModel<Date>)new Model(), true, schemaTO.getConversionPattern());
                    if (!required) break;
                    panel.addRequiredLabel();
                    break;
                }
                panel = new DateTimeFieldPanel("panel", schemaTO.getName(), (IModel<Date>)new Model(), true, schemaTO.getConversionPattern());
                if (required) {
                    panel.addRequiredLabel();
                    ((DateTimeFieldPanel)panel).setFormValidator(form);
                }
                panel.setStyleShet("ui-widget-content ui-corner-all");
                break;
            }
            case Enum: {
                panel = new AjaxDropDownChoicePanel("panel", schemaTO.getName(), new Model(), true);
                ((AjaxDropDownChoicePanel)panel).setChoices(Arrays.asList(schemaTO.getEnumerationValues().split(Schema.enumValuesSeparator)));
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel<String>)new Model(), true);
                if (!required) break;
                panel.addRequiredLabel();
            }
        }
        panel.setReadOnly(readOnly);
        panel.setNewModel(attributeTO.getValues());
        return panel;
    }
}

