/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.NotificationTaskTO;
import org.syncope.client.to.TaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.NotificationTaskModalPage;
import org.syncope.console.pages.Tasks;
import org.syncope.console.rest.TaskRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public class NotificationTasks
extends Panel {
    private static final int WIN_HEIGHT = 500;
    private static final int WIN_WIDTH = 700;
    private static final long serialVersionUID = 4984337552918213290L;
    @SpringBean
    private TaskRestClient restClient;
    @SpringBean
    private PreferenceManager prefMan;
    private int paginatorRows;
    private WebMarkupContainer container;
    private boolean operationResult = false;
    private ModalWindow window;
    @SpringBean
    protected XMLRolesReader xmlRolesReader;

    public NotificationTasks(String id) {
        super(id);
        Component[] componentArray = new Component[1];
        this.window = new ModalWindow("taskWin");
        componentArray[0] = this.window;
        this.add(componentArray);
        this.paginatorRows = this.prefMan.getPaginatorRows((Request)this.getWebRequest(), "notificationtasks.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), "id", "id"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("sender"), "sender", "sender"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("recipients"), "recipients", "recipients"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("subject"), "subject", "subject"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("traceLevel"), "traceLevel", "traceLevel"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("latestExecStatus"), "latestExecStatus", "latestExecStatus"));
        columns.add(new AbstractColumn<TaskTO>((IModel)new ResourceModel("detail")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<TaskTO>> cellItem, String componentId, IModel<TaskTO> model) {
                final TaskTO taskTO = (TaskTO)model.getObject();
                IndicatingAjaxLink viewLink = new IndicatingAjaxLink("editLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        NotificationTasks.this.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new NotificationTaskModalPage(taskTO);
                            }
                        });
                        NotificationTasks.this.window.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{viewLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)NotificationTasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<TaskTO>((IModel)new ResourceModel("execute")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<TaskTO>> cellItem, String componentId, IModel<TaskTO> model) {
                final TaskTO taskTO = (TaskTO)model.getObject();
                IndicatingAjaxLink executeLink = new IndicatingAjaxLink("link"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            NotificationTasks.this.restClient.startExecution(taskTO.getId(), false);
                            this.getSession().info((Serializable)((Object)this.getString("operation_succeded")));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{this.getPage().get("feedback")});
                        target.add(new Component[]{NotificationTasks.this.container});
                    }
                };
                executeLink.add(new Component[]{new Label("linkTitle", NotificationTasks.this.getString("execute"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{executeLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)NotificationTasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "execute"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<TaskTO>((IModel)new ResourceModel("delete")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<TaskTO>> cellItem, String componentId, IModel<TaskTO> model) {
                final TaskTO taskTO = (TaskTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            NotificationTasks.this.restClient.delete(taskTO.getId());
                            this.info((Serializable)((Object)this.getString("operation_succeded")));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{NotificationTasks.this.container});
                        target.add(new Component[]{this.getPage().get("feedback")});
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)NotificationTasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, new Tasks.TasksProvider<NotificationTaskTO>(this.restClient, this.paginatorRows, this.getId(), NotificationTaskTO.class), this.paginatorRows);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                target.add(new Component[]{NotificationTasks.this.container});
                if (NotificationTasks.this.operationResult) {
                    NotificationTasks.this.info((Serializable)((Object)NotificationTasks.this.getString("operation_succeded")));
                    target.add(new Component[]{NotificationTasks.this.getPage().get("feedback")});
                    NotificationTasks.this.operationResult = false;
                }
            }
        });
        this.window.setCssClassName("w_silver");
        this.window.setInitialHeight(500);
        this.window.setInitialWidth(700);
        this.window.setCookieName("view-task-win");
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                NotificationTasks.this.prefMan.set((Request)NotificationTasks.this.getWebRequest(), (Response)((WebResponse)NotificationTasks.this.getResponse()), "notificationtasks.paginator.rows", String.valueOf(NotificationTasks.this.paginatorRows));
                table.setItemsPerPage(NotificationTasks.this.paginatorRows);
                target.add(new Component[]{NotificationTasks.this.container});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }
}

