/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.to.PolicyTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.console.rest.PolicyRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.types.PolicyType;

public class ResourceSecurityPanel
extends Panel {
    protected static final Logger LOG = LoggerFactory.getLogger(ResourceSecurityPanel.class);
    private static final long serialVersionUID = -7982691107029848579L;
    @SpringBean
    private PolicyRestClient policyRestClient;
    IModel<Map<Long, String>> passwordPolicies = null;
    IModel<Map<Long, String>> accountPolicies = null;
    IModel<Map<Long, String>> syncPolicies = null;

    public ResourceSecurityPanel(String id, ResourceTO resourceTO) {
        super(id);
        this.setOutputMarkupId(true);
        this.passwordPolicies = new LoadableDetachableModel<Map<Long, String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected Map<Long, String> load() {
                HashMap<Long, String> res = new HashMap<Long, String>();
                for (PolicyTO policyTO : ResourceSecurityPanel.this.policyRestClient.getPolicies(PolicyType.PASSWORD)) {
                    res.put(policyTO.getId(), policyTO.getDescription());
                }
                return res;
            }
        };
        this.accountPolicies = new LoadableDetachableModel<Map<Long, String>>(){
            private static final long serialVersionUID = -2012833443695917883L;

            protected Map<Long, String> load() {
                HashMap<Long, String> res = new HashMap<Long, String>();
                for (PolicyTO policyTO : ResourceSecurityPanel.this.policyRestClient.getPolicies(PolicyType.ACCOUNT)) {
                    res.put(policyTO.getId(), policyTO.getDescription());
                }
                return res;
            }
        };
        this.syncPolicies = new LoadableDetachableModel<Map<Long, String>>(){
            private static final long serialVersionUID = -2012833443695917883L;

            protected Map<Long, String> load() {
                HashMap<Long, String> res = new HashMap<Long, String>();
                for (PolicyTO policyTO : ResourceSecurityPanel.this.policyRestClient.getPolicies(PolicyType.SYNC)) {
                    res.put(policyTO.getId(), policyTO.getDescription());
                }
                return res;
            }
        };
        WebMarkupContainer securityContainer = new WebMarkupContainer("security");
        securityContainer.setOutputMarkupId(true);
        this.add(new Component[]{securityContainer});
        AjaxDropDownChoicePanel passwordPolicy = new AjaxDropDownChoicePanel("passwordPolicy", this.getString("passwordPolicy"), new PropertyModel((Object)resourceTO, "passwordPolicy"), false);
        passwordPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(PolicyType.PASSWORD));
        passwordPolicy.setChoices(new ArrayList(((Map)this.passwordPolicies.getObject()).keySet()));
        ((DropDownChoice)passwordPolicy.getField()).setNullValid(true);
        securityContainer.add(new Component[]{passwordPolicy});
        AjaxDropDownChoicePanel accountPolicy = new AjaxDropDownChoicePanel("accountPolicy", this.getString("accountPolicy"), new PropertyModel((Object)resourceTO, "accountPolicy"), false);
        accountPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(PolicyType.ACCOUNT));
        accountPolicy.setChoices(new ArrayList(((Map)this.accountPolicies.getObject()).keySet()));
        ((DropDownChoice)accountPolicy.getField()).setNullValid(true);
        securityContainer.add(new Component[]{accountPolicy});
        AjaxDropDownChoicePanel syncPolicy = new AjaxDropDownChoicePanel("syncPolicy", this.getString("syncPolicy"), new PropertyModel((Object)resourceTO, "syncPolicy"), false);
        syncPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(PolicyType.SYNC));
        syncPolicy.setChoices(new ArrayList(((Map)this.syncPolicies.getObject()).keySet()));
        ((DropDownChoice)syncPolicy.getField()).setNullValid(true);
        securityContainer.add(new Component[]{syncPolicy});
    }

    private class PolicyRenderer
    extends ChoiceRenderer<Long> {
        private static final long serialVersionUID = 8060500161321947000L;
        private PolicyType type;

        public PolicyRenderer(PolicyType type) {
            this.type = type;
        }

        public Object getDisplayValue(Long object) {
            switch (this.type) {
                case GLOBAL_ACCOUNT: 
                case ACCOUNT: {
                    return ((Map)ResourceSecurityPanel.this.accountPolicies.getObject()).get(object);
                }
                case GLOBAL_PASSWORD: 
                case PASSWORD: {
                    return ((Map)ResourceSecurityPanel.this.passwordPolicies.getObject()).get(object);
                }
                case GLOBAL_SYNC: 
                case SYNC: {
                    return ((Map)ResourceSecurityPanel.this.syncPolicies.getObject()).get(object);
                }
            }
            return "";
        }

        public String getIdValue(Long object, int index) {
            return String.valueOf(object != null ? object : 0L);
        }
    }
}

