/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.resource.ContextRelativeResource;
import org.apache.wicket.request.resource.IResource;
import org.syncope.client.to.UserTO;
import org.syncope.console.pages.UserModalPage;
import org.syncope.types.PropagationTaskExecStatus;

public class UserModalPageResult
extends Panel {
    private static final long serialVersionUID = 2646115294319713723L;
    private static final int PROPAGATION_RESULT_PAGINATOR_ROWS = 7;

    public UserModalPageResult(String id, final ModalWindow window, UserModalPage.Mode mode, UserTO userTO) {
        super(id);
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        Fragment fragment = new Fragment("userModalResultFrag", mode == UserModalPage.Mode.SELF ? "userModalSelfResultFrag" : "userModalPropagationResultFrag", (MarkupContainer)this);
        fragment.setOutputMarkupId(true);
        container.add(new Component[]{fragment});
        if (mode == UserModalPage.Mode.ADMIN) {
            final Map propagationMap = userTO.getPropagationStatusMap();
            ArrayList resourceListKey = new ArrayList(propagationMap.keySet());
            resourceListKey.add(0, "Syncope");
            propagationMap.put("Syncope", PropagationTaskExecStatus.SUCCESS);
            fragment.add(new Component[]{new Label("userInfo", userTO.getUsername())});
            PageableListView<String> propagationStatus = new PageableListView<String>("propagationResults", resourceListKey, 7){
                private static final long serialVersionUID = -1020475259727720708L;

                protected void populateItem(ListItem item) {
                    String resourceItem = (String)item.getDefaultModelObject();
                    item.add(new Component[]{new Label("resourceName", resourceItem)});
                    item.add(new Component[]{new Label("propagation", ((PropagationTaskExecStatus)propagationMap.get(resourceItem)).name())});
                    item.add(new Component[]{new Image("status", (IResource)(((PropagationTaskExecStatus)propagationMap.get(resourceItem)).isSuccessful() ? new ContextRelativeResource("img/success.png") : new ContextRelativeResource("img/warning.png")))});
                }
            };
            fragment.add(new Component[]{propagationStatus});
            fragment.add(new Component[]{new AjaxPagingNavigator("navigator", (IPageable)propagationStatus)});
        }
        IndicatingAjaxLink close = new IndicatingAjaxLink("close"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                window.close(target);
            }
        };
        container.add(new Component[]{close});
    }
}

