/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.search.AttributeCond;
import org.syncope.client.search.MembershipCond;
import org.syncope.client.search.NodeCond;
import org.syncope.client.search.ResourceCond;
import org.syncope.client.search.SyncopeUserCond;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.commons.SearchCondWrapper;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.RoleRestClient;
import org.syncope.console.rest.SchemaRestClient;

public class UserSearchPanel
extends Panel {
    private static final long serialVersionUID = -1769527800450203738L;
    private static final Logger LOG = LoggerFactory.getLogger(UserSearchPanel.class);
    private List<String> ATTRIBUTES_NOTINCLUDED = Arrays.asList("attributes", "derivedAttributes", "virtualAttributes", "serialVersionUID", "memberships", "resources", "password", "propagationStatusMap");
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    private final IModel<List<String>> dnames = new LoadableDetachableModel<List<String>>(){

        protected List<String> load() {
            ArrayList<String> details = new ArrayList<String>();
            for (Class clazz = UserTO.class; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (UserSearchPanel.this.ATTRIBUTES_NOTINCLUDED.contains(field.getName())) continue;
                    details.add(field.getName());
                }
            }
            Collections.reverse(details);
            return details;
        }
    };
    private final IModel<List<String>> unames = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return UserSearchPanel.this.schemaRestClient.getSchemaNames("user");
        }
    };
    private final IModel<List<String>> ronames = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            List<RoleTO> roleTOs = UserSearchPanel.this.roleRestClient.getAllRoles();
            ArrayList<String> result = new ArrayList<String>(roleTOs.size());
            for (RoleTO role : roleTOs) {
                result.add(role.getDisplayName());
            }
            return result;
        }
    };
    private final IModel<List<String>> renames = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            List<ResourceTO> resourceTOs = UserSearchPanel.this.resourceRestClient.getAllResources();
            ArrayList<String> result = new ArrayList<String>(resourceTOs.size());
            for (ResourceTO resource : resourceTOs) {
                result.add(resource.getName());
            }
            return result;
        }
    };
    private final IModel<List<AttributeCond.Type>> attributeTypes = new LoadableDetachableModel<List<AttributeCond.Type>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<AttributeCond.Type> load() {
            return Arrays.asList(AttributeCond.Type.values());
        }
    };
    private final IModel<List<SearchCondWrapper.FilterType>> filterTypes = new LoadableDetachableModel<List<SearchCondWrapper.FilterType>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<SearchCondWrapper.FilterType> load() {
            return Arrays.asList(SearchCondWrapper.FilterType.values());
        }
    };
    final FeedbackPanel searchFeedback;
    final List<SearchCondWrapper> searchConditionList;

    public UserSearchPanel(String id) {
        this(id, null);
    }

    public UserSearchPanel(String id, NodeCond searchCondition) {
        super(id);
        this.setOutputMarkupId(true);
        final WebMarkupContainer searchFormContainer = new WebMarkupContainer("searchFormContainer");
        searchFormContainer.setOutputMarkupId(true);
        this.searchFeedback = new FeedbackPanel("searchFeedback", new IFeedbackMessageFilter(){
            private static final long serialVersionUID = 6895024863321391672L;

            public boolean accept(FeedbackMessage message) {
                boolean result = message.getReporter() != null ? searchFormContainer.contains(message.getReporter(), true) : false;
                return result;
            }
        });
        this.searchFeedback.setOutputMarkupId(true);
        this.add(new Component[]{this.searchFeedback});
        if (searchCondition == null) {
            this.searchConditionList = new ArrayList<SearchCondWrapper>();
            this.searchConditionList.add(new SearchCondWrapper());
        } else {
            this.searchConditionList = this.getSearchCondWrappers(searchCondition);
        }
        searchFormContainer.add(new Component[]{new SearchView("searchView", this.searchConditionList, searchFormContainer)});
        IndicatingAjaxButton addAndButton = new IndicatingAjaxButton("addAndButton", (IModel)new ResourceModel("addAndButton")){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                SearchCondWrapper conditionWrapper = new SearchCondWrapper();
                conditionWrapper.setOperationType(SearchCondWrapper.OperationType.AND);
                UserSearchPanel.this.searchConditionList.add(conditionWrapper);
                target.add(new Component[]{searchFormContainer});
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{searchFormContainer});
            }
        };
        addAndButton.setDefaultFormProcessing(false);
        searchFormContainer.add(new Component[]{addAndButton});
        IndicatingAjaxButton addOrButton = new IndicatingAjaxButton("addOrButton", (IModel)new ResourceModel("addOrButton")){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                SearchCondWrapper conditionWrapper = new SearchCondWrapper();
                conditionWrapper.setOperationType(SearchCondWrapper.OperationType.OR);
                UserSearchPanel.this.searchConditionList.add(conditionWrapper);
                target.add(new Component[]{searchFormContainer});
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{searchFormContainer});
            }
        };
        addOrButton.setDefaultFormProcessing(false);
        searchFormContainer.add(new Component[]{addOrButton});
        this.add(new Component[]{searchFormContainer});
    }

    public FeedbackPanel getSearchFeedback() {
        return this.searchFeedback;
    }

    private List<SearchCondWrapper> getSearchCondWrappers(NodeCond searchCond) {
        LOG.debug("Search condition: {}", (Object)searchCond);
        ArrayList<SearchCondWrapper> wrappers = new ArrayList<SearchCondWrapper>();
        switch (searchCond.getType()) {
            case LEAF: 
            case NOT_LEAF: {
                wrappers.add(this.getSearchCondWrapper(searchCond));
                break;
            }
            case AND: 
            case OR: {
                wrappers.add(this.getSearchCondWrapper(searchCond.getLeftNodeCond()));
                SearchCondWrapper wrapper = this.getSearchCondWrapper(searchCond.getRightNodeCond());
                wrapper.setOperationType(searchCond.getType() == NodeCond.Type.AND ? SearchCondWrapper.OperationType.AND : SearchCondWrapper.OperationType.OR);
                wrappers.add(wrapper);
                break;
            }
        }
        LOG.debug("Search condition wrappers: {}", wrappers);
        return wrappers;
    }

    private SearchCondWrapper getSearchCondWrapper(NodeCond searchCond) {
        SearchCondWrapper wrapper = new SearchCondWrapper();
        if (searchCond.getSyncopeUserCond() != null) {
            wrapper.setFilterType(SearchCondWrapper.FilterType.ATTRIBUTE);
            wrapper.setFilterName(searchCond.getSyncopeUserCond().getSchema());
            wrapper.setType(searchCond.getSyncopeUserCond().getType());
            wrapper.setFilterValue(searchCond.getSyncopeUserCond().getExpression());
        }
        if (searchCond.getAttributeCond() != null) {
            wrapper.setFilterType(SearchCondWrapper.FilterType.ATTRIBUTE);
            wrapper.setFilterName(searchCond.getAttributeCond().getSchema());
            wrapper.setType(searchCond.getAttributeCond().getType());
            wrapper.setFilterValue(searchCond.getAttributeCond().getExpression());
        }
        if (searchCond.getMembershipCond() != null) {
            wrapper.setFilterType(SearchCondWrapper.FilterType.MEMBERSHIP);
            RoleTO role = new RoleTO();
            role.setId(searchCond.getMembershipCond().getRoleId().longValue());
            role.setName(searchCond.getMembershipCond().getRoleName());
            wrapper.setFilterName(role.getDisplayName());
        }
        if (searchCond.getResourceCond() != null) {
            wrapper.setFilterType(SearchCondWrapper.FilterType.RESOURCE);
            wrapper.setFilterName(searchCond.getResourceCond().getResourceName());
        }
        wrapper.setNotOperator(searchCond.getType() == NodeCond.Type.NOT_LEAF);
        return wrapper;
    }

    public NodeCond buildSearchCond() {
        return this.buildSearchCond(this.searchConditionList);
    }

    private NodeCond buildSearchCond(List<SearchCondWrapper> conditions) {
        SearchCondWrapper searchConditionWrapper = conditions.get(conditions.size() - 1);
        LOG.debug("Search conditions: fname {}; ftype {}; fvalue {}; OP {}; type {}; isnot {}", new Object[]{searchConditionWrapper.getFilterName(), searchConditionWrapper.getFilterType(), searchConditionWrapper.getFilterValue(), searchConditionWrapper.getOperationType(), searchConditionWrapper.getType(), searchConditionWrapper.isNotOperator()});
        NodeCond nodeCond = null;
        switch (searchConditionWrapper.getFilterType()) {
            case ATTRIBUTE: {
                SyncopeUserCond attributeCond;
                String schema = searchConditionWrapper.getFilterName();
                if (((List)this.dnames.getObject()).contains(schema)) {
                    attributeCond = new SyncopeUserCond();
                    nodeCond = searchConditionWrapper.isNotOperator() ? NodeCond.getNotLeafCond((SyncopeUserCond)attributeCond) : NodeCond.getLeafCond((SyncopeUserCond)attributeCond);
                } else {
                    attributeCond = new AttributeCond();
                    nodeCond = searchConditionWrapper.isNotOperator() ? NodeCond.getNotLeafCond((AttributeCond)attributeCond) : NodeCond.getLeafCond((AttributeCond)attributeCond);
                }
                attributeCond.setSchema(schema);
                attributeCond.setType(searchConditionWrapper.getType());
                attributeCond.setExpression(searchConditionWrapper.getFilterValue());
                break;
            }
            case MEMBERSHIP: {
                MembershipCond membershipCond = new MembershipCond();
                membershipCond.setRoleId(Long.valueOf(RoleTO.fromDisplayName((String)searchConditionWrapper.getFilterName())));
                if (searchConditionWrapper.isNotOperator()) {
                    nodeCond = NodeCond.getNotLeafCond((MembershipCond)membershipCond);
                    break;
                }
                nodeCond = NodeCond.getLeafCond((MembershipCond)membershipCond);
                break;
            }
            case RESOURCE: {
                ResourceCond resourceCond = new ResourceCond();
                resourceCond.setResourceName(searchConditionWrapper.getFilterName());
                if (searchConditionWrapper.isNotOperator()) {
                    nodeCond = NodeCond.getNotLeafCond((ResourceCond)resourceCond);
                    break;
                }
                nodeCond = NodeCond.getLeafCond((ResourceCond)resourceCond);
                break;
            }
        }
        LOG.debug("Processed condition {}", nodeCond);
        if (conditions.size() > 1) {
            List<SearchCondWrapper> subList = conditions.subList(0, conditions.size() - 1);
            nodeCond = SearchCondWrapper.OperationType.OR.equals((Object)searchConditionWrapper.getOperationType()) ? NodeCond.getOrCond((NodeCond)nodeCond, (NodeCond)this.buildSearchCond(subList)) : NodeCond.getAndCond((NodeCond)nodeCond, (NodeCond)this.buildSearchCond(subList));
        }
        return nodeCond;
    }

    private class SearchView
    extends ListView<SearchCondWrapper> {
        private static final long serialVersionUID = -527351923968737757L;
        private final WebMarkupContainer searchFormContainer;

        public SearchView(String id, List<? extends SearchCondWrapper> list, WebMarkupContainer searchFormContainer) {
            super(id, list);
            this.searchFormContainer = searchFormContainer;
        }

        protected void populateItem(ListItem<SearchCondWrapper> item) {
            SearchCondWrapper searchCondition = (SearchCondWrapper)item.getModelObject();
            if (item.getIndex() == 0) {
                item.add(new Component[]{new Label("operationType", "")});
            } else {
                item.add(new Component[]{new Label("operationType", searchCondition.getOperationType().toString())});
            }
            CheckBox notOperator = new CheckBox("notOperator", (IModel)new PropertyModel((Object)searchCondition, "notOperator"));
            notOperator.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget art) {
                }
            }});
            item.add(new Component[]{notOperator});
            DropDownChoice filterNameChooser = new DropDownChoice("filterName", (IModel)new PropertyModel((Object)searchCondition, "filterName"), (IModel)null);
            filterNameChooser.setOutputMarkupId(true);
            filterNameChooser.setRequired(true);
            item.add(new Component[]{filterNameChooser});
            filterNameChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget art) {
                }
            }});
            DropDownChoice type = new DropDownChoice("type", (IModel)new PropertyModel((Object)searchCondition, "type"), UserSearchPanel.this.attributeTypes);
            type.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget art) {
                }
            }});
            item.add(new Component[]{type});
            TextField filterValue = new TextField("filterValue", (IModel)new PropertyModel((Object)searchCondition, "filterValue"));
            item.add(new Component[]{filterValue});
            filterValue.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget art) {
                }
            }});
            DropDownChoice filterTypeChooser = new DropDownChoice("filterType", (IModel)new PropertyModel((Object)searchCondition, "filterType"), UserSearchPanel.this.filterTypes);
            filterTypeChooser.setOutputMarkupId(true);
            filterTypeChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    target.add(new Component[]{SearchView.this.searchFormContainer});
                }
            }});
            filterTypeChooser.setRequired(true);
            item.add(new Component[]{filterTypeChooser});
            IndicatingAjaxButton dropButton = new IndicatingAjaxButton("dropButton", (IModel)new ResourceModel("dropButton")){
                private static final long serialVersionUID = -4804368561204623354L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    SearchView.this.getList().remove(Integer.valueOf(this.getParent().getId()));
                    target.add(new Component[]{SearchView.this.searchFormContainer});
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{SearchView.this.searchFormContainer});
                }
            };
            dropButton.setDefaultFormProcessing(false);
            if (item.getIndex() == 0) {
                dropButton.setVisible(false);
            }
            item.add(new Component[]{dropButton});
            try {
                switch (searchCondition.getFilterType()) {
                    case ATTRIBUTE: {
                        ArrayList names = new ArrayList((Collection)UserSearchPanel.this.dnames.getObject());
                        if (UserSearchPanel.this.unames.getObject() != null && !((List)UserSearchPanel.this.unames.getObject()).isEmpty()) {
                            names.addAll((Collection)UserSearchPanel.this.unames.getObject());
                        }
                        Collections.sort(names);
                        filterNameChooser.setChoices(names);
                        if (!type.isEnabled()) {
                            type.setEnabled(true);
                            type.setRequired(true);
                        }
                        if (!filterValue.isEnabled()) {
                            filterValue.setEnabled(true);
                        }
                        break;
                    }
                    case MEMBERSHIP: {
                        filterNameChooser.setChoices(UserSearchPanel.this.ronames);
                        type.setEnabled(false);
                        type.setRequired(false);
                        type.setModelObject(null);
                        filterValue.setEnabled(false);
                        filterValue.setModelObject((Object)"");
                        break;
                    }
                    case RESOURCE: {
                        filterNameChooser.setChoices(UserSearchPanel.this.renames);
                        type.setEnabled(false);
                        type.setRequired(false);
                        type.setModelObject(null);
                        filterValue.setEnabled(false);
                        filterValue.setModelObject((Object)"");
                        break;
                    }
                    default: {
                        filterNameChooser.setChoices(Collections.EMPTY_LIST);
                        break;
                    }
                }
            }
            catch (NullPointerException npe) {
                filterNameChooser.setChoices(Collections.EMPTY_LIST);
            }
        }
    }
}

