/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxDecoratedCheckbox;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.MultiValueSelectorPanel;

public class VirtualAttributesPanel
extends Panel {
    private static final long serialVersionUID = -7982691107029848579L;
    @SpringBean
    private SchemaRestClient schemaRestClient;

    public <T extends AbstractAttributableTO> VirtualAttributesPanel(String id, final T entityTO, boolean templateMode) {
        super(id);
        this.setOutputMarkupId(true);
        LoadableDetachableModel<List<String>> virtualSchemaNames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                if (entityTO instanceof RoleTO) {
                    return VirtualAttributesPanel.this.schemaRestClient.getVirtualSchemaNames("role");
                }
                if (entityTO instanceof UserTO) {
                    return VirtualAttributesPanel.this.schemaRestClient.getVirtualSchemaNames("user");
                }
                return VirtualAttributesPanel.this.schemaRestClient.getVirtualSchemaNames("membership");
            }
        };
        final WebMarkupContainer attributesContainer = new WebMarkupContainer("virAttrContainer");
        attributesContainer.setOutputMarkupId(true);
        this.add(new Component[]{attributesContainer});
        IndicatingAjaxButton addAttributeBtn = new IndicatingAjaxButton("addAttributeBtn", (IModel)new ResourceModel("addAttributeBtn")){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                entityTO.addVirtualAttribute(new AttributeTO());
                target.add(new Component[]{attributesContainer});
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{attributesContainer});
            }
        };
        this.add(new Component[]{addAttributeBtn.setDefaultFormProcessing(Boolean.FALSE.booleanValue())});
        ListView<AttributeTO> attributes = new ListView<AttributeTO>("attributes", (IModel)new PropertyModel(entityTO, "virtualAttributes"), (IModel)virtualSchemaNames, templateMode){
            private static final long serialVersionUID = 9101744072914090143L;
            final /* synthetic */ IModel val$virtualSchemaNames;
            final /* synthetic */ boolean val$templateMode;
            {
                this.val$virtualSchemaNames = iModel;
                this.val$templateMode = bl;
                super(x0, x1);
            }

            protected void populateItem(ListItem<AttributeTO> item) {
                final AttributeTO attributeTO = (AttributeTO)item.getModelObject();
                item.add(new Component[]{new AjaxDecoratedCheckbox("toRemove", (IModel)new Model((Serializable)Boolean.FALSE)){
                    private static final long serialVersionUID = 7170946748485726506L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        entityTO.removeVirtualAttribute(attributeTO);
                        target.add(new Component[]{attributesContainer});
                    }

                    @Override
                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = -7927968187160354605L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "} " + "else {this.checked = false;}";
                            }
                        };
                    }
                }});
                final DropDownChoice schemaChoice = new DropDownChoice("schema", (IModel)new PropertyModel((Object)attributeTO, "schema"), this.val$virtualSchemaNames, (IChoiceRenderer)new ChoiceRenderer<String>(){
                    private static final long serialVersionUID = 3109256773218160485L;

                    public Object getDisplayValue(String object) {
                        return val$templateMode ? object + " (JEXL)" : object;
                    }
                });
                schemaChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget art) {
                        attributeTO.setSchema((String)schemaChoice.getModelObject());
                    }
                }});
                schemaChoice.setOutputMarkupId(true);
                schemaChoice.setRequired(true);
                item.add(new Component[]{schemaChoice});
                if (attributeTO.getValues().isEmpty()) {
                    attributeTO.addValue("");
                }
                if (this.val$templateMode) {
                    item.add(new Component[]{new AjaxTextFieldPanel("values", "values", (IModel<String>)new Model(), true)});
                } else {
                    item.add(new Component[]{new MultiValueSelectorPanel("values", new PropertyModel((Object)attributeTO, "values"), String.class, new AjaxTextFieldPanel("panel", "values", (IModel<String>)new Model(null), true))});
                }
            }
        };
        attributesContainer.add(new Component[]{attributes});
    }
}

