/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.yui.calendar.DateTimeField;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.springframework.util.StringUtils;
import org.syncope.console.wicket.markup.html.form.AbstractFieldPanel;
import org.syncope.console.wicket.markup.html.form.FieldPanel;

public class DateTimeFieldPanel
extends FieldPanel<Date> {
    private static final long serialVersionUID = -428975732068281726L;
    private final String datePattern;
    private Form form = null;

    public DateTimeFieldPanel(String id, String name, IModel<Date> model, boolean active, String datePattern) {
        super(id, name, model, active);
        this.datePattern = datePattern;
        this.field = new DateTimeField("field", model);
        final Calendar cal = Calendar.getInstance();
        this.field.get("hours").add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget art) {
                if (((DateTimeField)DateTimeFieldPanel.this.field).getHours() > 12) {
                    cal.set(11, ((DateTimeField)DateTimeFieldPanel.this.field).getHours());
                } else {
                    cal.set(10, ((DateTimeField)DateTimeFieldPanel.this.field).getHours());
                }
                DateTimeFieldPanel.this.field.setModelObject((Object)cal.getTime());
            }
        }});
        this.field.get("minutes").add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                cal.set(12, ((DateTimeField)DateTimeFieldPanel.this.field).getMinutes());
                DateTimeFieldPanel.this.field.setModelObject((Object)cal.getTime());
            }
        }});
        this.field.get("date").add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                cal.setTime(((DateTimeField)DateTimeFieldPanel.this.field).getDate());
                if ("PM".equals("" + ((DateTimeField)DateTimeFieldPanel.this.field).getAmOrPm())) {
                    cal.set(9, 1);
                } else {
                    cal.set(9, 0);
                }
                DateTimeFieldPanel.this.field.setModelObject((Object)cal.getTime());
            }
        }});
        this.field.get("amOrPmChoice").add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if ("PM".equals("" + ((DateTimeField)DateTimeFieldPanel.this.field).getAmOrPm())) {
                    cal.set(9, 1);
                } else {
                    cal.set(9, 0);
                }
                DateTimeFieldPanel.this.field.setModelObject((Object)cal.getTime());
            }
        }});
        this.add(new Component[]{this.field.setLabel((IModel)new Model((Serializable)((Object)name))).setOutputMarkupId(true)});
    }

    public FieldPanel setFormValidator(Form form) {
        if (this.field == null) {
            LOG.error("Error setting form validator");
        } else {
            form.add((IFormValidator)new DateTimeFormValidator((DateTimeField)this.field));
            this.form = form;
        }
        return this;
    }

    @Override
    public FieldPanel setNewModel(final ListItem item, final Class reference) {
        final SimpleDateFormat formatter = new SimpleDateFormat(this.datePattern);
        Model model = new Model(){
            private static final long serialVersionUID = 6799404673615637845L;

            public Serializable getObject() {
                Date date = null;
                if (StringUtils.hasText((String)((String)item.getModelObject()))) {
                    if (reference.equals(String.class)) {
                        try {
                            date = formatter.parse((String)item.getModelObject());
                        }
                        catch (ParseException e) {
                            AbstractFieldPanel.LOG.error("While parsing date", (Throwable)e);
                        }
                    } else {
                        date = reference.equals(Date.class) ? (Date)item.getModelObject() : new Date((Long)item.getModelObject());
                    }
                }
                return date;
            }

            public void setObject(Serializable object) {
                if (object != null) {
                    if (reference.equals(String.class)) {
                        item.setModelObject((Object)formatter.format((Date)object));
                    } else if (reference.equals(Date.class)) {
                        item.setModelObject((Object)((Date)object));
                    } else {
                        item.setModelObject((Object)((Date)object).getTime());
                    }
                } else {
                    item.setModelObject(null);
                }
            }
        };
        this.field.setModel((IModel)model);
        return this;
    }

    @Override
    public FieldPanel setNewModel(final List<Serializable> list) {
        this.setNewModel(new Model(){
            private static final long serialVersionUID = 527651414610325237L;
            private final DateFormat formatter;
            {
                this.formatter = new SimpleDateFormat(DateTimeFieldPanel.this.datePattern);
            }

            public Serializable getObject() {
                Date date = null;
                if (list != null && !list.isEmpty() && StringUtils.hasText((String)((Serializable)list.get(0)).toString())) {
                    try {
                        date = this.formatter.parse(((Serializable)list.get(0)).toString());
                    }
                    catch (ParseException e) {
                        AbstractFieldPanel.LOG.error("invalid parse exception", (Throwable)e);
                    }
                }
                return date;
            }

            public void setObject(Serializable object) {
                if (object != null) {
                    list.clear();
                    list.add(this.formatter.format((Date)object));
                }
            }
        });
        return this;
    }

    @Override
    public FieldPanel setStyleShet(String classes) {
        this.field.get("date").add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)((classes != null ? classes : "") + " date_size")))});
        this.field.get("hours").add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(classes != null ? classes : "")))});
        this.field.get("minutes").add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(classes != null ? classes : "")))});
        this.field.get("amOrPmChoice").add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(classes != null ? classes : "")))});
        return this;
    }

    @Override
    public FieldPanel clone() {
        DateTimeFieldPanel panel = new DateTimeFieldPanel(this.id, this.name, (IModel<Date>)new Model(null), this.active, this.datePattern);
        panel.setRequired(this.isRequired());
        panel.setReadOnly(this.isReadOnly());
        panel.setTitle(this.title);
        if (this.isRequiredLabelAdded) {
            panel.addRequiredLabel();
        }
        if (this.form != null && this.isRequired()) {
            panel.setFormValidator(this.form);
        }
        return panel;
    }

    private class DateTimeFormValidator
    extends AbstractFormValidator {
        private static final long serialVersionUID = 6842264694946633582L;
        private FormComponent[] dateTimeComponents;

        public DateTimeFormValidator(DateTimeField dateTimeComponent) {
            if (dateTimeComponent == null) {
                throw new IllegalArgumentException("argument dateTimeComponent cannot be null");
            }
            this.dateTimeComponents = new FormComponent[]{dateTimeComponent};
        }

        public FormComponent[] getDependentFormComponents() {
            return this.dateTimeComponents;
        }

        public void validate(Form form) {
            DateTimeField dateTimeField = (DateTimeField)this.dateTimeComponents[0];
            if (dateTimeField.getDate() == null || dateTimeField.getHours() == null || dateTimeField.getMinutes() == null) {
                ValidationError ve = new ValidationError();
                ve.setVariables(this.variablesMap());
                ve.addMessageKey(this.resourceKey());
                this.dateTimeComponents[0].error((IValidationError)ve);
            }
        }
    }
}

