/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.wicket.markup.html.tree;

import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.tree.BaseTree;
import org.apache.wicket.markup.html.tree.LinkTree;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.RoleTO;
import org.syncope.console.commons.RoleTreeBuilder;
import org.syncope.console.pages.panels.RoleSummaryPanel;

public class TreeRolePanel
extends Panel {
    private static final long serialVersionUID = 1762003213871836869L;
    @SpringBean
    private RoleTreeBuilder roleTreeBuilder;
    final WebMarkupContainer treeContainer = new WebMarkupContainer("treeContainer");
    private BaseTree tree;

    public TreeRolePanel(String id) {
        super(id);
        this.treeContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.treeContainer});
        this.updateTree();
        this.treeContainer.add(new Component[]{this.tree});
    }

    private void updateTree() {
        this.tree = new LinkTree("treeTable", this.roleTreeBuilder.build()){
            private static final long serialVersionUID = -5514696922119256101L;

            protected IModel getNodeTextModel(IModel model) {
                return new PropertyModel((Object)model, "userObject.displayName");
            }

            protected void onNodeLinkClicked(Object node, BaseTree baseTree, AjaxRequestTarget target) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                RoleTO unitObject = (RoleTO)treeNode.getUserObject();
                this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new RoleSummaryPanel.TreeNodeClickUpdate(target, unitObject.getId()));
            }
        };
        this.tree.setOutputMarkupId(true);
        this.tree.getTreeState().expandAll();
        this.treeContainer.addOrReplace(new Component[]{this.tree});
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof RoleSummaryPanel.TreeNodeClickUpdate) {
            RoleSummaryPanel.TreeNodeClickUpdate update = (RoleSummaryPanel.TreeNodeClickUpdate)event.getPayload();
            this.updateTree();
            update.getTarget().add(new Component[]{this.treeContainer});
        }
    }
}

