/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.RoleAuthorizationStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.ContextRelativeResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.syncope.console.SyncopeRequestCycleListener;
import org.syncope.console.SyncopeSession;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.Configuration;
import org.syncope.console.pages.Login;
import org.syncope.console.pages.Logout;
import org.syncope.console.pages.Reports;
import org.syncope.console.pages.Resources;
import org.syncope.console.pages.Roles;
import org.syncope.console.pages.Schema;
import org.syncope.console.pages.Tasks;
import org.syncope.console.pages.Todo;
import org.syncope.console.pages.Users;
import org.syncope.console.pages.WelcomePage;

public class SyncopeApplication
extends WebApplication
implements IUnauthorizedComponentInstantiationListener,
IRoleCheckingStrategy {
    public static final String IMG_PREFIX = "/img/menu/";
    public static final String IMG_NOTSEL = "notsel/";
    public static final String IMG_SUFFIX = ".png";

    protected void init() {
        this.getComponentInstantiationListeners().add((Object)new SpringComponentInjector((WebApplication)this));
        this.getResourceSettings().setThrowExceptionOnMissingResource(true);
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new RoleAuthorizationStrategy((IRoleCheckingStrategy)this));
        this.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)this);
        this.getMarkupSettings().setStripWicketTags(true);
        this.getRequestCycleListeners().add((Object)new SyncopeRequestCycleListener());
    }

    public void setupNavigationPane(WebPage page, XMLRolesReader xmlRolesReader, boolean notsel, String version) {
        page.add(new Component[]{new Label("version", "Console: " + version + "; Core: " + SyncopeSession.get().getCoreVersion())});
        BookmarkablePageLink schemaLink = new BookmarkablePageLink("schema", Schema.class);
        MetaDataRoleAuthorizationStrategy.authorizeAll((Component)schemaLink, (Action)WebPage.ENABLE);
        page.add(new Component[]{schemaLink});
        schemaLink.add(new Component[]{new Image("schemaIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "schema" + IMG_SUFFIX))});
        BookmarkablePageLink usersLink = new BookmarkablePageLink("users", Users.class);
        String allowedUsersRoles = xmlRolesReader.getAllAllowedRoles("Users", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)usersLink, (Action)WebPage.ENABLE, (String)allowedUsersRoles);
        page.add(new Component[]{usersLink});
        usersLink.add(new Component[]{new Image("usersIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "users" + IMG_SUFFIX))});
        BookmarkablePageLink rolesLink = new BookmarkablePageLink("roles", Roles.class);
        MetaDataRoleAuthorizationStrategy.authorizeAll((Component)rolesLink, (Action)WebPage.ENABLE);
        page.add(new Component[]{rolesLink});
        rolesLink.add(new Component[]{new Image("rolesIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "roles" + IMG_SUFFIX))});
        BookmarkablePageLink resourcesLink = new BookmarkablePageLink("resources", Resources.class);
        MetaDataRoleAuthorizationStrategy.authorizeAll((Component)resourcesLink, (Action)WebPage.ENABLE);
        page.add(new Component[]{resourcesLink});
        resourcesLink.add(new Component[]{new Image("resourcesIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "resources" + IMG_SUFFIX))});
        BookmarkablePageLink todoLink = new BookmarkablePageLink("todo", Todo.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)todoLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getAllAllowedRoles("Approval", "list"));
        page.add(new Component[]{todoLink});
        todoLink.add(new Component[]{new Image("todoIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "todo" + IMG_SUFFIX))});
        BookmarkablePageLink reportLink = new BookmarkablePageLink("reports", Reports.class);
        String allowedReportRoles = xmlRolesReader.getAllAllowedRoles("Reports", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)reportLink, (Action)WebPage.ENABLE, (String)allowedReportRoles);
        page.add(new Component[]{reportLink});
        reportLink.add(new Component[]{new Image("reportsIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "reports" + IMG_SUFFIX))});
        BookmarkablePageLink configurationLink = new BookmarkablePageLink("configuration", Configuration.class);
        String allowedConfigurationRoles = xmlRolesReader.getAllAllowedRoles("Configuration", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)configurationLink, (Action)WebPage.ENABLE, (String)allowedConfigurationRoles);
        page.add(new Component[]{configurationLink});
        configurationLink.add(new Component[]{new Image("configurationIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "configuration" + IMG_SUFFIX))});
        BookmarkablePageLink taskLink = new BookmarkablePageLink("tasks", Tasks.class);
        String allowedTasksRoles = xmlRolesReader.getAllAllowedRoles("Tasks", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)taskLink, (Action)WebPage.ENABLE, (String)allowedTasksRoles);
        page.add(new Component[]{taskLink});
        taskLink.add(new Component[]{new Image("tasksIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "tasks" + IMG_SUFFIX))});
        page.add(new Component[]{new BookmarkablePageLink("logout", Logout.class)});
    }

    public Session newSession(Request request, Response response) {
        return new SyncopeSession(request);
    }

    public Class getHomePage() {
        return SyncopeSession.get().isAuthenticated() ? WelcomePage.class : Login.class;
    }

    public void onUnauthorizedInstantiation(Component component) {
        SyncopeSession.get().invalidate();
        if (component instanceof Page) {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
        throw new RestartResponseAtInterceptPageException(Login.class);
    }

    public boolean hasAnyRole(org.apache.wicket.authroles.authorization.strategies.role.Roles roles) {
        return SyncopeSession.get().hasAnyRole(roles);
    }
}

