/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.commons;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.crypt.Base64;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class PreferenceManager {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceManager.class);
    private static final int ONE_YEAR_TIME = 31536000;
    private static final TypeReference MAP_TYPE_REF = new /* Unavailable Anonymous Inner Class!! */;
    private static final List<Integer> PAGINATOR_CHOICES = Arrays.asList(10, 25, 50);
    @Autowired
    private ObjectMapper mapper;

    public List<Integer> getPaginatorChoices() {
        return PAGINATOR_CHOICES;
    }

    private Map<String, String> getPrefs(String value) {
        HashMap<String, String> prefs;
        try {
            if (!StringUtils.hasText((String)value)) {
                throw new Exception("Invalid cookie value '" + value + "'");
            }
            prefs = (HashMap<String, String>)this.mapper.readValue(value, MAP_TYPE_REF);
        }
        catch (Exception e) {
            LOG.debug("No preferences found", (Throwable)e);
            prefs = new HashMap<String, String>();
        }
        return prefs;
    }

    private String setPrefs(Map<String, String> prefs) throws IOException {
        StringWriter writer = new StringWriter();
        this.mapper.writeValue((Writer)writer, prefs);
        return writer.toString();
    }

    public String get(Request request, String key) {
        String result = null;
        Cookie prefCookie = ((WebRequest)request).getCookie("syncopeConsolePrefs");
        if (prefCookie != null) {
            Map prefs = this.getPrefs(new String(Base64.decodeBase64((byte[])prefCookie.getValue().getBytes())));
            result = (String)prefs.get(key);
        } else {
            LOG.debug("Could not find cookie []", (Object)"syncopeConsolePrefs");
        }
        return result;
    }

    public Integer getPaginatorRows(Request request, String key) {
        Integer result = (Integer)this.getPaginatorChoices().get(0);
        String value = this.get(request, key);
        if (value != null) {
            try {
                result = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                LOG.error("Unparsable value " + value, (Throwable)e);
            }
        }
        return result;
    }

    public List<String> getList(Request request, String key) {
        ArrayList<String> result = new ArrayList<String>();
        String compound = this.get(request, key);
        if (StringUtils.hasText((String)compound)) {
            String[] items = compound.split(";");
            result.addAll(Arrays.asList(items));
        }
        return result;
    }

    public void set(Request request, Response response, Map<String, List<String>> prefs) {
        Cookie prefCookie = ((WebRequest)request).getCookie("syncopeConsolePrefs");
        HashMap<String, String> current = new HashMap<String, String>();
        if (prefCookie == null || !StringUtils.hasText((String)prefCookie.getValue())) {
            prefCookie = new Cookie("syncopeConsolePrefs", null);
        } else {
            current.putAll(this.getPrefs(new String(Base64.decodeBase64((byte[])prefCookie.getValue().getBytes()))));
        }
        for (Map.Entry<String, List<String>> entry : prefs.entrySet()) {
            current.put(entry.getKey(), StringUtils.collectionToDelimitedString((Collection)entry.getValue(), (String)";"));
        }
        try {
            prefCookie.setValue(new String(Base64.encodeBase64((byte[])this.setPrefs(current).getBytes())));
        }
        catch (IOException e) {
            LOG.error("Could not set preferences " + current, (Throwable)e);
        }
        prefCookie.setMaxAge(31536000);
        ((WebResponse)response).addCookie(prefCookie);
    }

    public void set(Request request, Response response, String key, String value) {
        Cookie prefCookie = ((WebRequest)request).getCookie("syncopeConsolePrefs");
        HashMap<String, String> prefs = new HashMap<String, String>();
        if (prefCookie == null || !StringUtils.hasText((String)prefCookie.getValue())) {
            prefCookie = new Cookie("syncopeConsolePrefs", null);
        } else {
            prefs.putAll(this.getPrefs(new String(Base64.decodeBase64((byte[])prefCookie.getValue().getBytes()))));
        }
        prefs.put(key, value);
        try {
            prefCookie.setValue(new String(Base64.encodeBase64((byte[])this.setPrefs(prefs).getBytes())));
        }
        catch (IOException e) {
            LOG.error("Could not set preferences " + prefs, (Throwable)e);
        }
        prefCookie.setMaxAge(31536000);
        ((WebResponse)response).addCookie(prefCookie);
    }

    public void setList(Request request, Response response, String key, List<String> values) {
        this.set(request, response, key, StringUtils.collectionToDelimitedString(values, (String)";"));
    }

    public void setList(Request request, Response response, Map<String, List<String>> prefs) {
        this.set(request, response, prefs);
    }
}

