/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.CommonsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.Login;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public class Login
extends WebPage {
    private static final Logger LOG = LoggerFactory.getLogger(Login.class);
    private static final long serialVersionUID = -3744389270366566218L;
    private static final int SELF_REG_WIN_HEIGHT = 550;
    private static final int SELF_REG_WIN_WIDTH = 800;
    @SpringBean
    private RestTemplate restTemplate;
    @SpringBean
    private HttpClient httpClient;
    @SpringBean(name="baseURL")
    private String baseURL;
    private Form form = new Form("login");
    private TextField userIdField = new TextField("userId", (IModel)new Model());
    private TextField passwordField;
    private DropDownChoice<Locale> languageSelect;

    public Login(PageParameters parameters) {
        super(parameters);
        Fragment selfRegFrag;
        this.userIdField.setMarkupId("userId");
        this.form.add(new Component[]{this.userIdField});
        this.passwordField = new PasswordTextField("password", (IModel)new Model());
        this.passwordField.setMarkupId("password");
        this.form.add(new Component[]{this.passwordField});
        this.languageSelect = new LocaleDropDown(this, "language", Arrays.asList(Locale.ENGLISH, Locale.ITALIAN));
        this.form.add(new Component[]{this.languageSelect});
        1 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        submitButton.setDefaultFormProcessing(false);
        this.form.add(new Component[]{submitButton});
        this.add(new Component[]{this.form});
        this.add(new Component[]{new FeedbackPanel("feedback")});
        ModalWindow editProfileModalWin = new ModalWindow("selfRegModal");
        editProfileModalWin.setCssClassName("w_silver");
        editProfileModalWin.setInitialHeight(550);
        editProfileModalWin.setInitialWidth(800);
        editProfileModalWin.setCookieName("self-reg-modal");
        this.add(new Component[]{editProfileModalWin});
        if (((Boolean)this.restTemplate.getForObject(this.baseURL + "user/request/create/allowed", Boolean.class, new Object[0])).booleanValue()) {
            selfRegFrag = new Fragment("selfRegistration", "selfRegAllowed", (MarkupContainer)this);
            2 selfRegLink = new /* Unavailable Anonymous Inner Class!! */;
            selfRegLink.add(new Component[]{new Label("linkTitle", this.getString("selfRegistration"))});
            LinkPanel panel = new LinkPanel("selfRegistration", (IModel)new ResourceModel("selfRegistration"));
            panel.add(new Component[]{selfRegLink});
            selfRegFrag.add(new Component[]{panel});
        } else {
            selfRegFrag = new Fragment("selfRegistration", "selfRegNotAllowed", (MarkupContainer)this);
        }
        this.add(new Component[]{selfRegFrag});
    }

    private String[] authenticate(String userId, String password) {
        ((CommonsClientHttpRequestFactory)this.restTemplate.getRequestFactory()).getHttpClient().getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userId, password));
        String[] entitlements = null;
        try {
            entitlements = (String[])this.restTemplate.getForObject(this.baseURL + "auth/entitlements.json", String[].class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While fetching user's entitlements", (Throwable)e);
            this.getSession().error((Serializable)((Object)e.getMessage()));
        }
        return entitlements;
    }

    private String getCoreVersion() {
        String version = "";
        try {
            GetMethod get = new GetMethod(this.baseURL + "../version.jsp");
            this.httpClient.executeMethod((HttpMethod)get);
            version = get.getResponseBodyAsString().trim();
        }
        catch (IOException e) {
            LOG.error("While fetching core version", (Throwable)e);
            this.getSession().error((Serializable)((Object)e.getMessage()));
        }
        return version;
    }

    static /* synthetic */ TextField access$000(Login x0) {
        return x0.userIdField;
    }

    static /* synthetic */ TextField access$100(Login x0) {
        return x0.passwordField;
    }

    static /* synthetic */ String[] access$200(Login x0, String x1, String x2) {
        return x0.authenticate(x1, x2);
    }

    static /* synthetic */ String access$300(Login x0) {
        return x0.getCoreVersion();
    }
}

