/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.ResourceModalPage;
import org.syncope.console.pages.panels.ResourceSecurityPanel;
import org.syncope.console.rest.ConnectorRestClient;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxNumberFieldPanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.types.ConnConfProperty;
import org.syncope.types.PropagationMode;
import org.syncope.types.TraceLevel;

public class ResourceModalPage
extends BaseModalPage {
    private static final long serialVersionUID = 1734415311027284221L;
    private static final String GUARDED_STRING = "org.identityconnectors.common.security.GuardedString";
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private ConnectorRestClient connectorRestClient;
    @SpringBean
    private ResourceRestClient restClient;
    private List<String> uSchemaAttrNames;
    private List<String> uDerSchemaAttrNames;
    private List<String> uVirSchemaAttrNames;
    private WebMarkupContainer mappingContainer;
    private WebMarkupContainer connectorPropertiesContainer;
    private Set<ConnConfProperty> overridableConnectorProperties;
    private List<String> resourceSchemaNames;

    public ResourceModalPage(PageReference callPageRef, ModalWindow window, ResourceTO resourceTO, boolean createFlag) {
        this.uSchemaAttrNames = this.schemaRestClient.getSchemaNames("user");
        this.uDerSchemaAttrNames = this.schemaRestClient.getDerivedSchemaNames("user");
        this.uVirSchemaAttrNames = this.schemaRestClient.getVirtualSchemaNames("user");
        1 connectors = new /* Unavailable Anonymous Inner Class!! */;
        2 intMappingTypes = new /* Unavailable Anonymous Inner Class!! */;
        3 connectorPropertiesModel = new /* Unavailable Anonymous Inner Class!! */;
        this.updateResourceSchemaNames(resourceTO);
        this.updateConnectorProperties(resourceTO.getConnectorId());
        ConnInstanceTO connectorTO = new ConnInstanceTO();
        if (!createFlag) {
            connectorTO.setId(resourceTO.getConnectorId());
        }
        Form form = new Form("form");
        form.setModel((IModel)new CompoundPropertyModel((Object)resourceTO));
        AjaxTextFieldPanel resourceName = new AjaxTextFieldPanel("name", this.getString("name"), (IModel)new PropertyModel((Object)resourceTO, "name"), false);
        resourceName.setEnabled(createFlag);
        resourceName.addRequiredLabel();
        form.add(new Component[]{resourceName});
        AjaxTextFieldPanel accountLink = new AjaxTextFieldPanel("accountLink", this.getString("accountLink"), (IModel)new PropertyModel((Object)resourceTO, "accountLink"), false);
        form.add(new Component[]{accountLink});
        AjaxCheckBoxPanel forceMandatoryConstraint = new AjaxCheckBoxPanel("forceMandatoryConstraint", this.getString("forceMandatoryConstraint"), (IModel)new PropertyModel((Object)resourceTO, "forceMandatoryConstraint"), false);
        form.add(new Component[]{forceMandatoryConstraint});
        AjaxCheckBoxPanel propagationPrimary = new AjaxCheckBoxPanel("propagationPrimary", this.getString("propagationPrimary"), (IModel)new PropertyModel((Object)resourceTO, "propagationPrimary"), false);
        form.add(new Component[]{propagationPrimary});
        AjaxNumberFieldPanel propagationPriority = new AjaxNumberFieldPanel("propagationPriority", this.getString("propagationPriority"), (IModel)new PropertyModel((Object)resourceTO, "propagationPriority"), Integer.class, false);
        form.add(new Component[]{propagationPriority});
        AjaxDropDownChoicePanel propagationMode = new AjaxDropDownChoicePanel("propagationMode", this.getString("propagationMode"), (IModel)new PropertyModel((Object)resourceTO, "propagationMode"), false);
        propagationMode.setChoices(Arrays.asList(PropagationMode.values()));
        form.add(new Component[]{propagationMode});
        AjaxDropDownChoicePanel createTraceLevel = new AjaxDropDownChoicePanel("createTraceLevel", this.getString("createTraceLevel"), (IModel)new PropertyModel((Object)resourceTO, "createTraceLevel"), false);
        createTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        form.add(new Component[]{createTraceLevel});
        AjaxDropDownChoicePanel updateTraceLevel = new AjaxDropDownChoicePanel("updateTraceLevel", this.getString("updateTraceLevel"), (IModel)new PropertyModel((Object)resourceTO, "updateTraceLevel"), false);
        updateTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        form.add(new Component[]{updateTraceLevel});
        AjaxDropDownChoicePanel deleteTraceLevel = new AjaxDropDownChoicePanel("deleteTraceLevel", this.getString("deleteTraceLevel"), (IModel)new PropertyModel((Object)resourceTO, "deleteTraceLevel"), false);
        deleteTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        form.add(new Component[]{deleteTraceLevel});
        AjaxDropDownChoicePanel syncTraceLevel = new AjaxDropDownChoicePanel("syncTraceLevel", this.getString("syncTraceLevel"), (IModel)new PropertyModel((Object)resourceTO, "syncTraceLevel"), false);
        syncTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        form.add(new Component[]{syncTraceLevel});
        AjaxCheckBoxPanel resetToken = new AjaxCheckBoxPanel("resetToken", this.getString("resetToken"), (IModel)new Model(null), false);
        resetToken.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{resetToken});
        this.mappingContainer = new WebMarkupContainer("mappingContainer");
        this.mappingContainer.setOutputMarkupId(true);
        form.add(new Component[]{this.mappingContainer});
        this.connectorPropertiesContainer = new WebMarkupContainer("connectorPropertiesContainer");
        this.connectorPropertiesContainer.setOutputMarkupId(true);
        form.add(new Component[]{this.connectorPropertiesContainer});
        AjaxDropDownChoicePanel connector = new AjaxDropDownChoicePanel("connector", this.getString("connector"), (IModel)new Model((Serializable)connectorTO), false);
        connector.setChoices((List)connectors.getObject());
        connector.setChoiceRenderer((IChoiceRenderer)new ChoiceRenderer("displayName", "id"));
        connector.getField().setModel((IModel)new /* Unavailable Anonymous Inner Class!! */);
        connector.addRequiredLabel();
        connector.setEnabled(createFlag);
        form.add(new Component[]{connector});
        6 mappings = new /* Unavailable Anonymous Inner Class!! */;
        mappings.setReuseItems(true);
        this.mappingContainer.add(new Component[]{mappings});
        7 addSchemaMappingBtn = new /* Unavailable Anonymous Inner Class!! */;
        addSchemaMappingBtn.setDefaultFormProcessing(false);
        addSchemaMappingBtn.setEnabled(!createFlag);
        this.mappingContainer.add(new Component[]{addSchemaMappingBtn});
        this.connectorPropertiesContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        connector.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{new ResourceSecurityPanel("security", resourceTO)});
        10 submit = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{submit});
        this.add(new Component[]{form});
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Resources", createFlag ? "create" : "update"));
    }

    public final void updateResourceSchemaNames(ResourceTO resourceTO) {
        try {
            this.resourceSchemaNames = resourceTO != null && resourceTO.getConnectorId() != null ? this.connectorRestClient.getSchemaNames(resourceTO) : Collections.EMPTY_LIST;
        }
        catch (Exception e) {
            LOG.warn("Error retrieving resource schema names", (Throwable)e);
            this.resourceSchemaNames = Collections.EMPTY_LIST;
        }
    }

    public final void updateConnectorProperties(Long connectorId) {
        if (connectorId != null && connectorId > 0L) {
            HashSet<ConnConfProperty> overridableProperties = new HashSet<ConnConfProperty>();
            for (ConnConfProperty p : this.connectorRestClient.getConnectorProperties(connectorId)) {
                if (!p.isOverridable()) continue;
                overridableProperties.add(p);
            }
            this.overridableConnectorProperties = overridableProperties;
        } else {
            this.overridableConnectorProperties = Collections.emptySet();
        }
    }

    static /* synthetic */ ConnectorRestClient access$000(ResourceModalPage x0) {
        return x0.connectorRestClient;
    }

    static /* synthetic */ Set access$100(ResourceModalPage x0) {
        return x0.overridableConnectorProperties;
    }

    static /* synthetic */ WebMarkupContainer access$200(ResourceModalPage x0) {
        return x0.mappingContainer;
    }

    static /* synthetic */ List access$300(ResourceModalPage x0) {
        return x0.resourceSchemaNames;
    }

    static /* synthetic */ List access$400(ResourceModalPage x0) {
        return x0.uSchemaAttrNames;
    }

    static /* synthetic */ List access$500(ResourceModalPage x0) {
        return x0.uDerSchemaAttrNames;
    }

    static /* synthetic */ List access$600(ResourceModalPage x0) {
        return x0.uVirSchemaAttrNames;
    }

    static /* synthetic */ WebMarkupContainer access$700(ResourceModalPage x0) {
        return x0.connectorPropertiesContainer;
    }

    static /* synthetic */ ResourceRestClient access$800(ResourceModalPage x0) {
        return x0.restClient;
    }
}

