/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Resources;
import org.syncope.console.rest.ConnectorRestClient;
import org.syncope.console.rest.ResourceRestClient;

public class Resources
extends BasePage {
    private static final long serialVersionUID = -3789252860990261728L;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    @SpringBean
    private ConnectorRestClient connectorRestClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final ModalWindow createResourceWin;
    private final ModalWindow editResourceWin;
    private final ModalWindow createConnectorWin;
    private final ModalWindow editConnectorWin;
    private static final int WIN_HEIGHT = 500;
    private static final int WIN_WIDTH = 900;
    private WebMarkupContainer resourceContainer;
    private WebMarkupContainer connectorContainer;
    private int resourcePaginatorRows;
    private int connectorPaginatorRows;

    public Resources(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createResourceWin = new ModalWindow("createResourceWin");
        componentArray[0] = this.createResourceWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editResourceWin = new ModalWindow("editResourceWin");
        componentArray2[0] = this.editResourceWin;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.createConnectorWin = new ModalWindow("createConnectorWin");
        componentArray3[0] = this.createConnectorWin;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.editConnectorWin = new ModalWindow("editConnectorWin");
        componentArray4[0] = this.editConnectorWin;
        this.add(componentArray4);
        this.add(new Component[]{this.feedbackPanel});
        this.resourcePaginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "resources.paginator.rows");
        this.connectorPaginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "connectors.paginator.rows");
        this.setupResources();
        this.setupConnectors();
    }

    private final void setupResources() {
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("name"), "name", "name"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("propagationPrimary"), "propagationPrimary", "propagationPrimary"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("propagationPriority"), "propagationPriority", "propagationPriority"));
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("resourceDatatable", columns, (ISortableDataProvider)new ResourcesProvider(this), this.resourcePaginatorRows);
        this.resourceContainer = new WebMarkupContainer("resourceContainer");
        this.resourceContainer.add(new Component[]{table});
        this.resourceContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.resourceContainer});
        this.setWindowClosedCallback(this.createResourceWin, this.resourceContainer);
        this.setWindowClosedCallback(this.editResourceWin, this.resourceContainer);
        this.createResourceWin.setCssClassName("w_silver");
        this.createResourceWin.setInitialHeight(500);
        this.createResourceWin.setInitialWidth(900);
        this.createResourceWin.setCookieName("create-res-modal");
        this.editResourceWin.setCssClassName("w_silver");
        this.editResourceWin.setInitialHeight(500);
        this.editResourceWin.setInitialWidth(900);
        this.editResourceWin.setCookieName("edit-res-modal");
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        Form paginatorForm = new Form("resourcePaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "resourcePaginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    private void setupConnectors() {
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), "id", "id"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("name"), "connectorName", "connectorName"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("displayName"), "displayName", "displayName"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("version"), "version", "version"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("bundleName"), "bundleName", "bundleName"));
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("connectorDatatable", columns, (ISortableDataProvider)new ConnectorsProvider(this), this.connectorPaginatorRows);
        this.connectorContainer = new WebMarkupContainer("connectorContainer");
        this.connectorContainer.add(new Component[]{table});
        this.connectorContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.connectorContainer});
        this.setWindowClosedCallback(this.createConnectorWin, this.connectorContainer);
        this.setWindowClosedCallback(this.editConnectorWin, this.connectorContainer);
        this.createConnectorWin.setCssClassName("w_silver");
        this.createConnectorWin.setInitialHeight(500);
        this.createConnectorWin.setInitialWidth(900);
        this.createConnectorWin.setCookieName("create-conn-modal");
        this.editConnectorWin.setCssClassName("w_silver");
        this.editConnectorWin.setInitialHeight(500);
        this.editConnectorWin.setInitialWidth(900);
        this.editConnectorWin.setCookieName("edit-conn-modal");
        7 createConnectorLink = new /* Unavailable Anonymous Inner Class!! */;
        String allowedRoles = this.xmlRolesReader.getAllAllowedRoles("Connectors", "create");
        MetaDataRoleAuthorizationStrategy.authorize((Component)createConnectorLink, (Action)ENABLE, (String)allowedRoles);
        this.add(new Component[]{createConnectorLink});
        Form paginatorForm = new Form("connectorPaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "connectorPaginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    public boolean checkDeleteIsForbidden(ConnInstanceTO connectorTO) {
        boolean forbidden = false;
        for (ResourceTO resourceTO : this.resourceRestClient.getAllResources()) {
            if (!resourceTO.getConnectorId().equals(connectorTO.getId())) continue;
            forbidden = true;
        }
        return forbidden;
    }

    static /* synthetic */ ModalWindow access$000(Resources x0) {
        return x0.editResourceWin;
    }

    static /* synthetic */ ResourceRestClient access$100(Resources x0) {
        return x0.resourceRestClient;
    }

    static /* synthetic */ WebMarkupContainer access$200(Resources x0) {
        return x0.resourceContainer;
    }

    static /* synthetic */ ModalWindow access$300(Resources x0) {
        return x0.createResourceWin;
    }

    static /* synthetic */ int access$400(Resources x0) {
        return x0.resourcePaginatorRows;
    }

    static /* synthetic */ PreferenceManager access$500(Resources x0) {
        return x0.prefMan;
    }

    static /* synthetic */ ModalWindow access$600(Resources x0) {
        return x0.editConnectorWin;
    }

    static /* synthetic */ ConnectorRestClient access$700(Resources x0) {
        return x0.connectorRestClient;
    }

    static /* synthetic */ WebMarkupContainer access$800(Resources x0) {
        return x0.connectorContainer;
    }

    static /* synthetic */ ModalWindow access$900(Resources x0) {
        return x0.createConnectorWin;
    }

    static /* synthetic */ int access$1000(Resources x0) {
        return x0.connectorPaginatorRows;
    }
}

