/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.UserMod;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.SyncTaskTO;
import org.syncope.client.to.UserRequestTO;
import org.syncope.client.to.UserTO;
import org.syncope.client.util.AttributableOperations;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.pages.panels.AttributesPanel;
import org.syncope.console.pages.panels.DerivedAttributesPanel;
import org.syncope.console.pages.panels.ResourcesPanel;
import org.syncope.console.pages.panels.RolesPanel;
import org.syncope.console.pages.panels.UserDetailsPanel;
import org.syncope.console.pages.panels.UserModalPageResult;
import org.syncope.console.pages.panels.VirtualAttributesPanel;
import org.syncope.console.rest.TaskRestClient;
import org.syncope.console.rest.UserRequestRestClient;
import org.syncope.console.rest.UserRestClient;

public class UserModalPage
extends BaseModalPage {
    private static final long serialVersionUID = 5002005009737457667L;
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private UserRequestRestClient requestRestClient;
    @SpringBean
    private TaskRestClient taskRestClient;
    private final PageReference callerPageRef;
    private final ModalWindow window;
    private UserRequestTO userRequestTO;
    private UserTO userTO;
    private SyncTaskTO syncTaskTO;
    private Mode mode = Mode.ADMIN;
    private UserTO initialUserTO;
    private Fragment fragment;
    private boolean submitted = false;

    public UserModalPage(PageReference callerPageRef, ModalWindow window, UserRequestTO userRequestTO) {
        this.callerPageRef = callerPageRef;
        this.window = window;
        this.userRequestTO = userRequestTO;
        this.mode = Mode.ADMIN;
        this.setupModalPage();
    }

    public UserModalPage(PageReference callerPageRef, ModalWindow window, SyncTaskTO syncTaskTO) {
        this.callerPageRef = callerPageRef;
        this.window = window;
        this.syncTaskTO = syncTaskTO;
        this.mode = Mode.TEMPLATE;
        this.setupModalPage();
    }

    public UserModalPage(PageReference callerPageRef, ModalWindow window, UserTO userTO, Mode mode) {
        this(callerPageRef, window, userTO, mode, false);
    }

    public UserModalPage(PageReference callerPageRef, ModalWindow window, UserTO userTO, Mode mode, boolean submitted) {
        this.callerPageRef = callerPageRef;
        this.window = window;
        this.userTO = userTO;
        this.mode = mode == null ? Mode.ADMIN : mode;
        this.submitted = submitted;
        this.setupModalPage();
    }

    public UserTO getUserTO() {
        return this.userTO;
    }

    public void setUserTO(UserTO userTO) {
        this.userTO = userTO;
    }

    private void setupModalPage() {
        this.fragment = new Fragment("userModalFrag", this.submitted ? "userModalResultFrag" : "userModalEditFrag", (MarkupContainer)this);
        this.fragment.setOutputMarkupId(true);
        this.add(new Component[]{this.fragment});
        if (this.submitted) {
            this.setupResultPanel();
        } else {
            this.setupEditPanel();
        }
    }

    private void setupEditPanel() {
        if (this.userRequestTO != null) {
            switch (2.$SwitchMap$org$syncope$types$UserRequestType[this.userRequestTO.getType().ordinal()]) {
                case 1: {
                    this.userTO = this.userRequestTO.getUserTO();
                    break;
                }
                case 2: {
                    this.initialUserTO = this.userRestClient.read(Long.valueOf(this.userRequestTO.getUserMod().getId()));
                    this.userTO = AttributableOperations.apply((UserTO)this.initialUserTO, (UserMod)this.userRequestTO.getUserMod());
                    break;
                }
            }
        }
        if (this.syncTaskTO != null) {
            this.userTO = this.syncTaskTO.getUserTemplate();
            if (this.userTO == null) {
                this.userTO = new UserTO();
                this.syncTaskTO.setUserTemplate(this.userTO);
            }
        }
        if (this.initialUserTO == null && this.userTO.getId() > 0L) {
            this.initialUserTO = (UserTO)AttributableOperations.clone((AbstractAttributableTO)this.userTO);
        }
        this.fragment.add(new Component[]{new Label("id", this.userTO.getId() == 0L ? "" : this.userTO.getUsername())});
        this.fragment.add(new Component[]{new Label("new", this.userTO.getId() == 0L ? this.getString("new") : "")});
        Form form = new Form("UserForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)this.userTO));
        form.add(new Component[]{new UserDetailsPanel("details", this.userTO, form, this.userRequestTO == null, this.mode == Mode.TEMPLATE)});
        form.add(new Component[]{new AttributesPanel("attributes", (AbstractAttributableTO)this.userTO, form, this.mode == Mode.TEMPLATE)});
        form.add(new Component[]{new DerivedAttributesPanel("derivedAttributes", (AbstractAttributableTO)this.userTO)});
        form.add(new Component[]{new VirtualAttributesPanel("virtualAttributes", (AbstractAttributableTO)this.userTO, this.mode == Mode.TEMPLATE)});
        form.add(new Component[]{new ResourcesPanel("resources", (AbstractAttributableTO)this.userTO)});
        form.add(new Component[]{new RolesPanel("roles", this.userTO, this.mode == Mode.TEMPLATE)});
        1 submit = new /* Unavailable Anonymous Inner Class!! */;
        if (this.mode == Mode.ADMIN) {
            String allowedRoles = this.userTO.getId() == 0L ? this.xmlRolesReader.getAllAllowedRoles("Users", "create") : this.xmlRolesReader.getAllAllowedRoles("Users", "update");
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)allowedRoles);
        }
        this.fragment.add(new Component[]{form});
        form.add(new Component[]{submit});
    }

    private void setupResultPanel() {
        UserModalPageResult result = new UserModalPageResult("userModalPageResult", this.window, this.mode, this.userTO);
        result.setOutputMarkupId(true);
        this.fragment.add(new Component[]{result});
    }

    static /* synthetic */ Mode access$000(UserModalPage x0) {
        return x0.mode;
    }

    static /* synthetic */ UserRequestRestClient access$100(UserModalPage x0) {
        return x0.requestRestClient;
    }

    static /* synthetic */ UserTO access$202(UserModalPage x0, UserTO x1) {
        x0.userTO = x1;
        return x0.userTO;
    }

    static /* synthetic */ UserRestClient access$300(UserModalPage x0) {
        return x0.userRestClient;
    }

    static /* synthetic */ UserRequestTO access$400(UserModalPage x0) {
        return x0.userRequestTO;
    }

    static /* synthetic */ SyncTaskTO access$500(UserModalPage x0) {
        return x0.syncTaskTO;
    }

    static /* synthetic */ TaskRestClient access$600(UserModalPage x0) {
        return x0.taskRestClient;
    }

    static /* synthetic */ UserTO access$700(UserModalPage x0) {
        return x0.initialUserTO;
    }

    static /* synthetic */ PageReference access$800(UserModalPage x0) {
        return x0.callerPageRef;
    }

    static /* synthetic */ ModalWindow access$900(UserModalPage x0) {
        return x0.window;
    }

    static /* synthetic */ UserTO access$200(UserModalPage x0) {
        return x0.userTO;
    }
}

