/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.Request;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.to.AccountPolicyTO;
import org.syncope.client.to.PasswordPolicyTO;
import org.syncope.client.to.PolicyTO;
import org.syncope.client.to.SyncPolicyTO;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.panels.PoliciesPanel;
import org.syncope.console.rest.PolicyRestClient;
import org.syncope.types.PolicyType;

public class PoliciesPanel
extends Panel {
    protected static final Logger LOG = LoggerFactory.getLogger(PoliciesPanel.class);
    private static final int MODAL_WIN_HEIGHT = 400;
    private static final int MODAL_WIN_WIDTH = 1000;
    private static final long serialVersionUID = -6804066913177804275L;
    @SpringBean
    private PolicyRestClient policyRestClient;
    @SpringBean
    protected XMLRolesReader xmlRolesReader;
    @SpringBean
    private PreferenceManager prefMan;
    private final int paginatorRows;
    protected boolean modalResult;
    private PolicyType policyType;

    public PoliciesPanel(String id, PolicyType policyType) {
        super(id);
        this.paginatorRows = this.prefMan.getPaginatorRows((Request)this.getWebRequest(), "policy.paginator.rows");
        this.modalResult = false;
        this.policyType = policyType;
        ModalWindow mwindow = new ModalWindow("editModalWin");
        mwindow.setCssClassName("w_silver");
        mwindow.setInitialHeight(400);
        mwindow.setInitialWidth(1000);
        mwindow.setCookieName("policy-modal");
        this.add(new Component[]{mwindow});
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.setWindowClosedCallback(mwindow, container);
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), "id", "id"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("description"), "description", "description"));
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, (ISortableDataProvider)new PolicyDataProvider(this), this.paginatorRows);
        container.add(new Component[]{table});
        4 createButton = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{createButton});
        MetaDataRoleAuthorizationStrategy.authorize((Component)createButton, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Policies", "create"));
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    private void setWindowClosedCallback(ModalWindow window, WebMarkupContainer container) {
        window.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private PolicyTO getPolicyTOInstance(PolicyType policyType) {
        AccountPolicyTO policyTO;
        switch (7.$SwitchMap$org$syncope$types$PolicyType[policyType.ordinal()]) {
            case 1: {
                policyTO = new AccountPolicyTO(true);
                break;
            }
            case 2: {
                policyTO = new AccountPolicyTO();
                break;
            }
            case 3: {
                policyTO = new PasswordPolicyTO(true);
                break;
            }
            case 4: {
                policyTO = new PasswordPolicyTO();
                break;
            }
            case 5: {
                policyTO = new SyncPolicyTO(true);
                break;
            }
            default: {
                policyTO = new SyncPolicyTO();
            }
        }
        return policyTO;
    }

    static /* synthetic */ PolicyRestClient access$000(PoliciesPanel x0) {
        return x0.policyRestClient;
    }

    static /* synthetic */ PolicyTO access$100(PoliciesPanel x0, PolicyType x1) {
        return x0.getPolicyTOInstance(x1);
    }

    static /* synthetic */ int access$200(PoliciesPanel x0) {
        return x0.paginatorRows;
    }

    static /* synthetic */ PreferenceManager access$300(PoliciesPanel x0) {
        return x0.prefMan;
    }

    static /* synthetic */ PolicyType access$400(PoliciesPanel x0) {
        return x0.policyType;
    }
}

