/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.syncope.client.to.NotificationTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.AbstractBaseRestClient;

@Component
public class NotificationRestClient
extends AbstractBaseRestClient {
    public List<NotificationTO> getAllNotifications() throws SyncopeClientCompositeErrorException {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "notification/list.json", NotificationTO[].class, new Object[0]));
    }

    public NotificationTO readNotification(Long id) throws SyncopeClientCompositeErrorException {
        return (NotificationTO)this.restTemplate.getForObject(this.baseURL + "notification/read/{notificationId}.json", NotificationTO.class, new Object[]{id});
    }

    public void createNotification(NotificationTO notificationTO) throws SyncopeClientCompositeErrorException {
        this.restTemplate.postForObject(this.baseURL + "notification/create.json", (Object)notificationTO, NotificationTO.class, new Object[0]);
    }

    public void updateNotification(NotificationTO notificationTO) throws SyncopeClientCompositeErrorException {
        this.restTemplate.postForObject(this.baseURL + "notification/update.json", (Object)notificationTO, NotificationTO.class, new Object[0]);
    }

    public void deleteNotification(Long id) throws SyncopeClientCompositeErrorException {
        this.restTemplate.delete(this.baseURL + "notification/delete/{notificationId}.json", new Object[]{id});
    }

    public List<String> getMailTemplates() throws SyncopeClientCompositeErrorException {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "configuration/mailTemplates.json", String[].class, new Object[0]));
    }

    public List<String> getEvents() throws SyncopeClientCompositeErrorException {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "workflow/tasks.json", String[].class, new Object[0]));
    }
}

