/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.syncope.client.to.MembershipTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.pages.panels.AttributesPanel;
import org.syncope.console.pages.panels.DerivedAttributesPanel;
import org.syncope.console.pages.panels.VirtualAttributesPanel;

public class MembershipModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -4360802478081432549L;
    private AjaxButton submit;

    public MembershipModalPage(final PageReference pageRef, final ModalWindow window, final MembershipTO membershipTO, boolean templateMode) {
        Form form = new Form("MembershipForm");
        final UserTO userTO = ((UserModalPage)pageRef.getPage()).getUserTO();
        form.setModel((IModel)new CompoundPropertyModel((Object)membershipTO));
        this.submit = new AjaxButton("submit", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                userTO.removeMembership(membershipTO);
                userTO.addMembership(membershipTO);
                ((UserModalPage)pageRef.getPage()).setUserTO(userTO);
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{MembershipModalPage.this.feedbackPanel});
            }
        };
        String allowedRoles = userTO.getId() == 0L ? this.xmlRolesReader.getAllAllowedRoles("Users", "create") : this.xmlRolesReader.getAllAllowedRoles("Users", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)RENDER, (String)allowedRoles);
        form.add(new Component[]{this.submit});
        form.add(new Component[]{new AttributesPanel("attributes", membershipTO, form, templateMode)});
        form.add(new Component[]{new DerivedAttributesPanel("derivedAttributes", membershipTO)});
        form.add(new Component[]{new VirtualAttributesPanel("virtualAttributes", membershipTO, templateMode)});
        this.add(new Component[]{form});
    }
}

