/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.util.ClassUtils;
import org.syncope.client.to.ConnInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.SchemaMappingTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Resources;
import org.syncope.console.pages.panels.ResourceSecurityPanel;
import org.syncope.console.rest.ConnectorRestClient;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDecoratedCheckbox;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxNumberFieldPanel;
import org.syncope.console.wicket.markup.html.form.AjaxPasswordFieldPanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.FieldPanel;
import org.syncope.console.wicket.markup.html.form.MultiValueSelectorPanel;
import org.syncope.types.ConnConfProperty;
import org.syncope.types.IntMappingType;
import org.syncope.types.PropagationMode;
import org.syncope.types.TraceLevel;

public class ResourceModalPage
extends BaseModalPage {
    private static final long serialVersionUID = 1734415311027284221L;
    private static final String GUARDED_STRING = "org.identityconnectors.common.security.GuardedString";
    private static final String GUARDED_BYTE_ARRAY = "org.identityconnectors.common.security.GuardedByteArray";
    private static final List<Class> NUMBER = Arrays.asList(Integer.class, Double.class, Long.class, Float.class, Number.class, Integer.TYPE, Long.TYPE, Double.TYPE, Float.TYPE);
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private ConnectorRestClient connectorRestClient;
    @SpringBean
    private ResourceRestClient restClient;
    private List<String> uSchemaAttrNames;
    private List<String> uDerSchemaAttrNames;
    private List<String> uVirSchemaAttrNames;
    private WebMarkupContainer mappingContainer;
    private WebMarkupContainer connectorPropertiesContainer;
    private Set<ConnConfProperty> overridableConnectorProperties;
    private List<String> resourceSchemaNames;
    final ResourceTO resourceTO;
    final ListView<SchemaMappingTO> mappings;
    final AjaxButton addSchemaMappingBtn;

    public ResourceModalPage(final PageReference callPageRef, final ModalWindow window, final ResourceTO resourceTO, final boolean createFlag) {
        this.resourceTO = resourceTO;
        this.uSchemaAttrNames = this.schemaRestClient.getSchemaNames("user");
        this.uDerSchemaAttrNames = this.schemaRestClient.getDerivedSchemaNames("user");
        this.uVirSchemaAttrNames = this.schemaRestClient.getVirtualSchemaNames("user");
        LoadableDetachableModel<List<ConnInstanceTO>> connectors = new LoadableDetachableModel<List<ConnInstanceTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<ConnInstanceTO> load() {
                return ResourceModalPage.this.connectorRestClient.getAllConnectors();
            }
        };
        LoadableDetachableModel<List<IntMappingType>> intMappingTypes = new LoadableDetachableModel<List<IntMappingType>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<IntMappingType> load() {
                return Arrays.asList(IntMappingType.values());
            }
        };
        LoadableDetachableModel<List<ConnConfProperty>> connectorPropertiesModel = new LoadableDetachableModel<List<ConnConfProperty>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<ConnConfProperty> load() {
                Set props = resourceTO.getConnectorConfigurationProperties();
                if (props == null || props.isEmpty() || createFlag) {
                    props = ResourceModalPage.this.overridableConnectorProperties;
                }
                return new ArrayList<ConnConfProperty>(props);
            }
        };
        this.updateResourceSchemaNames(resourceTO);
        this.updateConnectorProperties(resourceTO.getConnectorId());
        final ConnInstanceTO connectorTO = new ConnInstanceTO();
        if (!createFlag) {
            connectorTO.setId(resourceTO.getConnectorId());
        }
        Form form = new Form("form");
        form.setModel((IModel)new CompoundPropertyModel((Object)resourceTO));
        AjaxTextFieldPanel resourceName = new AjaxTextFieldPanel("name", this.getString("name"), (IModel<String>)new PropertyModel((Object)resourceTO, "name"), false);
        resourceName.setEnabled(createFlag);
        resourceName.addRequiredLabel();
        form.add(new Component[]{resourceName});
        AjaxTextFieldPanel accountLink = new AjaxTextFieldPanel("accountLink", this.getString("accountLink"), (IModel<String>)new PropertyModel((Object)resourceTO, "accountLink"), false);
        form.add(new Component[]{accountLink});
        AjaxCheckBoxPanel forceMandatoryConstraint = new AjaxCheckBoxPanel("forceMandatoryConstraint", this.getString("forceMandatoryConstraint"), (IModel<Boolean>)new PropertyModel((Object)resourceTO, "forceMandatoryConstraint"), false);
        form.add(new Component[]{forceMandatoryConstraint});
        AjaxCheckBoxPanel propagationPrimary = new AjaxCheckBoxPanel("propagationPrimary", this.getString("propagationPrimary"), (IModel<Boolean>)new PropertyModel((Object)resourceTO, "propagationPrimary"), false);
        form.add(new Component[]{propagationPrimary});
        AjaxNumberFieldPanel propagationPriority = new AjaxNumberFieldPanel("propagationPriority", this.getString("propagationPriority"), (IModel<Number>)new PropertyModel((Object)resourceTO, "propagationPriority"), Integer.class, false);
        form.add(new Component[]{propagationPriority});
        AjaxDropDownChoicePanel<PropagationMode> propagationMode = new AjaxDropDownChoicePanel<PropagationMode>("propagationMode", this.getString("propagationMode"), (IModel<PropagationMode>)new PropertyModel((Object)resourceTO, "propagationMode"), false);
        propagationMode.setChoices(Arrays.asList(PropagationMode.values()));
        form.add(new Component[]{propagationMode});
        AjaxDropDownChoicePanel<TraceLevel> createTraceLevel = new AjaxDropDownChoicePanel<TraceLevel>("createTraceLevel", this.getString("createTraceLevel"), (IModel<TraceLevel>)new PropertyModel((Object)resourceTO, "createTraceLevel"), false);
        createTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        form.add(new Component[]{createTraceLevel});
        AjaxDropDownChoicePanel<TraceLevel> updateTraceLevel = new AjaxDropDownChoicePanel<TraceLevel>("updateTraceLevel", this.getString("updateTraceLevel"), (IModel<TraceLevel>)new PropertyModel((Object)resourceTO, "updateTraceLevel"), false);
        updateTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        form.add(new Component[]{updateTraceLevel});
        AjaxDropDownChoicePanel<TraceLevel> deleteTraceLevel = new AjaxDropDownChoicePanel<TraceLevel>("deleteTraceLevel", this.getString("deleteTraceLevel"), (IModel<TraceLevel>)new PropertyModel((Object)resourceTO, "deleteTraceLevel"), false);
        deleteTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        form.add(new Component[]{deleteTraceLevel});
        AjaxDropDownChoicePanel<TraceLevel> syncTraceLevel = new AjaxDropDownChoicePanel<TraceLevel>("syncTraceLevel", this.getString("syncTraceLevel"), (IModel<TraceLevel>)new PropertyModel((Object)resourceTO, "syncTraceLevel"), false);
        syncTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        form.add(new Component[]{syncTraceLevel});
        final AjaxCheckBoxPanel resetToken = new AjaxCheckBoxPanel("resetToken", this.getString("resetToken"), (IModel<Boolean>)new Model(null), false);
        resetToken.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget art) {
                if (((Boolean)resetToken.getModelObject()).booleanValue()) {
                    resourceTO.setSyncToken(null);
                }
            }
        }});
        form.add(new Component[]{resetToken});
        this.mappingContainer = new WebMarkupContainer("mappingContainer");
        this.mappingContainer.setOutputMarkupId(true);
        form.add(new Component[]{this.mappingContainer});
        this.connectorPropertiesContainer = new WebMarkupContainer("connectorPropertiesContainer");
        this.connectorPropertiesContainer.setOutputMarkupId(true);
        form.add(new Component[]{this.connectorPropertiesContainer});
        AjaxDropDownChoicePanel connector = new AjaxDropDownChoicePanel("connector", this.getString("connector"), new Model((Serializable)connectorTO), false);
        connector.setChoices((List)connectors.getObject());
        connector.setChoiceRenderer((IChoiceRenderer)new ChoiceRenderer("displayName", "id"));
        connector.getField().setModel((IModel)new IModel<ConnInstanceTO>(){
            private static final long serialVersionUID = -4202872830392400310L;

            public ConnInstanceTO getObject() {
                return connectorTO;
            }

            public void setObject(ConnInstanceTO connector) {
                resourceTO.setConnectorId(connector.getId());
            }

            public void detach() {
            }
        });
        connector.addRequiredLabel();
        connector.setEnabled(createFlag);
        form.add(new Component[]{connector});
        this.mappings = new ListView<SchemaMappingTO>("mappings", resourceTO.getMappings(), (IModel)intMappingTypes){
            private static final long serialVersionUID = 4949588177564901031L;
            final /* synthetic */ IModel val$intMappingTypes;
            {
                this.val$intMappingTypes = iModel;
                super(x0, x1);
            }

            protected void populateItem(final ListItem<SchemaMappingTO> item) {
                FieldPanel extAttrName;
                final SchemaMappingTO mappingTO = (SchemaMappingTO)item.getModelObject();
                item.add(new Component[]{new AjaxDecoratedCheckbox("toRemove", (IModel)new Model((Serializable)Boolean.FALSE)){
                    private static final long serialVersionUID = 7170946748485726506L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        int index = -1;
                        for (int i = 0; i < resourceTO.getMappings().size() && index == -1; ++i) {
                            if (!mappingTO.equals(resourceTO.getMappings().get(i))) continue;
                            index = i;
                        }
                        if (index != -1) {
                            resourceTO.getMappings().remove(index);
                            item.getParent().removeAll();
                            target.add(new Component[]{ResourceModalPage.this.mappingContainer});
                        }
                    }

                    @Override
                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = -7927968187160354605L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "} " + "else {this.checked = false;}";
                            }
                        };
                    }
                }});
                AjaxDropDownChoicePanel<String> intAttrNames = new AjaxDropDownChoicePanel<String>("intAttrNames", this.getString("intAttrNames"), (IModel<String>)new PropertyModel((Object)mappingTO, "intAttrName"), true);
                intAttrNames.setChoices(ResourceModalPage.this.resourceSchemaNames);
                intAttrNames.setRequired(true);
                intAttrNames.setStyleShet("ui-widget-content ui-corner-all short_fixedsize");
                if (mappingTO.getIntMappingType() == null) {
                    intAttrNames.setChoices(Collections.EMPTY_LIST);
                } else {
                    switch (mappingTO.getIntMappingType()) {
                        case UserSchema: {
                            intAttrNames.setChoices(ResourceModalPage.this.uSchemaAttrNames);
                            break;
                        }
                        case UserDerivedSchema: {
                            intAttrNames.setChoices(ResourceModalPage.this.uDerSchemaAttrNames);
                            break;
                        }
                        case UserVirtualSchema: {
                            intAttrNames.setChoices(ResourceModalPage.this.uVirSchemaAttrNames);
                            break;
                        }
                        case SyncopeUserId: {
                            intAttrNames.setEnabled(false);
                            intAttrNames.setRequired(false);
                            intAttrNames.setChoices(Collections.EMPTY_LIST);
                            mappingTO.setIntAttrName("SyncopeUserId");
                            break;
                        }
                        case Password: {
                            intAttrNames.setEnabled(false);
                            intAttrNames.setRequired(false);
                            intAttrNames.setChoices(Collections.EMPTY_LIST);
                            mappingTO.setIntAttrName("Password");
                            break;
                        }
                        case Username: {
                            intAttrNames.setEnabled(false);
                            intAttrNames.setRequired(false);
                            intAttrNames.setChoices(Collections.EMPTY_LIST);
                            mappingTO.setIntAttrName("Username");
                            break;
                        }
                        default: {
                            intAttrNames.setChoices(Collections.EMPTY_LIST);
                        }
                    }
                }
                item.add(new Component[]{intAttrNames});
                IntMappingTypesDropDownChoice mappingTypesPanel = new IntMappingTypesDropDownChoice("intMappingTypes", this.getString("intMappingTypes"), (PropertyModel<IntMappingType>)new PropertyModel((Object)mappingTO, "intMappingType"), intAttrNames);
                mappingTypesPanel.setRequired(true);
                mappingTypesPanel.setChoices((List)this.val$intMappingTypes.getObject());
                mappingTypesPanel.setStyleShet("ui-widget-content ui-corner-all short_fixedsize");
                item.add(new Component[]{mappingTypesPanel});
                if (ResourceModalPage.this.resourceSchemaNames.isEmpty()) {
                    extAttrName = new AjaxTextFieldPanel("extAttrName", this.getString("extAttrNames"), (IModel<String>)new PropertyModel((Object)mappingTO, "extAttrName"), true);
                } else {
                    extAttrName = new AjaxDropDownChoicePanel("extAttrName", this.getString("extAttrNames"), new PropertyModel((Object)mappingTO, "extAttrName"), true);
                    ((AjaxDropDownChoicePanel)extAttrName).setChoices(ResourceModalPage.this.resourceSchemaNames);
                }
                boolean required = mappingTO != null && !mappingTO.isAccountid() && !mappingTO.isPassword();
                extAttrName.setRequired(required);
                extAttrName.setEnabled(required);
                extAttrName.setStyleShet("ui-widget-content ui-corner-all short_fixedsize");
                item.add(new Component[]{extAttrName});
                AjaxTextFieldPanel mandatoryCondition = new AjaxTextFieldPanel("mandatoryCondition", this.getString("mandatoryCondition"), (IModel<String>)new PropertyModel((Object)mappingTO, "mandatoryCondition"), true);
                mandatoryCondition.setChoices(Arrays.asList("true", "false"));
                mandatoryCondition.setStyleShet("ui-widget-content ui-corner-all short_fixedsize");
                item.add(new Component[]{mandatoryCondition});
                final AjaxCheckBoxPanel accountId = new AjaxCheckBoxPanel("accountId", this.getString("accountId"), (IModel<Boolean>)new PropertyModel((Object)mappingTO, "accountid"), false);
                accountId.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        extAttrName.setEnabled((Boolean)accountId.getModelObject() == false && !mappingTO.isPassword());
                        extAttrName.setModelObject(null);
                        extAttrName.setRequired((Boolean)accountId.getModelObject() == false);
                        target.add(new Component[]{extAttrName});
                    }
                }});
                item.add(new Component[]{accountId});
                final AjaxCheckBoxPanel password = new AjaxCheckBoxPanel("password", this.getString("password"), (IModel<Boolean>)new PropertyModel((Object)mappingTO, "password"), true);
                password.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        extAttrName.setEnabled(!mappingTO.isAccountid() && (Boolean)password.getModelObject() == false);
                        extAttrName.setModelObject(null);
                        extAttrName.setRequired((Boolean)password.getModelObject() == false);
                        target.add(new Component[]{extAttrName});
                    }
                }});
                item.add(new Component[]{password});
            }
        };
        this.mappings.setReuseItems(true);
        this.mappingContainer.add(new Component[]{this.mappings});
        this.addSchemaMappingBtn = new IndicatingAjaxButton("addUserSchemaMappingBtn", (IModel)new ResourceModel("add")){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                resourceTO.getMappings().add(new SchemaMappingTO());
                target.add(new Component[]{ResourceModalPage.this.mappingContainer});
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        this.addSchemaMappingBtn.setDefaultFormProcessing(false);
        this.addSchemaMappingBtn.setEnabled(!createFlag);
        this.mappingContainer.add(new Component[]{this.addSchemaMappingBtn});
        this.connectorPropertiesContainer.add(new Component[]{new ListView<ConnConfProperty>("connectorProperties", (IModel)connectorPropertiesModel){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<ConnConfProperty> item) {
                FieldPanel field;
                ConnConfProperty property = (ConnConfProperty)item.getModelObject();
                Label label = new Label("connPropAttrSchema", property.getSchema().getDisplayName() == null || property.getSchema().getDisplayName().isEmpty() ? property.getSchema().getName() : property.getSchema().getDisplayName());
                item.add(new Component[]{label});
                boolean required = false;
                boolean isArray = false;
                if (ResourceModalPage.GUARDED_STRING.equalsIgnoreCase(property.getSchema().getType()) || ResourceModalPage.GUARDED_BYTE_ARRAY.equalsIgnoreCase(property.getSchema().getType())) {
                    field = new AjaxPasswordFieldPanel("panel", label.getDefaultModelObjectAsString(), (IModel<String>)new Model(), true);
                    ((PasswordTextField)field.getField()).setResetPassword(false);
                    required = property.getSchema().isRequired();
                } else {
                    Class<String> propertySchemaClass;
                    try {
                        propertySchemaClass = ClassUtils.forName((String)property.getSchema().getType(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                    }
                    catch (Exception e) {
                        BaseModalPage.LOG.error("Error parsing attribute type", (Throwable)e);
                        propertySchemaClass = String.class;
                    }
                    if (NUMBER.contains(propertySchemaClass)) {
                        field = new AjaxNumberFieldPanel("panel", label.getDefaultModelObjectAsString(), (IModel<Number>)new Model(), ClassUtils.resolvePrimitiveIfNecessary(propertySchemaClass), true);
                        required = property.getSchema().isRequired();
                    } else if (Boolean.class.equals(propertySchemaClass) || Boolean.TYPE.equals(propertySchemaClass)) {
                        field = new AjaxCheckBoxPanel("panel", label.getDefaultModelObjectAsString(), (IModel<Boolean>)new Model(), true);
                    } else {
                        field = new AjaxTextFieldPanel("panel", label.getDefaultModelObjectAsString(), (IModel<String>)new Model(), true);
                        required = property.getSchema().isRequired();
                    }
                    if (String[].class.equals(propertySchemaClass)) {
                        isArray = true;
                    }
                }
                field.setTitle(property.getSchema().getHelpMessage());
                if (isArray) {
                    field.removeRequiredLabel();
                    if (property.getValues().isEmpty()) {
                        property.getValues().add(null);
                    }
                    MultiValueSelectorPanel multiFields = new MultiValueSelectorPanel("panel", new PropertyModel((Object)property, "values"), String.class, field, true);
                    item.add(new Component[]{multiFields});
                } else {
                    if (required) {
                        field.addRequiredLabel();
                    }
                    field.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                        private static final long serialVersionUID = -1107858522700306810L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new MultiValueSelectorPanel.MultiValueSelectorEvent(target));
                        }
                    }});
                    field.setNewModel(property.getValues());
                    item.add(new Component[]{field});
                }
                resourceTO.getConnectorConfigurationProperties().add(property);
            }
        }});
        connector.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                ResourceModalPage.this.mappings.removeAll();
                ResourceModalPage.this.addSchemaMappingBtn.setEnabled(resourceTO.getConnectorId() != null && resourceTO.getConnectorId() > 0L);
                ResourceModalPage.this.updateResourceSchemaNames(resourceTO);
                target.add(new Component[]{ResourceModalPage.this.mappingContainer});
                ResourceModalPage.this.updateConnectorProperties(resourceTO.getConnectorId());
                target.add(new Component[]{ResourceModalPage.this.connectorPropertiesContainer});
            }
        }});
        form.add(new Component[]{new ResourceSecurityPanel("security", resourceTO)});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                ResourceTO resourceTO = (ResourceTO)form.getDefaultModelObject();
                int accountIdCount = 0;
                for (SchemaMappingTO mapping : resourceTO.getMappings()) {
                    if (!mapping.isAccountid()) continue;
                    ++accountIdCount;
                }
                if (accountIdCount == 0 || accountIdCount > 1) {
                    this.error((Serializable)((Object)this.getString("accountIdValidation")));
                    target.add(new Component[]{ResourceModalPage.this.feedbackPanel});
                } else {
                    try {
                        if (createFlag) {
                            ResourceModalPage.this.restClient.create(resourceTO);
                        } else {
                            ResourceModalPage.this.restClient.update(resourceTO);
                        }
                        ((Resources)callPageRef.getPage()).setModalResult(true);
                        window.close(target);
                    }
                    catch (SyncopeClientCompositeErrorException e) {
                        BaseModalPage.LOG.error("While creating/updating resource {}", (Object)resourceTO);
                        this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                        target.add(new Component[]{ResourceModalPage.this.feedbackPanel});
                    }
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{ResourceModalPage.this.feedbackPanel});
            }
        };
        form.add(new Component[]{submit});
        this.add(new Component[]{form});
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Resources", createFlag ? "create" : "update"));
    }

    public final void updateResourceSchemaNames(ResourceTO resourceTO) {
        try {
            this.resourceSchemaNames = resourceTO != null && resourceTO.getConnectorId() != null ? this.connectorRestClient.getSchemaNames(resourceTO) : Collections.EMPTY_LIST;
        }
        catch (Exception e) {
            LOG.warn("Error retrieving resource schema names", (Throwable)e);
            this.resourceSchemaNames = Collections.EMPTY_LIST;
        }
    }

    public final void updateConnectorProperties(Long connectorId) {
        if (connectorId != null && connectorId > 0L) {
            HashSet<ConnConfProperty> overridableProperties = new HashSet<ConnConfProperty>();
            for (ConnConfProperty p : this.connectorRestClient.getConnectorProperties(connectorId)) {
                if (!p.isOverridable()) continue;
                overridableProperties.add(p);
            }
            this.overridableConnectorProperties = overridableProperties;
        } else {
            this.overridableConnectorProperties = Collections.emptySet();
        }
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof MultiValueSelectorPanel.MultiValueSelectorEvent) {
            AjaxRequestTarget target = ((MultiValueSelectorPanel.MultiValueSelectorEvent)event.getPayload()).getTarget();
            this.mappings.removeAll();
            this.addSchemaMappingBtn.setEnabled(this.resourceTO.getConnectorId() != null && this.resourceTO.getConnectorId() > 0L);
            this.updateResourceSchemaNames(this.resourceTO);
            target.add(new Component[]{this.mappingContainer});
        }
    }

    private class IntMappingTypesDropDownChoice
    extends AjaxDropDownChoicePanel {
        private static final long serialVersionUID = -2855668124505116627L;

        public IntMappingTypesDropDownChoice(String id, String name, final PropertyModel<IntMappingType> model, final AjaxDropDownChoicePanel<String> chooserToPopulate) {
            super(id, name, model, false);
            this.field.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    List result;
                    chooserToPopulate.setRequired(true);
                    chooserToPopulate.setEnabled(true);
                    switch ((IntMappingType)model.getObject()) {
                        case UserSchema: {
                            result = ResourceModalPage.this.uSchemaAttrNames;
                            break;
                        }
                        case UserDerivedSchema: {
                            result = ResourceModalPage.this.uDerSchemaAttrNames;
                            break;
                        }
                        case UserVirtualSchema: {
                            result = ResourceModalPage.this.uVirSchemaAttrNames;
                            break;
                        }
                        default: {
                            chooserToPopulate.setRequired(false);
                            chooserToPopulate.setEnabled(false);
                            result = Collections.EMPTY_LIST;
                        }
                    }
                    chooserToPopulate.setChoices(result);
                    target.add(new Component[]{chooserToPopulate});
                }
            }});
        }
    }
}

