/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.string.Strings;
import org.syncope.client.AbstractBaseBean;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.AbstractSchemaModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.types.SchemaType;

public class SchemaModalPage
extends AbstractSchemaModalPage {
    private static final long serialVersionUID = -5991561277287424057L;

    public SchemaModalPage(String kind) {
        super(kind);
    }

    @Override
    public void setSchemaModalPage(final PageReference callerPageRef, final ModalWindow window, AbstractBaseBean schemaTO, final boolean createFlag) {
        final SchemaTO schema = schemaTO == null ? new SchemaTO() : (SchemaTO)schemaTO;
        final Form schemaForm = new Form("form");
        schemaForm.setModel((IModel)new CompoundPropertyModel((Object)schema));
        schemaForm.setOutputMarkupId(Boolean.TRUE.booleanValue());
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", this.getString("name"), (IModel<String>)new PropertyModel((Object)schema, "name"), true);
        name.addRequiredLabel();
        name.setEnabled(createFlag);
        AjaxTextFieldPanel conversionPattern = new AjaxTextFieldPanel("conversionPattern", this.getString("conversionPattern"), (IModel<String>)new PropertyModel((Object)schema, "conversionPattern"), true);
        LoadableDetachableModel<List<String>> validatorsList = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return SchemaModalPage.this.restClient.getAllValidatorClasses();
            }
        };
        AjaxDropDownChoicePanel validatorClass = new AjaxDropDownChoicePanel("validatorClass", this.getString("validatorClass"), new PropertyModel((Object)schema, "validatorClass"), true);
        ((DropDownChoice)validatorClass.getField()).setNullValid(true);
        validatorClass.setChoices((List)validatorsList.getObject());
        final AjaxDropDownChoicePanel<SchemaType> type = new AjaxDropDownChoicePanel<SchemaType>("type", this.getString("type"), (IModel<SchemaType>)new PropertyModel((Object)schema, "type"), false);
        type.setChoices(Arrays.asList(SchemaType.values()));
        type.addRequiredLabel();
        final AjaxTextFieldPanel enumerationValues = new AjaxTextFieldPanel("enumerationValues", this.getString("enumerationValues"), (IModel<String>)new PropertyModel((Object)schema, "enumerationValues"), false);
        if (schema != null && SchemaType.Enum.equals((Object)schema.getType())) {
            enumerationValues.addRequiredLabel();
            enumerationValues.setEnabled(Boolean.TRUE);
        } else {
            enumerationValues.removeRequiredLabel();
            enumerationValues.setEnabled(Boolean.FALSE);
        }
        type.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (SchemaType.Enum.ordinal() == Integer.parseInt(type.getField().getValue())) {
                    enumerationValues.addRequiredLabel();
                    enumerationValues.setEnabled(Boolean.TRUE);
                    enumerationValues.setModelObject((Serializable)((Object)schema.getEnumerationValues()));
                } else {
                    enumerationValues.removeRequiredLabel();
                    enumerationValues.setEnabled(Boolean.FALSE);
                    enumerationValues.setModelObject(null);
                }
                target.add(new Component[]{schemaForm});
            }
        }});
        AutoCompleteTextField mandatoryCondition = new AutoCompleteTextField("mandatoryCondition"){
            private static final long serialVersionUID = -2428903969518079100L;

            protected Iterator getChoices(String input) {
                List<Object> choices = new ArrayList();
                if (Strings.isEmpty((CharSequence)input)) {
                    choices = Collections.emptyList();
                    return choices.iterator();
                }
                if ("true".startsWith(input.toLowerCase())) {
                    choices.add("true");
                } else if ("false".startsWith(input.toLowerCase())) {
                    choices.add("false");
                }
                return choices.iterator();
            }
        };
        mandatoryCondition.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget art) {
            }
        }});
        AjaxCheckBoxPanel multivalue = new AjaxCheckBoxPanel("multivalue", this.getString("multivalue"), (IModel<Boolean>)new PropertyModel((Object)schema, "multivalue"), true);
        AjaxCheckBoxPanel readonly = new AjaxCheckBoxPanel("readonly", this.getString("readonly"), (IModel<Boolean>)new PropertyModel((Object)schema, "readonly"), true);
        AjaxCheckBoxPanel uniqueConstraint = new AjaxCheckBoxPanel("uniqueConstraint", this.getString("uniqueConstraint"), (IModel<Boolean>)new PropertyModel((Object)schema, "uniqueConstraint"), true);
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                SchemaTO schemaTO = (SchemaTO)form.getDefaultModelObject();
                if (schemaTO.isMultivalue() && schemaTO.isUniqueConstraint()) {
                    this.error((Serializable)((Object)this.getString("multivalueAndUniqueConstr.validation")));
                    target.add(new Component[]{SchemaModalPage.this.feedbackPanel});
                    return;
                }
                try {
                    if (createFlag) {
                        SchemaModalPage.this.restClient.createSchema(SchemaModalPage.this.kind, schemaTO);
                    } else {
                        SchemaModalPage.this.restClient.updateSchema(SchemaModalPage.this.kind, schemaTO);
                    }
                    if (callerPageRef.getPage() instanceof BasePage) {
                        ((BasePage)callerPageRef.getPage()).setModalResult(true);
                    }
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                    target.add(new Component[]{SchemaModalPage.this.feedbackPanel});
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{SchemaModalPage.this.feedbackPanel});
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Schema", "create") : this.xmlRolesReader.getAllAllowedRoles("Schema", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        schemaForm.add(new Component[]{name});
        schemaForm.add(new Component[]{conversionPattern});
        schemaForm.add(new Component[]{validatorClass});
        schemaForm.add(new Component[]{type});
        schemaForm.add(new Component[]{enumerationValues});
        schemaForm.add(new Component[]{mandatoryCondition});
        schemaForm.add(new Component[]{multivalue});
        schemaForm.add(new Component[]{readonly});
        schemaForm.add(new Component[]{uniqueConstraint});
        schemaForm.add(new Component[]{submit});
        this.add(new Component[]{schemaForm});
    }
}

