/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.syncope.client.to.SchedTaskTO;
import org.syncope.client.to.TaskExecTO;
import org.syncope.client.to.TaskTO;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.panels.NotificationTasks;
import org.syncope.console.pages.panels.PropagationTasks;
import org.syncope.console.pages.panels.SchedTasks;
import org.syncope.console.pages.panels.SyncTasks;
import org.syncope.console.rest.TaskRestClient;

public class Tasks
extends BasePage {
    private static final long serialVersionUID = 5289215853622289061L;

    public Tasks(PageParameters parameters) {
        this.add(new Component[]{new PropagationTasks("propagation")});
        this.add(new Component[]{new NotificationTasks("notification")});
        this.add(new Component[]{new SchedTasks("sched", this.getPageReference())});
        this.add(new Component[]{new SyncTasks("sync", this.getPageReference())});
    }

    @Override
    public void setWindowClosedCallback(ModalWindow window, WebMarkupContainer container) {
        super.setWindowClosedCallback(window, container);
    }

    public static class TasksProvider<T extends TaskTO>
    extends SortableDataProvider<T> {
        private SortableDataProviderComparator<T> comparator;
        private TaskRestClient restClient;
        private int paginatorRows;
        private String id;
        private Class<T> reference;

        public TasksProvider(TaskRestClient restClient, int paginatorRows, String id, Class<T> reference) {
            this.setSort("id", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator(this);
            this.paginatorRows = paginatorRows;
            this.restClient = restClient;
            this.id = id;
            this.reference = reference;
        }

        public Iterator<T> iterator(int first, int count) {
            ArrayList<TaskTO> tasks = new ArrayList<TaskTO>();
            for (TaskTO task : this.restClient.listTasks(this.reference, first / this.paginatorRows + 1, this.paginatorRows)) {
                if (task instanceof SchedTaskTO && ((SchedTaskTO)task).getLastExec() == null && task.getExecutions() != null && !task.getExecutions().isEmpty()) {
                    Collections.sort(task.getExecutions(), new Comparator<TaskExecTO>(){

                        @Override
                        public int compare(TaskExecTO left, TaskExecTO right) {
                            return left.getStartDate().compareTo(right.getStartDate());
                        }
                    });
                    ((SchedTaskTO)task).setLastExec(((TaskExecTO)task.getExecutions().get(task.getExecutions().size() - 1)).getStartDate());
                }
                tasks.add(task);
            }
            Collections.sort(tasks, this.comparator);
            return tasks.iterator();
        }

        public int size() {
            return this.restClient.count(this.id);
        }

        public IModel<T> model(T object) {
            return new CompoundPropertyModel(object);
        }
    }

    public static class TaskExecutionsProvider
    extends SortableDataProvider<TaskExecTO> {
        private static final long serialVersionUID = -5401263348984206145L;
        private SortableDataProviderComparator<TaskExecTO> comparator;
        private TaskTO taskTO;

        public TaskExecutionsProvider(TaskTO taskTO) {
            this.taskTO = taskTO;
            this.setSort("startDate", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<TaskExecTO>(this);
        }

        public Iterator<TaskExecTO> iterator(int first, int count) {
            List<TaskExecTO> list = this.getTaskDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getTaskDB().size();
        }

        public IModel<TaskExecTO> model(final TaskExecTO taskExecution) {
            return new AbstractReadOnlyModel<TaskExecTO>(){

                public TaskExecTO getObject() {
                    return taskExecution;
                }
            };
        }

        public List<TaskExecTO> getTaskDB() {
            return this.taskTO.getExecutions();
        }
    }
}

