/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.RoleTO;
import org.syncope.console.commons.SelectChoiceRenderer;
import org.syncope.console.pages.panels.AttributesPanel;
import org.syncope.console.pages.panels.DerivedAttributesPanel;
import org.syncope.console.pages.panels.ResourcesPanel;
import org.syncope.console.pages.panels.RoleSecurityPanel;
import org.syncope.console.pages.panels.VirtualAttributesPanel;
import org.syncope.console.rest.EntitlementRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;

public class RoleAttributesPanel
extends Panel {
    private static final long serialVersionUID = 4216376097320768369L;
    @SpringBean
    private EntitlementRestClient entitlementRestClient;
    final Palette<String> entitlementsPalette;

    public RoleAttributesPanel(String id, Form form, RoleTO roleTO) {
        super(id);
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel<String>)new PropertyModel((Object)roleTO, "name"), false);
        name.addRequiredLabel();
        this.add(new Component[]{name});
        this.add(new Component[]{new AttributesPanel("attributes", roleTO, form, false)});
        AjaxCheckBoxPanel inhAttributes = new AjaxCheckBoxPanel("inheritAttributes", "inheritAttributes", (IModel<Boolean>)new PropertyModel((Object)roleTO, "inheritAttributes"), false);
        this.add(new Component[]{inhAttributes});
        this.add(new Component[]{new DerivedAttributesPanel("derivedAttributes", roleTO)});
        AjaxCheckBoxPanel inhDerivedAttributes = new AjaxCheckBoxPanel("inheritDerivedAttributes", "inheritDerivedAttributes", (IModel<Boolean>)new PropertyModel((Object)roleTO, "inheritDerivedAttributes"), false);
        inhDerivedAttributes.setOutputMarkupId(true);
        this.add(new Component[]{inhDerivedAttributes});
        this.add(new Component[]{new VirtualAttributesPanel("virtualAttributes", roleTO, false)});
        AjaxCheckBoxPanel inhVirtualAttributes = new AjaxCheckBoxPanel("inheritVirtualAttributes", "inheritVirtualAttributes", (IModel<Boolean>)new PropertyModel((Object)roleTO, "inheritVirtualAttributes"), false);
        inhVirtualAttributes.setOutputMarkupId(true);
        this.add(new Component[]{inhVirtualAttributes});
        this.add(new Component[]{new RoleSecurityPanel("security", roleTO)});
        this.add(new Component[]{new ResourcesPanel("resources", roleTO)});
        ListModel selectedEntitlements = new ListModel(roleTO.getEntitlements());
        ListModel availableEntitlements = new ListModel(this.entitlementRestClient.getAllEntitlements());
        this.entitlementsPalette = new Palette("entitlementsPalette", (IModel)selectedEntitlements, (IModel)availableEntitlements, (IChoiceRenderer)new SelectChoiceRenderer(), 20, false);
        this.add(new Component[]{this.entitlementsPalette});
    }

    public Palette<String> getEntitlementsPalette() {
        return this.entitlementsPalette;
    }
}

