/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.SchedTaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.SchedTaskModalPage;
import org.syncope.console.pages.Tasks;
import org.syncope.console.rest.TaskRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public class SchedTasks
extends Panel {
    private static final int WIN_HEIGHT = 500;
    private static final int WIN_WIDTH = 700;
    private static final long serialVersionUID = 525486152284253354L;
    @SpringBean
    private TaskRestClient restClient;
    @SpringBean
    private PreferenceManager prefMan;
    private int paginatorRows;
    private WebMarkupContainer container = new WebMarkupContainer("container");
    private ModalWindow window;
    @SpringBean
    protected XMLRolesReader xmlRolesReader;

    public SchedTasks(String id, final PageReference callerPageRef) {
        super(id);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.window = new ModalWindow("taskWin");
        this.window.setCssClassName("w_silver");
        this.window.setInitialHeight(500);
        this.window.setInitialWidth(700);
        this.window.setCookieName("view-task-win");
        this.add(new Component[]{this.window});
        ((Tasks)callerPageRef.getPage()).setWindowClosedCallback(this.window, this.container);
        this.paginatorRows = this.prefMan.getPaginatorRows((Request)this.getWebRequest(), "schedtasks.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), "id", "id"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("class"), "jobClassName", "jobClassName"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("lastExec"), "lastExec", "lastExec"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("nextExec"), "nextExec", "nextExec"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("latestExecStatus"), "latestExecStatus", "latestExecStatus"));
        columns.add(new AbstractColumn<SchedTaskTO>((IModel)new ResourceModel("detail")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<SchedTaskTO>> cellItem, String componentId, IModel<SchedTaskTO> model) {
                final SchedTaskTO taskTO = (SchedTaskTO)model.getObject();
                IndicatingAjaxLink viewLink = new IndicatingAjaxLink("editLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        SchedTasks.this.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new SchedTaskModalPage(SchedTasks.this.window, taskTO, callerPageRef);
                            }
                        });
                        SchedTasks.this.window.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{viewLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)SchedTasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<SchedTaskTO>((IModel)new ResourceModel("execute")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<SchedTaskTO>> cellItem, String componentId, IModel<SchedTaskTO> model) {
                final SchedTaskTO taskTO = (SchedTaskTO)model.getObject();
                IndicatingAjaxLink executeLink = new IndicatingAjaxLink("link"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            SchedTasks.this.restClient.startExecution(taskTO.getId(), false);
                            this.getSession().info((Serializable)((Object)this.getString("operation_succeded")));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{this.getPage().get("feedback")});
                        target.add(new Component[]{SchedTasks.this.container});
                    }
                };
                executeLink.add(new Component[]{new Label("linkTitle", SchedTasks.this.getString("execute"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{executeLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)SchedTasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "execute"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<SchedTaskTO>((IModel)new ResourceModel("executeDryRun")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<SchedTaskTO>> cellItem, String componentId, IModel<SchedTaskTO> model) {
                final SchedTaskTO taskTO = (SchedTaskTO)model.getObject();
                IndicatingAjaxLink executeLink = new IndicatingAjaxLink("link"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            SchedTasks.this.restClient.startExecution(taskTO.getId(), true);
                            this.getSession().info((Serializable)((Object)this.getString("operation_succeded")));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{this.getPage().get("feedback")});
                        target.add(new Component[]{SchedTasks.this.container});
                    }
                };
                executeLink.add(new Component[]{new Label("linkTitle", SchedTasks.this.getString("executeDryRun"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{executeLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)SchedTasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "execute"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<SchedTaskTO>((IModel)new ResourceModel("delete")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<SchedTaskTO>> cellItem, String componentId, IModel<SchedTaskTO> model) {
                final SchedTaskTO taskTO = (SchedTaskTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            SchedTasks.this.restClient.delete(taskTO.getId());
                            this.info((Serializable)((Object)this.getString("operation_succeded")));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{SchedTasks.this.container});
                        target.add(new Component[]{this.getPage().get("feedback")});
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)SchedTasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, new Tasks.TasksProvider<SchedTaskTO>(this.restClient, this.paginatorRows, this.getId(), SchedTaskTO.class), this.paginatorRows);
        this.container.add(new Component[]{table});
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                SchedTasks.this.prefMan.set((Request)SchedTasks.this.getWebRequest(), (Response)((WebResponse)SchedTasks.this.getResponse()), "schedtasks.paginator.rows", String.valueOf(SchedTasks.this.paginatorRows));
                table.setItemsPerPage(SchedTasks.this.paginatorRows);
                target.add(new Component[]{SchedTasks.this.container});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
        IndicatingAjaxLink createLink = new IndicatingAjaxLink("createLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                SchedTasks.this.window.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new SchedTaskModalPage(SchedTasks.this.window, new SchedTaskTO(), callerPageRef);
                    }
                });
                SchedTasks.this.window.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createLink, (Action)RENDER, (String)this.xmlRolesReader.getAllAllowedRoles("Tasks", "create"));
        this.add(new Component[]{createLink});
    }
}

