/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.syncope.client.to.ConnBundleTO;
import org.syncope.client.to.ConnInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.SyncopeSession;
import org.syncope.console.rest.AbstractBaseRestClient;
import org.syncope.types.ConnConfProperty;

@Component
public class ConnectorRestClient
extends AbstractBaseRestClient {
    public List<ConnInstanceTO> getAllConnectors() {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "connector/list.json?lang=" + SyncopeSession.get().getLocale(), ConnInstanceTO[].class, new Object[0]));
    }

    public void create(ConnInstanceTO connectorTO) {
        this.filterProperties(connectorTO.getConfiguration());
        this.restTemplate.postForObject(this.baseURL + "connector/create.json", (Object)connectorTO, ConnInstanceTO.class, new Object[0]);
    }

    public ConnInstanceTO read(Long connectorInstanceId) {
        ConnInstanceTO connectorTO = null;
        try {
            connectorTO = (ConnInstanceTO)this.restTemplate.getForObject(this.baseURL + "connector/read/" + connectorInstanceId, ConnInstanceTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a connector", (Throwable)e);
        }
        return connectorTO;
    }

    public void update(ConnInstanceTO connectorTO) {
        this.filterProperties(connectorTO.getConfiguration());
        this.restTemplate.postForObject(this.baseURL + "connector/update.json", (Object)connectorTO, ConnInstanceTO.class, new Object[0]);
    }

    public void delete(Long id) {
        this.restTemplate.delete(this.baseURL + "connector/delete/{connectorId}.json", new Object[]{id.toString()});
    }

    public List<ConnBundleTO> getAllBundles() {
        List<Object> bundles = null;
        try {
            bundles = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "connector/bundle/list?lang=" + SyncopeSession.get().getLocale(), ConnBundleTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting connector bundles", (Throwable)e);
        }
        return bundles;
    }

    public List<String> getSchemaNames(ResourceTO resourceTO) {
        List<Object> schemaNames = null;
        try {
            schemaNames = Arrays.asList((Object[])this.restTemplate.postForObject(this.baseURL + "connector/schema/list", (Object)resourceTO, String[].class, new Object[0]));
            Collections.sort(schemaNames);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting resource schema names", (Throwable)e);
        }
        return schemaNames;
    }

    public List<ConnConfProperty> getConnectorProperties(Long connectorId) {
        List<Object> properties = null;
        try {
            properties = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "connector/{connectorId}/configurationProperty/list", ConnConfProperty[].class, new Object[]{connectorId}));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting connector configuration properties", (Throwable)e);
        }
        return properties;
    }

    private void filterProperties(Set<ConnConfProperty> properties) {
        for (ConnConfProperty property : properties) {
            ArrayList parsed = new ArrayList();
            for (Object obj : property.getValues()) {
                if (obj == null || obj.toString().isEmpty()) continue;
                parsed.add(obj);
            }
            property.setValues(parsed);
        }
    }
}

