/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.AbstractBaseRestClient;

@Component
public class ResourceRestClient
extends AbstractBaseRestClient {
    public List<ResourceTO> getAllResources() {
        List<Object> resources = null;
        try {
            resources = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "resource/list.json", ResourceTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading all resources", (Throwable)e);
        }
        return resources;
    }

    public void create(ResourceTO resourceTO) {
        this.restTemplate.postForObject(this.baseURL + "resource/create", (Object)resourceTO, ResourceTO.class, new Object[0]);
    }

    public ResourceTO read(String name) {
        ResourceTO resourceTO = null;
        try {
            resourceTO = (ResourceTO)this.restTemplate.getForObject(this.baseURL + "resource/read/" + name + ".json", ResourceTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a resource", (Throwable)e);
        }
        return resourceTO;
    }

    public void update(ResourceTO resourceTO) {
        this.restTemplate.postForObject(this.baseURL + "resource/update.json", (Object)resourceTO, ResourceTO.class, new Object[0]);
    }

    public void delete(String name) {
        this.restTemplate.delete(this.baseURL + "resource/delete/{resourceName}.json", new Object[]{name});
    }
}

