/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.syncope.console.wicket.markup.html.form.AbstractFieldPanel;
import org.syncope.console.wicket.markup.html.form.FieldPanel;

public class MultiValueSelectorPanel<E>
extends AbstractFieldPanel {
    private static final long serialVersionUID = -6322397761456513324L;
    ListView<E> view;
    WebMarkupContainer container;

    public MultiValueSelectorPanel(String id, IModel<List<E>> model, Class reference, FieldPanel panelTemplate) {
        super(id, model);
        this.init(id, model, reference, panelTemplate, false);
    }

    public MultiValueSelectorPanel(String id, IModel<List<E>> model, Class reference, FieldPanel panelTemplate, boolean eventTemplate) {
        super(id, model);
        this.init(id, model, reference, panelTemplate, eventTemplate);
    }

    private void init(String id, final IModel<List<E>> model, final Class reference, final FieldPanel panelTemplate, final boolean sendEvent) {
        this.container = new WebMarkupContainer("multiValueContainer");
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.view = new ListView<E>("view", model){
            private static final long serialVersionUID = -9180479401817023838L;

            protected void populateItem(final ListItem<E> item) {
                final FieldPanel fieldPanel = panelTemplate.clone();
                if (sendEvent) {
                    fieldPanel.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                        private static final long serialVersionUID = -1107858522700306810L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new MultiValueSelectorEvent(target));
                        }
                    }});
                }
                fieldPanel.setNewModel(item, reference);
                item.add(new Component[]{fieldPanel});
                IndicatingAjaxLink minus = new IndicatingAjaxLink("drop"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        ((List)model.getObject()).remove(item.getModelObject());
                        fieldPanel.getField().clearInput();
                        target.add(new Component[]{MultiValueSelectorPanel.this.container});
                        if (sendEvent) {
                            this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new MultiValueSelectorEvent(target));
                        }
                    }
                };
                item.add(new Component[]{minus});
                if (((List)model.getObject()).size() <= 1) {
                    minus.setVisible(false);
                    minus.setEnabled(false);
                } else {
                    minus.setVisible(true);
                    minus.setEnabled(true);
                }
                if (item.getIndex() == ((List)model.getObject()).size() - 1) {
                    IndicatingAjaxLink plus = new IndicatingAjaxLink("add"){
                        private static final long serialVersionUID = -7978723352517770644L;

                        public void onClick(AjaxRequestTarget target) {
                            ((List)model.getObject()).add(null);
                            target.add(new Component[]{MultiValueSelectorPanel.this.container});
                        }
                    };
                    Fragment fragment = new Fragment("panelPlus", "fragmentPlus", (MarkupContainer)MultiValueSelectorPanel.this.container);
                    fragment.add(new Component[]{plus});
                    item.add(new Component[]{fragment});
                } else {
                    Fragment fragment = new Fragment("panelPlus", "emptyFragment", (MarkupContainer)MultiValueSelectorPanel.this.container);
                    item.add(new Component[]{fragment});
                }
            }
        };
        this.container.add(new Component[]{this.view.setOutputMarkupId(true)});
        this.setOutputMarkupId(true);
    }

    public ListView<E> getView() {
        return this.view;
    }

    public WebMarkupContainer getContainer() {
        return this.container;
    }

    public MultiValueSelectorPanel<E> setModelObject(Serializable object) {
        this.view.setModelObject((List)((Object)object));
        return this;
    }

    public static class MultiValueSelectorEvent {
        final AjaxRequestTarget target;

        public MultiValueSelectorEvent(AjaxRequestTarget target) {
            this.target = target;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }
}

