/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console;

import org.apache.wicket.Component;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.ComponentRenderingRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.syncope.console.SyncopeSession;
import org.syncope.console.pages.ErrorPage;

public class SyncopeRequestCycleListener
extends AbstractRequestCycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeRequestCycleListener.class);

    public IRequestHandler onException(RequestCycle cycle, Exception e) {
        ErrorPage errorPage;
        LOG.error("Exception found", (Throwable)e);
        PageParameters errorParameters = new PageParameters();
        errorParameters.add("errorTitle", (Object)new StringResourceModel("alert", null, new Object[0]).getString());
        if (e instanceof UnauthorizedInstantiationException) {
            errorParameters.add("errorMessage", (Object)new StringResourceModel("unauthorizedInstantiationException", null, new Object[0]).getString());
            errorPage = new ErrorPage(errorParameters);
        } else if (e instanceof HttpClientErrorException) {
            errorParameters.add("errorMessage", (Object)new StringResourceModel("httpClientException", null, new Object[0]).getString());
            errorPage = new ErrorPage(errorParameters);
        } else if (e instanceof PageExpiredException || !SyncopeSession.get().isAuthenticated()) {
            errorParameters.add("errorMessage", (Object)new StringResourceModel("pageExpiredException", null, new Object[0]).getString());
            errorPage = new ErrorPage(errorParameters);
        } else if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof RestClientException) {
            errorParameters.add("errorMessage", (Object)new StringResourceModel("restClientException", null, new Object[0]).getString());
            errorPage = new ErrorPage(errorParameters);
        } else {
            errorPage = new ExceptionErrorPage((Throwable)e, null);
        }
        return new ComponentRenderingRequestHandler((Component)errorPage);
    }
}

