/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.syncope.client.to.RoleTO;
import org.syncope.console.commons.RoleTreeBuilder;
import org.syncope.console.rest.RoleRestClient;

public class RoleTreeBuilder {
    @Autowired
    private RoleRestClient restClient;
    private RoleTOComparator comparator = new RoleTOComparator(null);

    private List<RoleTO> getChildRoles(long parentRoleId, List<RoleTO> roles) {
        ArrayList<RoleTO> result = new ArrayList<RoleTO>();
        for (RoleTO role : roles) {
            if (role.getParent() != parentRoleId) continue;
            result.add(role);
        }
        Collections.sort(result, this.comparator);
        return result;
    }

    private void populateSubtree(DefaultMutableTreeNode subRoot, List<RoleTO> roles) {
        RoleTO role = (RoleTO)subRoot.getUserObject();
        for (RoleTO subRoleTO : this.getChildRoles(role.getId(), roles)) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(subRoleTO);
            subRoot.add(child);
            this.populateSubtree(child, roles);
        }
    }

    public TreeModel build() {
        return this.build(this.restClient.getAllRoles());
    }

    public TreeModel build(List<RoleTO> roles) {
        DefaultMutableTreeNode fakeroot = new DefaultMutableTreeNode(new FakeRootRoleTO());
        this.populateSubtree(fakeroot, roles);
        return new DefaultTreeModel(fakeroot);
    }
}

