/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.to.UserTO;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.SyncopeSession;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.BasePage;
import org.syncope.console.rest.UserRequestRestClient;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public class BasePage
extends WebPage
implements IAjaxIndicatorAware {
    protected static final Logger LOG = LoggerFactory.getLogger(BasePage.class);
    private static final long serialVersionUID = 1571997737305598502L;
    private static final int EDIT_PROFILE_WIN_HEIGHT = 550;
    private static final int EDIT_PROFILE_WIN_WIDTH = 800;
    @SpringBean
    private UserRequestRestClient profileRestClient;
    @SpringBean
    protected XMLRolesReader xmlRolesReader;
    @SpringBean(name="version")
    private String version;
    protected FeedbackPanel feedbackPanel;
    protected boolean modalResult = false;

    public BasePage() {
        this.pageSetup();
    }

    public BasePage(PageParameters parameters) {
        super(parameters);
        this.pageSetup();
    }

    private void pageSetup() {
        Fragment editProfileFrag;
        ((SyncopeApplication)this.getApplication()).setupNavigationPane((WebPage)this, this.xmlRolesReader, true, this.version);
        this.feedbackPanel = new FeedbackPanel("feedback");
        this.feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanel});
        String kind = this.getClass().getSimpleName().toLowerCase();
        BookmarkablePageLink kindLink = (BookmarkablePageLink)this.get(kind);
        if (kindLink != null) {
            kindLink.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
            Component kindIcon = kindLink.get(0);
            if (kindIcon != null) {
                kindIcon.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
            }
        }
        ModalWindow editProfileModalWin = new ModalWindow("editProfileModal");
        editProfileModalWin.setCssClassName("w_silver");
        editProfileModalWin.setInitialHeight(550);
        editProfileModalWin.setInitialWidth(800);
        editProfileModalWin.setCookieName("edit-profile-modal");
        this.add(new Component[]{editProfileModalWin});
        this.add(new Component[]{new Label("username", SyncopeSession.get().getUserId())});
        if ("admin".equals(SyncopeSession.get().getUserId())) {
            editProfileFrag = new Fragment("editProfile", "adminEmptyFrag", (MarkupContainer)this);
        } else {
            UserTO userTO = SyncopeSession.get().isAuthenticated() ? this.profileRestClient.readProfile() : new UserTO();
            editProfileFrag = new Fragment("editProfile", "editProfileFrag", (MarkupContainer)this);
            3 editProfileLink = new /* Unavailable Anonymous Inner Class!! */;
            editProfileLink.add(new Component[]{new Label("linkTitle", this.getString("editProfile"))});
            LinkPanel panel = new LinkPanel("editProfile", (IModel)new ResourceModel("editProfile"));
            panel.add(new Component[]{editProfileLink});
            editProfileFrag.add(new Component[]{panel});
        }
        this.add(new Component[]{editProfileFrag});
    }

    public String getAjaxIndicatorMarkupId() {
        return "veil";
    }

    public FeedbackPanel getFeedbackPanel() {
        return this.feedbackPanel;
    }

    public boolean isModalResult() {
        return this.modalResult;
    }

    public void setModalResult(boolean operationResult) {
        this.modalResult = operationResult;
    }

    protected void setWindowClosedCallback(ModalWindow window, WebMarkupContainer container) {
        window.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

