/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.SyncopeConstants;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.console.pages.Schema;
import org.syncope.console.pages.panels.AttributesPanel;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateTimeFieldPanel;
import org.syncope.console.wicket.markup.html.form.FieldPanel;
import org.syncope.types.SchemaType;

public class AttributesPanel
extends Panel {
    private static final long serialVersionUID = 552437609667518888L;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    private final boolean templateMode;

    public <T extends AbstractAttributableTO> AttributesPanel(String id, T entityTO, Form form, boolean templateMode) {
        super(id);
        this.templateMode = templateMode;
        1 schemas = new /* Unavailable Anonymous Inner Class!! */;
        this.initEntityData(entityTO, ((Map)schemas.getObject()).values());
        2 attributeView = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{attributeView});
    }

    private List<AttributeTO> initEntityData(AbstractAttributableTO entityTO, Collection<SchemaTO> schemas) {
        ArrayList<AttributeTO> entityData = new ArrayList<AttributeTO>();
        Map attrMap = entityTO.getAttributeMap();
        for (SchemaTO schema : schemas) {
            AttributeTO attributeTO = new AttributeTO();
            attributeTO.setSchema(schema.getName());
            if (attrMap.get(schema.getName()) == null || ((AttributeTO)attrMap.get(schema.getName())).getValues().isEmpty()) {
                ArrayList<String> values = new ArrayList<String>();
                values.add("");
                attributeTO.setValues(values);
                attributeTO.setReadonly(schema.isReadonly());
            } else {
                attributeTO.setValues(((AttributeTO)attrMap.get(schema.getName())).getValues());
            }
            entityData.add(attributeTO);
        }
        entityTO.setAttributes(entityData);
        return entityData;
    }

    private FieldPanel getFieldPanel(SchemaTO schemaTO, Form form, AttributeTO attributeTO) {
        AjaxCheckBoxPanel panel;
        boolean required = this.templateMode ? false : schemaTO.getMandatoryCondition().equalsIgnoreCase("true");
        boolean readOnly = this.templateMode ? false : schemaTO.isReadonly();
        SchemaType type = this.templateMode ? SchemaType.String : schemaTO.getType();
        switch (3.$SwitchMap$org$syncope$types$SchemaType[type.ordinal()]) {
            case 1: {
                panel = new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel)new Model(), true);
                panel.setRequired(required);
                break;
            }
            case 2: {
                String dataPattern;
                String string = dataPattern = schemaTO.getConversionPattern() != null ? schemaTO.getConversionPattern() : SyncopeConstants.DEFAULT_DATE_PATTERN;
                if (!dataPattern.contains("H")) {
                    panel = new DateTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(), true, dataPattern);
                    if (!required) break;
                    panel.addRequiredLabel();
                    break;
                }
                panel = new DateTimeFieldPanel("panel", schemaTO.getName(), (IModel)new Model(), true, dataPattern);
                if (required) {
                    panel.addRequiredLabel();
                    ((DateTimeFieldPanel)panel).setFormValidator(form);
                }
                panel.setStyleShet("ui-widget-content ui-corner-all");
                break;
            }
            case 3: {
                panel = new AjaxDropDownChoicePanel("panel", schemaTO.getName(), (IModel)new Model(), true);
                ((AjaxDropDownChoicePanel)panel).setChoices(Arrays.asList(schemaTO.getEnumerationValues().split(Schema.enumValuesSeparator)));
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(), true);
                if (!required) break;
                panel.addRequiredLabel();
            }
        }
        panel.setReadOnly(readOnly);
        panel.setNewModel(attributeTO.getValues());
        return panel;
    }

    static /* synthetic */ SchemaRestClient access$000(AttributesPanel x0) {
        return x0.schemaRestClient;
    }

    static /* synthetic */ FieldPanel access$100(AttributesPanel x0, SchemaTO x1, Form x2, AttributeTO x3) {
        return x0.getFieldPanel(x1, x2, x3);
    }
}

